/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.FelEngineImpl;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ObjectUtils;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.FelNode;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionGet
extends StableFunction {
    String[][] a = new String[][]{{"a", "b"}, {"c", "d"}};
    int[][] num = new int[][]{{1, 2}, {3, 4}};

    @Override
    public Object call(FelNode node, FelContext context) {
        if (node.getChildCount() >= 2) {
            Object coll = TolerantFunction.eval(context, node.getChild(0));
            Object index = TolerantFunction.eval(context, node.getChild(1));
            int i = 0;
            if (index instanceof Number) {
                i = ((Number)index).intValue();
            }
            return CollectionGet.get(coll, i);
        }
        return null;
    }

    @Override
    public String getName() {
        return "[";
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        Class<Object> type = null;
        List<FelNode> children = node.getChildren();
        FelNode left = children.get(0);
        SourceBuilder leftMethod = left.toMethod(ctx);
        Class<?> leftType = leftMethod.returnType(ctx, left);
        if (!leftType.isArray() && !List.class.isAssignableFrom(leftType)) {
            return InterpreterSourceBuilder.getInstance();
        }
        FelNode right = children.get(1);
        SourceBuilder rightMethod = right.toMethod(ctx);
        Class<?> rightType = rightMethod.returnType(ctx, right);
        String leftSrc = leftMethod.source(ctx, left);
        String rightSrc = this.getRightSrc(ctx, right, rightMethod, rightType);
        String src = "";
        if (leftType.isArray()) {
            type = leftType.getComponentType();
            src = "(" + leftSrc + ")[" + rightSrc + "]";
        } else if (List.class.isAssignableFrom(leftType)) {
            type = Object.class;
            src = "(" + leftSrc + ").get(" + rightSrc + ")";
        }
        return new FelMethod(type, src);
    }

    private String getRightSrc(FelContext ctx, FelNode right, SourceBuilder rightMethod, Class<?> rightType) {
        String rightSrc = "";
        Class[] cls = new Class[]{Integer.class, Short.class, Character.class, Byte.class, Integer.TYPE, Short.TYPE, Character.TYPE, Byte.TYPE};
        boolean isInt = false;
        int i = 0;
        while (i < cls.length) {
            if (cls[i].isAssignableFrom(rightType)) {
                isInt = true;
                break;
            }
            ++i;
        }
        if (isInt) {
            rightSrc = rightMethod.source(ctx, right);
        } else if (Number.class.isAssignableFrom(rightType)) {
            rightSrc = "(" + rightMethod.source(ctx, right) + ").intValue()";
        }
        return rightSrc;
    }

    public static Object get(Object object, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return CollectionGet.get(iterator, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[index];
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                if (--index == -1) {
                    return it.next();
                }
                it.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return CollectionGet.get(iterator, index);
        }
        if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                if (--index == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, index);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public int[][] getNum() {
        return this.num;
    }

    public void setNum(int[][] num) {
        this.num = num;
    }

    public String[][] getA() {
        return this.a;
    }

    public void setA(String[][] a) {
        this.a = a;
    }

    public static void main(String[] args) throws SecurityException, NoSuchMethodException {
        CollectionGet.test();
    }

    public static void test() {
        FelEngineImpl engine = new FelEngineImpl();
        FelContext ctx = engine.getContext();
        int[] pInt = new int[]{1, 2, 3};
        pInt.getClass().getName();
        ctx.set("pInt", pInt);
        Integer[] wInt = new Integer[]{1, 2, 3};
        ctx.set("wInt", wInt);
        int[][] twoDimension = new int[][]{{1, 2}, {3, 4}};
        ctx.set("twoDimension", twoDimension);
        CollectionGet[][] twoDimensionx = new CollectionGet[1][1];
        ctx.set("twoDimensionx", twoDimensionx);
        CollectionGet.assertEval("pInt", engine, pInt);
        CollectionGet.assertCompile("pInt", engine, pInt);
        CollectionGet.assertEval("twoDimensionx", engine, twoDimensionx);
        CollectionGet.assertCompile("twoDimensionx", engine, twoDimensionx);
        CollectionGet.assertEval("pInt[1]", engine, 2);
        CollectionGet.assertCompile("pInt[1]", engine, 2);
    }

    public static void assertEval(String exp, FelEngine engine, Object expected) {
        Object actual = engine.eval(exp);
        if (actual instanceof Number && expected instanceof Number ? !$assertionsDisabled && NumberUtil.toDouble(actual) != NumberUtil.toDouble(expected) : !$assertionsDisabled && !ObjectUtils.equals(expected, actual)) {
            throw new AssertionError();
        }
    }

    public static void assertCompile(String exp, FelEngine engine, Object expected) {
        Expression ins = engine.compile(exp, null, new Optimizer[0]);
        Object actual = ins.eval(engine.getContext());
        if (actual instanceof Number && expected instanceof Number ? !$assertionsDisabled && NumberUtil.toDouble(actual) != NumberUtil.toDouble(expected) : !$assertionsDisabled && !ObjectUtils.equals(expected, actual)) {
            throw new AssertionError();
        }
    }
}

