/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.Null;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Equal
extends StableFunction {
    @Override
    public String getName() {
        return "==";
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children != null && children.size() == 2) {
            Object left = TolerantFunction.eval(context, children.get(0));
            Object right = TolerantFunction.eval(context, children.get(1));
            return this.compare(left, right);
        }
        throw new NullPointerException("\u4f20\u5165\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u8005\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e!");
    }

    boolean compare(Object left, Object right) {
        return Equal.equals(left, right);
    }

    public static boolean equals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getClass().equals(right.getClass())) {
            return left.equals(right);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return NumberUtil.toBigDecimal(left).compareTo(NumberUtil.toBigDecimal(right)) == 0;
        }
        if (NumberUtil.isFloatingPointNumber(left) || NumberUtil.isFloatingPointNumber(right)) {
            return NumberUtil.toDouble(left) == NumberUtil.toDouble(right);
        }
        if (left instanceof Number || right instanceof Number || left instanceof Character || right instanceof Character) {
            return NumberUtil.toLong(left) == NumberUtil.toLong(right);
        }
        if (left instanceof Boolean || right instanceof Boolean) {
            return NumberUtil.toBoolean(left) == NumberUtil.toBoolean(right);
        }
        if (left instanceof String || right instanceof String) {
            return left.toString().equals(right.toString());
        }
        return left.equals(right);
    }

    @Override
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        String operator = this.getName();
        return this.toMethod(node, ctx, operator);
    }

    private FelMethod toMethod(FelNode node, FelContext ctx, String operator) {
        StringBuilder sb = Equal.buildRelationExpr(node, ctx, operator);
        if (sb.length() == 0) {
            String left = Equal.getChildCode(node, ctx, 0);
            String right = Equal.getChildCode(node, ctx, 1);
            String toMethod = this.toMethod(left, right);
            sb.append(toMethod);
        }
        return new FelMethod(Boolean.class, sb.toString());
    }

    String toMethod(String left, String right) {
        return "ObjectUtils.equals(" + left + "," + right + ")";
    }

    public static String getChildCode(FelNode node, FelContext ctx, int index) {
        List<FelNode> children = node.getChildren();
        FelNode child = children.get(index);
        SourceBuilder leftM = child.toMethod(ctx);
        String code = "(" + leftM.source(ctx, child) + ")";
        return code;
    }

    public static StringBuilder buildRelationExpr(FelNode node, FelContext ctx, String operator) {
        List<FelNode> child = node.getChildren();
        FelNode leftNode = child.get(0);
        FelNode rightNode = child.get(1);
        SourceBuilder leftM = leftNode.toMethod(ctx);
        SourceBuilder rightM = rightNode.toMethod(ctx);
        Class<?> leftType = leftM.returnType(ctx, leftNode);
        Class<?> rightType = rightM.returnType(ctx, rightNode);
        String left = "(" + leftM.source(ctx, leftNode) + ")";
        String right = "(" + rightM.source(ctx, rightNode) + ")";
        StringBuilder sb = new StringBuilder();
        if (ReflectUtil.isPrimitiveNumber(leftType) && ReflectUtil.isPrimitiveNumber(leftType)) {
            sb.append(left).append(operator).append(right);
        } else if (Number.class.isAssignableFrom(leftType)) {
            sb.append(left);
            sb.append(operator);
            Equal.appendNumber(rightType, right, sb);
        } else if (Number.class.isAssignableFrom(rightType)) {
            Equal.appendNumber(leftType, left, sb);
            sb.append(operator);
            sb.append(right);
        } else if (Boolean.class.isAssignableFrom(leftType)) {
            sb.append(left);
            sb.append(operator);
            Equal.appendBoolean(rightType, right, sb);
        } else if (Boolean.class.isAssignableFrom(rightType)) {
            Equal.appendBoolean(leftType, left, sb);
            sb.append(operator);
            sb.append(right);
        } else if (String.class.isAssignableFrom(leftType)) {
            sb.append("StringUtils.equals(" + left + ",ObjectUtils.toString(" + right + "))");
        } else if (String.class.isAssignableFrom(rightType)) {
            sb.append("StringUtils.equals(ObjectUtils.toString(" + right + ")," + left + ")");
        }
        return sb;
    }

    public static void appendNumber(Class<?> type, String src, StringBuilder sb) {
        if (Number.class.isAssignableFrom(type)) {
            sb.append(src);
        } else if (String.class.isAssignableFrom(type)) {
            sb.append("NumberUtil.toDouble(" + src + ")");
        } else if (Null.class.isAssignableFrom(type)) {
            sb.append("Double.MIN_VALUE");
        }
    }

    public static void appendBoolean(Class<?> type, String src, StringBuilder sb) {
        if (Boolean.class.isAssignableFrom(type)) {
            sb.append(src);
        } else if (String.class.isAssignableFrom(type)) {
            sb.append("Boolean.valueOf(" + src + ")");
        }
    }
}

