/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.function.operator.Equal;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.Stable;
import java.util.List;

public class LessThen
implements Stable,
Function {
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children != null && children.size() == 2) {
            Object left = TolerantFunction.eval(context, children.get(0));
            Object right = TolerantFunction.eval(context, children.get(1));
            return this.compare(left, right);
        }
        throw new NullPointerException("\u4f20\u5165\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u8005\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e!");
    }

    public boolean compare(Object left, Object right) {
        if (left == right) {
            return false;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Number && right instanceof Number) {
            return NumberUtil.toDouble((Number)left) < NumberUtil.toDouble((Number)right);
        }
        if (left instanceof Comparable && right instanceof Comparable) {
            return ((Comparable)left).compareTo(right) < 0;
        }
        return false;
    }

    public static StringBuilder buildRelationExpr(FelNode node, FelContext ctx, String operator) {
        List<FelNode> child = node.getChildren();
        FelNode leftNode = child.get(0);
        FelNode rightNode = child.get(1);
        SourceBuilder leftM = leftNode.toMethod(ctx);
        SourceBuilder rightM = rightNode.toMethod(ctx);
        Class<?> leftType = leftM.returnType(ctx, leftNode);
        Class<?> rightType = rightM.returnType(ctx, rightNode);
        String left = "(" + leftM.source(ctx, leftNode) + ")";
        String right = "(" + rightM.source(ctx, rightNode) + ")";
        StringBuilder sb = new StringBuilder();
        if (Number.class.isAssignableFrom(leftType)) {
            sb.append(left);
            sb.append(operator);
            Equal.appendNumber(rightType, right, sb);
        } else if (Number.class.isAssignableFrom(rightType)) {
            Equal.appendNumber(leftType, left, sb);
            sb.append(operator);
            sb.append(right);
        } else if (Comparable.class.isAssignableFrom(leftType) && Comparable.class.isAssignableFrom(rightType)) {
            sb.append("NumberUtil.compare(" + left + "," + right + ")" + operator + "0");
        } else {
            throw new UnsupportedOperationException("\u7c7b\u578b" + leftType + "\u4e0e\u7c7b\u578b" + rightType + "\u4e0d\u652f\u6301\u6bd4\u8f83\u64cd\u4f5c\u3002");
        }
        return sb;
    }

    public String getName() {
        return "<";
    }

    public FelMethod toMethod(FelNode node, FelContext ctx) {
        StringBuilder code = LessThen.buildRelationExpr(node, ctx, this.getName());
        return new FelMethod(Boolean.class, code.toString());
    }

    public boolean stable() {
        return true;
    }

    public static void main(String[] args) {
        FelEngine engine = FelEngine.instance;
        System.out.println(engine.eval("6>=5"));
    }
}

