/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.parser;

import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.common.Callable;
import com.greenpineyu.fel.exception.ParseException;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.function.operator.Dot;
import com.greenpineyu.fel.parser.AbstFelNode;
import com.greenpineyu.fel.parser.FelLexer;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.FelParser;
import com.greenpineyu.fel.parser.FunNode;
import com.greenpineyu.fel.parser.NodeAdaptor;
import com.greenpineyu.fel.parser.Parser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeAdaptor;

public class AntlrParser
implements Parser {
    public static final Callable<Boolean, FelNode> funFilter = new Callable<Boolean, FelNode>(){

        public Boolean call(FelNode ... node) {
            FelNode n = node[0];
            if (n == null) {
                return false;
            }
            boolean isFun = n instanceof FunNode;
            if (isFun && n instanceof CommonTree) {
                CommonTree treeNode = (CommonTree)n;
                CommonTree p = treeNode.parent;
                if (p != null && ".".equals(p.getText())) {
                    isFun = p.getChildren().get(0) == n;
                }
            }
            return isFun;
        }
    };
    private final FelEngine engine;

    public AntlrParser(FelEngine engine) {
        this.engine = engine;
    }

    public FelNode parse(String exp) {
        Object tree;
        if (exp == null || "".equals(exp)) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(exp.getBytes());
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FelLexer lexer = new FelLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FelParser parser = new FelParser((TokenStream)tokens);
        parser.setTreeAdaptor((TreeAdaptor)new NodeAdaptor());
        FelParser.program_return r = null;
        try {
            r = parser.program();
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (r != null && (tree = r.getTree()) instanceof FelNode) {
            this.initFun((FelNode)tree);
            return (FelNode)tree;
        }
        return null;
    }

    public void initFun(FelNode node) {
        List<FelNode> nodes = AbstFelNode.getNodes(node, funFilter);
        if (nodes != null) {
            for (FelNode n : nodes) {
                FunNode funNode = (FunNode)n;
                funNode.initFun(this.engine.getFunMgr());
                Function fun = funNode.getFun();
                if (!(fun instanceof Dot)) continue;
                Dot dot = (Dot)fun;
                dot.setSecurityMgr(this.engine.getSecurityMgr());
            }
        }
    }

    public boolean verify(String exp) {
        try {
            this.parse(exp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

