/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.jsr330.spi.internal;

import com.sun.hk2.component.InjectionResolver;
import com.sun.hk2.jsr330.spi.BasicProviderImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.tiger_types.Types;

public class Jsr330InjectionResolver
extends InjectionResolver<Inject> {
    @Inject
    private Habitat habitat;

    public Jsr330InjectionResolver() {
        super(Inject.class);
    }

    public Jsr330InjectionResolver(Habitat h) {
        super(Inject.class);
        this.habitat = h;
    }

    @Override
    public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type gtype, Class<V> type) throws ComponentException {
        Provider<V> result;
        if (type.isArray()) {
            result = this.getValueForInjectedArray(onBehalfOf, gtype, type);
        } else if (Types.isSubClassOf(type, Provider.class)) {
            gtype = this.getGenericType(gtype, target);
            result = Jsr330InjectionResolver.getHolderInjectValue(this.habitat, onBehalfOf, target, gtype);
        } else {
            result = Jsr330InjectionResolver.get(this.habitat, onBehalfOf, target, type);
        }
        return (V)result;
    }

    private <V> Object getValueForInjectedArray(Inhabitant<?> onBehalfOf, Type gtype, Class<V> type) {
        Object result;
        Class<?> baseType = type.getComponentType();
        if (Types.isSubClassOf(baseType, Provider.class)) {
            if (!GenericArrayType.class.isInstance(gtype)) {
                throw new ComponentException("unknown type: " + gtype.toString());
            }
            Type baseComponentType = ((GenericArrayType)gtype).getGenericComponentType();
            if (null == baseComponentType) {
                throw new ComponentException(gtype.toString() + " on " + onBehalfOf);
            }
            if (!ParameterizedType.class.isInstance(baseComponentType)) {
                throw new ComponentException("unknown type: " + baseComponentType.toString());
            }
            Type[] types = ((ParameterizedType)baseComponentType).getActualTypeArguments();
            if (null == types || 1 != types.length) {
                throw new ComponentException(baseComponentType.toString() + " on " + onBehalfOf);
            }
            Class paramClass = Types.erasure(types[0]);
            Collection answer = this.habitat.getInhabitants(paramClass);
            ArrayList providers = new ArrayList();
            for (Inhabitant inh : answer) {
                providers.add(new BasicProviderImpl(inh));
            }
            result = providers.toArray(new Provider[0]);
        } else {
            Collection<?> answer = this.habitat.isContract(baseType) ? this.habitat.getAllByContract(baseType) : this.habitat.getAllByType(baseType);
            result = type.cast(answer.toArray((Object[])Array.newInstance(type.getComponentType(), answer.size())));
        }
        return result;
    }

    protected Type getGenericType(Type gtype, AnnotatedElement target) {
        Type[] gpTypes;
        if (null != gtype) {
            return gtype;
        }
        if (target instanceof Field) {
            return ((Field)target).getGenericType();
        }
        if (target instanceof Method && 1 == (gpTypes = ((Method)target).getGenericParameterTypes()).length) {
            return gpTypes[0];
        }
        throw new ComponentException("unknown type: " + target);
    }

    protected static <V> Provider<V> getHolderInjectValue(Habitat habitat, Object onBehalfOf, AnnotatedElement target, Type paramType) throws ComponentException {
        if (!ParameterizedType.class.isInstance(paramType)) {
            throw new ComponentException("unknown type: " + paramType.toString());
        }
        Type[] types = ((ParameterizedType)paramType).getActualTypeArguments();
        if (null == types || 1 != types.length) {
            throw new ComponentException(paramType.toString() + " on " + onBehalfOf);
        }
        Named named = target != null ? target.getAnnotation(Named.class) : null;
        String name = null == named ? null : named.value();
        Class paramClass = Types.erasure(types[0]);
        Inhabitant inhabitant = Jsr330InjectionResolver.getInhabitant(habitat, onBehalfOf, paramClass, name);
        return new BasicProviderImpl(inhabitant);
    }

    protected static <V> Inhabitant<V> getInhabitant(Habitat habitat, Object onBehalfOf, Class<V> type) {
        return Jsr330InjectionResolver.getInhabitant(habitat, onBehalfOf, type, null);
    }

    protected static <V> Inhabitant<V> getInhabitant(Habitat habitat, Object onBehalfOf, Class<V> type, String name) {
        Inhabitant<V> result = habitat.getInhabitant(type, name);
        if (null == result) {
            result = habitat.getInhabitantByType(type);
        }
        return result;
    }

    protected static <V> V get(Habitat habitat, Object onBehalfOf, AnnotatedElement target, Class<V> type) {
        Annotation[] annotations = Jsr330InjectionResolver.qualifiers(target.getAnnotations());
        Named named = target.getAnnotation(Named.class);
        String name = null == named ? null : named.value();
        V result = null;
        if (null != name) {
            result = Jsr330InjectionResolver.getServiceInjectValue(habitat, type, name);
        }
        if (null == result && null != annotations) {
            result = Jsr330InjectionResolver.getServiceInjectValue(habitat, type, annotations);
        }
        if (null == result) {
            result = Jsr330InjectionResolver.getComponentInjectValue(habitat, type);
        }
        if (null == result && null == name && null == annotations) {
            result = Jsr330InjectionResolver.getServiceInjectValue(habitat, type, (String)null);
        }
        return result;
    }

    private static Annotation[] qualifiers(Annotation[] annotations) {
        if (null == annotations || 0 == annotations.length) {
            return null;
        }
        ArrayList<Annotation> result = null;
        for (Annotation ann : annotations) {
            if (null == ann.annotationType().getAnnotation(Qualifier.class)) continue;
            if (null == result) {
                result = new ArrayList<Annotation>();
            }
            result.add(ann);
        }
        return null == result ? null : result.toArray(annotations);
    }

    protected static <V> V getServiceInjectValue(Habitat habitat, Class<V> type, String name) throws ComponentException {
        V result = habitat.getComponent(type, name);
        return result;
    }

    protected static <V> V getServiceInjectValue(Habitat habitat, Class<V> type, Annotation[] annotations) throws ComponentException {
        Collection<Inhabitant<?>> candidates = habitat.getInhabitantsByContract(type.getName());
        for (Inhabitant<?> candidate : candidates) {
            if (!Jsr330InjectionResolver.matched(annotations, candidate.metadata())) continue;
            return (V)candidate.get();
        }
        return null;
    }

    protected static boolean matched(Annotation[] annotations, MultiMap<String, String> candidateMd) {
        for (Annotation ann : annotations) {
            String name;
            if (null == ann || candidateMd.contains("qualifier", name = ann.annotationType().getName())) continue;
            return false;
        }
        return true;
    }

    protected static <V> V getComponentInjectValue(Habitat habitat, Class<V> type) throws ComponentException {
        V result = habitat.getByType(type);
        return result;
    }

    @Override
    public boolean isOptional(AnnotatedElement annotated, Inject annotation) {
        return annotated.isAnnotationPresent(Optional.class);
    }
}

