/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.MultiMap;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.RunLevelException;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.internal.runlevel.RunLevelServiceStub;

public class RunLevelServices {
    private static Logger logger = Logger.getLogger(RunLevelServices.class.getName());
    private Map<Habitat, Map<String, RunLevelServiceStub>> map = new HashMap<Habitat, Map<String, RunLevelServiceStub>>();

    public synchronized RunLevelService<?> get(Habitat habitat, int rl, Class<?> scope) {
        return this.get(habitat, rl, scope.getName());
    }

    public synchronized RunLevelService<?> get(Habitat habitat, int rl, String scopeName) {
        assert (null != scopeName);
        RunLevelService<?> rls = this.getFromMap(habitat, scopeName);
        if (null == rls) {
            rls = RunLevelServices.getFromHabitat(habitat, scopeName);
        }
        if (null == rls) {
            rls = this.create(habitat, rl, scopeName);
        }
        return rls;
    }

    static RunLevelService<?> getFromHabitat(Habitat habitat, String scopeName) {
        if (null == habitat) {
            return null;
        }
        Collection<Inhabitant<?>> coll = habitat.getInhabitantsByContract(RunLevelService.class.getName());
        RunLevelService theOne = null;
        for (Inhabitant<?> rlsi : coll) {
            RunLevelService hrls;
            MultiMap mm;
            String rlsScopeName;
            if (!rlsi.isActive() && (null == (rlsScopeName = (String)(mm = rlsi.getDescriptor().getMetadata()).getFirst((Object)"runLevelScope")) || rlsScopeName.equals(scopeName))) {
                if (null == rlsScopeName) {
                    logger.log(Level.INFO, "{0} should ideally be annotated with metadata attribute 'runLevelScope'", rlsi);
                }
                try {
                    rlsi.get();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "unable to activate {0}", rlsi);
                }
            }
            if (!rlsi.isActive() || null == (hrls = (RunLevelService)rlsi.get()).getState() || !hrls.getState().getScopeName().equals(scopeName)) continue;
            if (null != theOne) {
                throw new RunLevelException("constraint violation - competing RunLevelServices: " + theOne + " and " + hrls);
            }
            theOne = hrls;
        }
        return theOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunLevelService<?> getFromMap(Habitat habitat, String scopeName) {
        RunLevelService rls;
        Map<String, RunLevelServiceStub> scopeMap;
        Map<Habitat, Map<String, RunLevelServiceStub>> map = this.map;
        synchronized (map) {
            scopeMap = this.map.get(habitat);
            if (null == scopeMap) {
                return null;
            }
        }
        Map<String, RunLevelServiceStub> map2 = scopeMap;
        synchronized (map2) {
            rls = scopeMap.get(scopeName);
        }
        return rls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunLevelService<?> create(Habitat habitat, int rl, String scopeName) {
        RunLevelServiceStub rls;
        Map<String, RunLevelServiceStub> scopeMap;
        this.initialize(habitat, rl, scopeName);
        Map<Habitat, Map<String, RunLevelServiceStub>> map = this.map;
        synchronized (map) {
            scopeMap = this.map.get(habitat);
            if (null == scopeMap) {
                scopeMap = new HashMap<String, RunLevelServiceStub>();
                this.map.put(habitat, scopeMap);
            }
        }
        Map<String, RunLevelServiceStub> map2 = scopeMap;
        synchronized (map2) {
            rls = scopeMap.get(scopeName);
            if (null == rls) {
                rls = new RunLevelServiceStub(habitat, scopeName);
                scopeMap.put(scopeName, rls);
            }
        }
        return rls;
    }

    private void initialize(Habitat habitat, int rl, String scopeName) {
        if (null == habitat) {
            return;
        }
        if (habitat.isInitialized()) {
            throw new ComponentException("no RunLevelService found appropriate for RunLevel: (" + rl + "," + scopeName + ")");
        }
        habitat.addHabitatListener(new HabitatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
                if (HabitatListener.EventType.HABITAT_INITIALIZED == eventType) {
                    Map rlss;
                    Map map = RunLevelServices.this.map;
                    synchronized (map) {
                        rlss = (Map)RunLevelServices.this.map.remove(habitat);
                    }
                    if (null != rlss) {
                        for (RunLevelServiceStub rls : rlss.values()) {
                            RunLevelService<?> realRls = RunLevelServices.getFromHabitat(rls.getHabitat(), rls.getScopeName());
                            rls.activate(realRls);
                        }
                    }
                    return false;
                }
                return true;
            }

            @Override
            public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant, String index, String name, Object service) {
                return true;
            }
        });
    }
}

