/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetAttrO;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.bytecode.MatchClassNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline(value=false)
public abstract class MatchClassNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Object var2, Object var3, int var4, TruffleString[] var5);

    @Specialization
    Object match(VirtualFrame frame, Object subject, Object type, int nargs, @NeverDefault TruffleString[] kwArgsArg, @Bind(value="this") Node inliningTarget, @Cached(value="kwArgsArg", dimensions=1) TruffleString[] kwArgs, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached PyObjectGetAttrO getAttr, @Cached TypeNodes.GetTypeFlagsNode getTypeFlagsNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isClassProfile, @Cached StringBuiltins.EqNode eqStrNode, @Cached PyTupleCheckExactNode tupleCheckExactNode, @Cached PythonObjectFactory factory, @Cached PyTupleSizeNode tupleSizeNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PRaiseNode raise) {
        Object[] attrs;
        if (!isTypeNode.execute(inliningTarget, type)) {
            throw raise.raise(PythonErrorType.TypeError, ErrorMessages.CALLED_MATCH_PAT_MUST_BE_TYPE);
        }
        if (!isInstanceNode.executeWith(frame, subject, type)) {
            return null;
        }
        Object[] seen = new Object[nargs + kwArgs.length];
        int[] seenLength = new int[]{0};
        int[] attrsLength = new int[]{0};
        if (nargs > 0) {
            int allowed;
            Object matchArgs;
            boolean matchSelf = false;
            try {
                matchArgs = getAttr.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___MATCH_ARGS);
                if (!tupleCheckExactNode.execute(inliningTarget, matchArgs)) {
                    throw raise.raise(PythonErrorType.TypeError, ErrorMessages.P_MATCH_ARGS_MUST_BE_A_TUPLE_GOT_P, type, matchArgs);
                }
            }
            catch (PException e) {
                e.expectAttributeError(inliningTarget, isClassProfile);
                matchArgs = factory.createEmptyTuple();
                matchSelf = (getTypeFlagsNode.execute(type) & 0x400000L) != 0L;
            }
            int n = allowed = matchSelf ? 1 : tupleSizeNode.execute(inliningTarget, matchArgs);
            if (allowed < nargs) {
                throw raise.raise(PythonErrorType.TypeError, ErrorMessages.P_ACCEPTS_D_POS_SUBARG_S_D_GIVEN, type, allowed, allowed == 1 ? "" : "s", nargs);
            }
            if (matchSelf) {
                attrs = new Object[1 + kwArgs.length];
                int n2 = attrsLength[0];
                attrsLength[0] = n2 + 1;
                attrs[n2] = subject;
            } else {
                attrs = new Object[nargs + kwArgs.length];
                MatchClassNode.getArgs(frame, inliningTarget, subject, type, nargs, seen, seenLength, attrs, attrsLength, matchArgs, getAttr, eqStrNode, getItemNode, unicodeCheckNode, raise);
            }
        } else {
            attrs = new Object[kwArgs.length];
        }
        MatchClassNode.getKwArgs(frame, inliningTarget, subject, type, kwArgs, seen, seenLength, attrs, attrsLength, getAttr, eqStrNode, raise);
        return factory.createList(attrs);
    }

    @ExplodeLoop
    private static void getArgs(VirtualFrame frame, Node inliningTarget, Object subject, Object type, int nargs, Object[] seen, int[] seenLength, Object[] attrs, int[] attrsLength, Object matchArgs, PyObjectGetAttrO getAttr, StringBuiltins.EqNode eqStrNode, TupleBuiltins.GetItemNode getItemNode, PyUnicodeCheckNode unicodeCheckNode, PRaiseNode raise) {
        CompilerAsserts.partialEvaluationConstant((int)nargs);
        for (int i = 0; i < nargs; ++i) {
            Object name = getItemNode.execute(frame, matchArgs, i);
            if (!unicodeCheckNode.execute(inliningTarget, name)) {
                throw raise.raise(PythonErrorType.TypeError, ErrorMessages.MATCH_ARGS_ELEMENTS_MUST_BE_STRINGS_GOT_P, name);
            }
            MatchClassNode.setName(frame, type, name, seen, seenLength, eqStrNode, raise);
            int n = attrsLength[0];
            attrsLength[0] = n + 1;
            attrs[n] = getAttr.execute((Frame)frame, inliningTarget, subject, name);
        }
    }

    @ExplodeLoop
    private static void getKwArgs(VirtualFrame frame, Node inliningTarget, Object subject, Object type, TruffleString[] kwArgs, Object[] seen, int[] seenLength, Object[] attrs, int[] attrsLength, PyObjectGetAttrO getAttr, StringBuiltins.EqNode eqStrNode, PRaiseNode raise) {
        CompilerAsserts.partialEvaluationConstant((Object)kwArgs);
        for (int i = 0; i < kwArgs.length; ++i) {
            TruffleString name = kwArgs[i];
            CompilerAsserts.partialEvaluationConstant((Object)name);
            MatchClassNode.setName(frame, type, name, seen, seenLength, eqStrNode, raise);
            int n = attrsLength[0];
            attrsLength[0] = n + 1;
            attrs[n] = getAttr.execute((Frame)frame, inliningTarget, subject, name);
        }
    }

    private static void setName(VirtualFrame frame, Object type, Object name, Object[] seen, int[] seenLength, StringBuiltins.EqNode eqNode, PRaiseNode raise) {
        if (seenLength[0] > 0 && MatchClassNode.contains(frame, seen, name, eqNode)) {
            throw raise.raise(PythonErrorType.TypeError, ErrorMessages.S_GOT_MULTIPLE_SUBPATTERNS_FOR_ATTR_S, type, name);
        }
        int n = seenLength[0];
        seenLength[0] = n + 1;
        seen[n] = name;
    }

    @ExplodeLoop
    private static boolean contains(VirtualFrame frame, Object[] seen, Object name, StringBuiltins.EqNode eqNode) {
        for (int i = 0; i < seen.length; ++i) {
            if (seen[i] == null || !((Boolean)eqNode.execute(frame, seen[i], name)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static MatchClassNode create() {
        return MatchClassNodeGen.create();
    }
}

