/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialBaseNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={SpecialMethodNames.class, PythonOptions.class})
public abstract class LookupAndCallReversibleTernaryNode
extends LookupAndCallTernaryNode {
    @Node.Child
    private CallTernaryMethodNode reverseDispatchNode;
    @Node.Child
    private CallTernaryMethodNode thirdDispatchNode;
    @Node.Child
    protected LookupSpecialMethodNode getThirdAttrNode;
    @Node.Child
    protected LookupAndCallTernaryNode.NotImplementedHandler handler;
    protected final Supplier<LookupAndCallTernaryNode.NotImplementedHandler> handlerFactory;

    LookupAndCallReversibleTernaryNode(TruffleString name, Supplier<LookupAndCallTernaryNode.NotImplementedHandler> handlerFactory) {
        super(name);
        this.handlerFactory = handlerFactory;
    }

    public LookupAndCallReversibleTernaryNode(SpecialMethodSlot slot, Supplier<LookupAndCallTernaryNode.NotImplementedHandler> handlerFactory) {
        super(slot);
        this.handlerFactory = handlerFactory;
    }

    @Specialization(guards={"v.getClass() == cachedVClass"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callObjectR(VirtualFrame frame, Object v, Object w, Object z, @Bind(value="this") Node inliningTarget, @Cached(value="v.getClass()") Class<?> cachedVClass, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattr, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattrR, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached GetClassNode getClassR, @Cached.Exclusive @Cached GetClassNode getThirdClass, @Cached.Exclusive @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached InlinedBranchProfile notImplementedBranch, @Cached.Exclusive @Cached CallTernaryMethodNode dispatchNode) {
        return this.doCallObjectR(frame, inliningTarget, v, w, z, getattr, getattrR, getClass, getClassR, getThirdClass, isSubtype, isSameTypeNode, notImplementedBranch, dispatchNode);
    }

    @Specialization(replaces={"callObjectR"})
    @ReportPolymorphism.Megamorphic
    Object callObjectRMegamorphic(VirtualFrame frame, Object v, Object w, Object z, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattr, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattrR, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached GetClassNode getClassR, @Cached.Exclusive @Cached GetClassNode getThirdClass, @Cached.Exclusive @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached InlinedBranchProfile notImplementedBranch, @Cached.Exclusive @Cached CallTernaryMethodNode dispatchNode) {
        return this.doCallObjectR(frame, inliningTarget, v, w, z, getattr, getattrR, getClass, getClassR, getThirdClass, isSubtype, isSameTypeNode, notImplementedBranch, dispatchNode);
    }

    private Object doCallObjectR(VirtualFrame frame, Node inliningTarget, Object v, Object w, Object z, LookupSpecialBaseNode getattr, LookupSpecialBaseNode getattrR, GetClassNode getClass, GetClassNode getClassR, GetClassNode getThirdClass, IsSubtypeNode isSubtype, TypeNodes.IsSameTypeNode isSameTypeNode, InlinedBranchProfile notImplementedBranch, CallTernaryMethodNode dispatchNode) {
        Object leftClass = getClass.execute(inliningTarget, v);
        Object rightClass = getClassR.execute(inliningTarget, w);
        Object result = PNotImplemented.NOT_IMPLEMENTED;
        Object leftCallable = getattr.execute((Frame)frame, leftClass, v);
        Object rightCallable = PNone.NO_VALUE;
        if (!isSameTypeNode.execute(inliningTarget, leftClass, rightClass) && (rightCallable = getattrR.execute((Frame)frame, rightClass, w)) == leftCallable) {
            rightCallable = PNone.NO_VALUE;
        }
        if (leftCallable != PNone.NO_VALUE) {
            if (rightCallable != PNone.NO_VALUE && isSubtype.execute(frame, rightClass, leftClass)) {
                result = this.ensureReverseDispatch().execute((Frame)frame, rightCallable, v, w, z);
                if (result != PNotImplemented.NOT_IMPLEMENTED) {
                    return result;
                }
                rightCallable = PNone.NO_VALUE;
            }
            if ((result = dispatchNode.execute((Frame)frame, leftCallable, v, w, z)) != PNotImplemented.NOT_IMPLEMENTED) {
                return result;
            }
        }
        if (rightCallable != PNone.NO_VALUE && (result = this.ensureReverseDispatch().execute((Frame)frame, rightCallable, v, w, z)) != PNotImplemented.NOT_IMPLEMENTED) {
            return result;
        }
        Object zCallable = this.ensureGetAttrZ().execute((Frame)frame, getThirdClass.execute(inliningTarget, z), z);
        if (zCallable != PNone.NO_VALUE && zCallable != leftCallable && zCallable != rightCallable && (result = this.ensureThirdDispatch().execute((Frame)frame, zCallable, v, w, z)) != PNotImplemented.NOT_IMPLEMENTED) {
            return result;
        }
        notImplementedBranch.enter(inliningTarget);
        if (this.handlerFactory != null) {
            if (this.handler == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.handler = (LookupAndCallTernaryNode.NotImplementedHandler)this.insert((LookupAndCallTernaryNode.NotImplementedHandler)((Object)this.handlerFactory.get()));
            }
            return this.handler.execute(v, w, z);
        }
        return result;
    }

    protected CallTernaryMethodNode ensureReverseDispatch() {
        if (this.reverseDispatchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.reverseDispatchNode = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
        }
        return this.reverseDispatchNode;
    }

    protected CallTernaryMethodNode ensureThirdDispatch() {
        if (this.thirdDispatchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.thirdDispatchNode = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
        }
        return this.thirdDispatchNode;
    }

    protected LookupSpecialMethodNode ensureGetAttrZ() {
        if (this.getThirdAttrNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getThirdAttrNode = (LookupSpecialMethodNode)this.insert(LookupSpecialMethodNode.create(this.name));
        }
        return this.getThirdAttrNode;
    }
}

