/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialBaseNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNodeFactory;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class LookupSpecialMethodSlotNode
extends LookupSpecialBaseNode {
    @NeverDefault
    public static LookupSpecialMethodSlotNode create(SpecialMethodSlot slot) {
        return LookupSpecialMethodSlotNodeFactory.CachedLookupNodeGen.create(slot);
    }

    public static LookupSpecialMethodSlotNode getUncached(SpecialMethodSlot slot) {
        return UncachedLookup.UNCACHEDS[slot.ordinal()];
    }

    protected static abstract class CachedLookup
    extends LookupSpecialMethodSlotNode {
        protected final SpecialMethodSlot slot;

        public CachedLookup(SpecialMethodSlot slot) {
            this.slot = slot;
        }

        @Specialization
        Object lookup(VirtualFrame frame, Object type, Object receiver, @Bind(value="this") Node inliningTarget, @Cached(parameters={"slot"}) LookupCallableSlotInMRONode lookupSlot, @Cached MaybeBindDescriptorNode bind) {
            return bind.execute((Frame)frame, inliningTarget, lookupSlot.execute(type), receiver, type);
        }
    }

    private static final class UncachedLookup
    extends LookupSpecialMethodSlotNode {
        protected final LookupCallableSlotInMRONode lookup;
        private static final UncachedLookup[] UNCACHEDS = new UncachedLookup[SpecialMethodSlot.values().length];

        public UncachedLookup(SpecialMethodSlot slot) {
            this.lookup = LookupCallableSlotInMRONode.getUncached(slot);
        }

        @Override
        public Object execute(Frame frame, Object type, Object receiver) {
            return this.executeImpl(type, receiver);
        }

        @CompilerDirectives.TruffleBoundary
        private Object executeImpl(Object type, Object receiver) {
            return MaybeBindDescriptorNode.executeUncached(null, this.lookup.execute(type), receiver, type);
        }

        public boolean isAdoptable() {
            return false;
        }

        static {
            SpecialMethodSlot[] values = SpecialMethodSlot.values();
            for (int i = 0; i < values.length; ++i) {
                SpecialMethodSlot slot = values[i];
                UncachedLookup.UNCACHEDS[i] = new UncachedLookup(slot);
            }
        }
    }
}

