/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNodeGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@ReportPolymorphism
@GenerateUncached
public abstract class MaterializeFrameNode
extends Node {
    @NeverDefault
    public static MaterializeFrameNode create() {
        return MaterializeFrameNodeGen.create();
    }

    public static MaterializeFrameNode getUncached() {
        return MaterializeFrameNodeGen.getUncached();
    }

    public final PFrame execute(boolean markAsEscaped, Frame frameToMaterialize) {
        return this.execute(markAsEscaped, false, frameToMaterialize);
    }

    public final PFrame execute(boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize) {
        PFrame.Reference info = PArguments.getCurrentFrameInfo(frameToMaterialize);
        assert (info != null && info.getCallNode() != null) : "cannot materialize a frame without location information";
        Node callNode = info.getCallNode();
        return this.execute(callNode, markAsEscaped, forceSync, frameToMaterialize);
    }

    public final PFrame execute(Frame frame, boolean markAsEscaped) {
        return this.execute(markAsEscaped, frame);
    }

    public final PFrame execute(Frame frame, Node location, boolean markAsEscaped, boolean forceSync) {
        return this.execute(location, markAsEscaped, forceSync, frame);
    }

    public abstract PFrame execute(Node var1, boolean var2, boolean var3, Frame var4);

    @Specialization(guards={"cachedFD == frameToMaterialize.getFrameDescriptor()", "getPFrame(frameToMaterialize) == null", "!hasGeneratorFrame(frameToMaterialize)", "!hasCustomLocals(frameToMaterialize)"}, limit="1")
    static PFrame freshPFrameCachedFD(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Cached(value="frameToMaterialize.getFrameDescriptor()") FrameDescriptor cachedFD, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Shared(value="syncValuesNode") @Cached SyncFrameValuesNode syncValuesNode) {
        MaterializedFrame locals = MaterializeFrameNode.createLocalsFrame(cachedFD);
        PFrame escapedFrame = factory.createPFrame(PArguments.getCurrentFrameInfo(frameToMaterialize), location, locals);
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, forceSync, syncValuesNode);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) == null", "!hasGeneratorFrame(frameToMaterialize)", "!hasCustomLocals(frameToMaterialize)"}, replaces={"freshPFrameCachedFD"})
    static PFrame freshPFrame(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Shared(value="syncValuesNode") @Cached SyncFrameValuesNode syncValuesNode) {
        MaterializedFrame locals = MaterializeFrameNode.createLocalsFrame(frameToMaterialize.getFrameDescriptor());
        PFrame escapedFrame = factory.createPFrame(PArguments.getCurrentFrameInfo(frameToMaterialize), location, locals);
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, forceSync, syncValuesNode);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) == null", "!hasGeneratorFrame(frameToMaterialize)", "hasCustomLocals(frameToMaterialize)"})
    static PFrame freshPFrameCusstomLocals(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
        PFrame escapedFrame = factory.createPFrame(PArguments.getCurrentFrameInfo(frameToMaterialize), location, null);
        escapedFrame.setLocalsDict(PArguments.getSpecialArgument(frameToMaterialize));
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, false, null);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) == null", "hasGeneratorFrame(frameToMaterialize)"})
    static PFrame freshPFrameForGenerator(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
        MaterializedFrame generatorFrame = PArguments.getGeneratorFrame(frameToMaterialize);
        PFrame.Reference frameRef = PArguments.getCurrentFrameInfo(frameToMaterialize);
        PFrame escapedFrame = MaterializeFrameNode.materializeGeneratorFrame(location, generatorFrame, frameRef, factory);
        frameRef.setPyFrame(escapedFrame);
        return MaterializeFrameNode.doEscapeFrame(frameToMaterialize, escapedFrame, markAsEscaped, false, null);
    }

    @Specialization(guards={"getPFrame(frameToMaterialize) != null"})
    static PFrame alreadyEscapedFrame(Node location, boolean markAsEscaped, boolean forceSync, Frame frameToMaterialize, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="syncValuesNode") @Cached SyncFrameValuesNode syncValuesNode, @Cached InlinedConditionProfile syncProfile) {
        PFrame pyFrame = MaterializeFrameNode.getPFrame(frameToMaterialize);
        if (syncProfile.profile(inliningTarget, forceSync && !MaterializeFrameNode.hasGeneratorFrame(frameToMaterialize))) {
            syncValuesNode.execute(pyFrame, frameToMaterialize);
        }
        if (markAsEscaped) {
            pyFrame.getRef().markAsEscaped();
        }
        MaterializeFrameNode.processBytecodeFrame(frameToMaterialize, pyFrame);
        return pyFrame;
    }

    private static MaterializedFrame createLocalsFrame(FrameDescriptor cachedFD) {
        return Truffle.getRuntime().createMaterializedFrame(PythonUtils.EMPTY_OBJECT_ARRAY, cachedFD);
    }

    public static PFrame materializeGeneratorFrame(Node location, MaterializedFrame generatorFrame, PFrame.Reference frameRef, PythonObjectFactory factory) {
        PFrame escapedFrame = factory.createPFrame(frameRef, location, generatorFrame);
        PArguments.synchronizeArgs((Frame)generatorFrame, escapedFrame);
        return escapedFrame;
    }

    private static void processBytecodeFrame(Frame frameToMaterialize, PFrame pyFrame) {
        FrameInfo info = (FrameInfo)frameToMaterialize.getFrameDescriptor().getInfo();
        if (info != null) {
            pyFrame.setBci(info.getBci(frameToMaterialize));
            pyFrame.setLocation((Node)info.getRootNode());
        }
    }

    private static PFrame doEscapeFrame(Frame frameToMaterialize, PFrame escapedFrame, boolean markAsEscaped, boolean forceSync, SyncFrameValuesNode syncValuesNode) {
        PFrame.Reference topFrameRef = PArguments.getCurrentFrameInfo(frameToMaterialize);
        topFrameRef.setPyFrame(escapedFrame);
        PArguments.synchronizeArgs(frameToMaterialize, escapedFrame);
        if (forceSync) {
            syncValuesNode.execute(escapedFrame, frameToMaterialize);
        }
        if (markAsEscaped) {
            topFrameRef.markAsEscaped();
        }
        MaterializeFrameNode.processBytecodeFrame(frameToMaterialize, escapedFrame);
        return escapedFrame;
    }

    protected static boolean hasGeneratorFrame(Frame frame) {
        return PArguments.getGeneratorFrame(frame) != null;
    }

    protected static boolean hasCustomLocals(Frame frame) {
        return PArguments.getSpecialArgument(frame) != null;
    }

    protected static PFrame getPFrame(Frame frame) {
        return PArguments.getCurrentFrameInfo(frame).getPyFrame();
    }

    @GenerateUncached
    public static abstract class SyncFrameValuesNode
    extends Node {
        public abstract void execute(PFrame var1, Frame var2);

        @Specialization(guards={"!pyFrame.hasCustomLocals()", "frameToSync.getFrameDescriptor() == cachedFd", "variableSlotCount(cachedFd) < 32"}, limit="1")
        @ExplodeLoop
        static void doSyncExploded(PFrame pyFrame, Frame frameToSync, @Cached(value="frameToSync.getFrameDescriptor()") FrameDescriptor cachedFd) {
            MaterializedFrame target = pyFrame.getLocals();
            assert (cachedFd == target.getFrameDescriptor());
            int slotCount = SyncFrameValuesNode.variableSlotCount(cachedFd);
            for (int slot = 0; slot < slotCount; ++slot) {
                PythonUtils.copyFrameSlot(frameToSync, target, slot);
            }
        }

        @Specialization(guards={"!pyFrame.hasCustomLocals()"}, replaces={"doSyncExploded"})
        static void doSyncLoop(PFrame pyFrame, Frame frameToSync) {
            MaterializedFrame target = pyFrame.getLocals();
            int slotCount = SyncFrameValuesNode.variableSlotCount(frameToSync.getFrameDescriptor());
            for (int slot = 0; slot < slotCount; ++slot) {
                PythonUtils.copyFrameSlot(frameToSync, target, slot);
            }
        }

        @Specialization(guards={"pyFrame.hasCustomLocals()"})
        static void doCustomLocals(PFrame pyFrame, Frame frameToSync) {
        }

        @Idempotent
        protected static int variableSlotCount(FrameDescriptor fd) {
            FrameInfo info = (FrameInfo)fd.getInfo();
            if (info == null) {
                return 0;
            }
            return info.getVariableCount();
        }
    }
}

