/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;

public final class IntSequenceStorage
extends ArrayBasedSequenceStorage {
    private int[] values;

    public IntSequenceStorage() {
        this.values = new int[0];
    }

    public IntSequenceStorage(int[] elements) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = elements.length;
    }

    public IntSequenceStorage(int[] elements, int length) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = length;
    }

    public IntSequenceStorage(int capacity) {
        this.values = new int[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    private void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    public void ensureCapacity(int newCapacity) throws ArithmeticException {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (newCapacity > this.capacity ? 1 : 0) != 0)) {
            this.increaseCapacityExactWithCopy(IntSequenceStorage.capacityFor(newCapacity));
        }
    }

    @Override
    public IntSequenceStorage createEmpty(int newCapacity) {
        return new IntSequenceStorage(newCapacity);
    }

    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                int temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    public int[] getInternalIntArray() {
        return this.values;
    }

    public int getIntItemNormalized(int idx) {
        return this.values[idx];
    }

    public void setIntItemNormalized(int idx, int value) {
        this.values[idx] = value;
    }

    public void insertIntItem(int idx, int value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        this.incLength();
    }

    public int indexOfInt(int value) {
        for (int i = 0; i < this.length; ++i) {
            if (this.values[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getIndicativeValue() {
        return 0;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    public Object[] getCopyOfInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (int[])arrayObject;
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Int;
    }
}

