/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import java.math.BigInteger;
import java.nio.ByteOrder;

final class LongDoubleUtil {
    LongDoubleUtil() {
    }

    static Object interopToFP80(Object number) {
        assert (InteropLibrary.getUncached().isNumber(number));
        return new FP80Number(number);
    }

    static Object fp80ToNumber(Object buffer) {
        assert (InteropLibrary.getUncached().hasBufferElements(buffer));
        return new FP80Buffer(buffer);
    }

    static Object interopToFP128(Object number) {
        assert (InteropLibrary.getUncached().isNumber(number));
        return new FP128Number(number);
    }

    static Object fp128ToNumber(Object buffer) {
        assert (InteropLibrary.getUncached().hasBufferElements(buffer));
        return new FP128Buffer(buffer);
    }

    @ExportLibrary(value=SerializableLibrary.class, useForAOT=false)
    static final class FP80Number
    implements TruffleObject {
        private static final int FRACTION_BITS = 64;
        private static final int SIGN_MASK = 32768;
        private static final int EXPONENT_MASK = Short.MAX_VALUE;
        private static final int EXPONENT_BIAS = 16383;
        private static final long INF_FRACTION = Long.MIN_VALUE;
        private static final long NAN_FRACTION = -4611686018427387904L;
        final Object number;

        private FP80Number(Object number) {
            this.number = number;
        }

        @ExportMessage
        boolean isSerializable() {
            return true;
        }

        @ExportMessage
        static class Serialize {
            Serialize() {
            }

            @Specialization(limit="1", guards={"numberInterop.fitsInLong(self.number)"})
            static void doLong(FP80Number self, Object buffer, @CachedLibrary(value="self.number") InteropLibrary numberInterop, @CachedLibrary(value="buffer") InteropLibrary bufferInterop) {
                try {
                    long number = numberInterop.asLong(self.number);
                    if (number == 0L) {
                        bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, 0L);
                        bufferInterop.writeBufferShort(buffer, ByteOrder.nativeOrder(), 8L, (short)0);
                        return;
                    }
                    int sign = number < 0L ? 32768 : 0;
                    long val = Math.abs(number);
                    int leadingOnePosition = 64 - Long.numberOfLeadingZeros(val);
                    int exponent = 16383 + (leadingOnePosition - 1);
                    assert ((exponent & Short.MAX_VALUE) == exponent) : "exponent out of range";
                    long fractionMask = leadingOnePosition == 64 || leadingOnePosition == 63 ? -1L : (1L << leadingOnePosition + 1) - 1L;
                    long maskedFractionValue = val & fractionMask;
                    long fraction = maskedFractionValue << 64 - leadingOnePosition;
                    bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, fraction);
                    bufferInterop.writeBufferShort(buffer, ByteOrder.nativeOrder(), 8L, (short)(sign | exponent));
                }
                catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                }
            }

            @Specialization(limit="1", guards={"numberInterop.fitsInDouble(self.number)"})
            static void doDouble(FP80Number self, Object buffer, @CachedLibrary(value="self.number") InteropLibrary numberInterop, @CachedLibrary(value="buffer") InteropLibrary bufferInterop) {
                try {
                    double number = numberInterop.asDouble(self.number);
                    long rawValue = Double.doubleToRawLongBits(number);
                    int sign = rawValue < 0L ? 32768 : 0;
                    long absRaw = Math.abs(rawValue);
                    if (absRaw == 0L) {
                        bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, 0L);
                        bufferInterop.writeBufferShort(buffer, ByteOrder.nativeOrder(), 8L, (short)sign);
                        return;
                    }
                    if ((absRaw & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
                        if ((absRaw & 0xFFFFFFFFFFFFFL) == 0L) {
                            bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, Long.MIN_VALUE);
                        } else {
                            bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, -4611686018427387904L);
                        }
                        bufferInterop.writeBufferShort(buffer, ByteOrder.nativeOrder(), 8L, (short)(sign | Short.MAX_VALUE));
                    }
                    long doubleExponent = (absRaw & 0x7FF0000000000000L) >> 52;
                    int fp80Exponent = (int)doubleExponent - 1023 + 16383;
                    long doubleFraction = rawValue & 0xFFFFFFFFFFFFFL;
                    long shiftedDoubleFraction = doubleFraction << 11;
                    long leadingOne = Long.MIN_VALUE;
                    long fp80Fraction = leadingOne | shiftedDoubleFraction;
                    bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, fp80Fraction);
                    bufferInterop.writeBufferShort(buffer, ByteOrder.nativeOrder(), 8L, (short)(sign | fp80Exponent));
                }
                catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                }
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="buffer")
    static final class FP80Buffer
    implements TruffleObject {
        final Object buffer;

        FP80Buffer(Object buffer) {
            this.buffer = buffer;
        }

        @ExportMessage
        boolean isNumber(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            return interop.hasBufferElements(this.buffer);
        }

        @ExportMessage
        boolean fitsInByte(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long value = this.asLong(interop);
                return value == (long)((byte)value);
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInShort(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long value = this.asLong(interop);
                return value == (long)((short)value);
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInInt(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long value = this.asLong(interop);
                return value == (long)((int)value);
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInLong(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                this.asLong(interop);
                return true;
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInBigInteger(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                this.asBigInteger(interop);
                return true;
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInFloat(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            if (this.fitsInDouble()) {
                try {
                    double value = this.asDouble(interop);
                    return value == (double)((float)value);
                }
                catch (UnsupportedMessageException ex) {
                    return false;
                }
            }
            return false;
        }

        @ExportMessage
        boolean fitsInDouble() {
            return true;
        }

        @ExportMessage
        byte asByte(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long value = this.asLong(interop);
            if (value != (long)((byte)value)) {
                throw UnsupportedMessageException.create();
            }
            return (byte)value;
        }

        @ExportMessage
        short asShort(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long value = this.asLong(interop);
            if (value != (long)((short)value)) {
                throw UnsupportedMessageException.create();
            }
            return (short)value;
        }

        @ExportMessage
        int asInt(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long value = this.asLong(interop);
            if (value != (long)((int)value)) {
                throw UnsupportedMessageException.create();
            }
            return (int)value;
        }

        @ExportMessage
        long asLong(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            try {
                int shift;
                short exponent = interop.readBufferShort(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                if ((exponent & Short.MAX_VALUE) == Short.MAX_VALUE) {
                    throw UnsupportedMessageException.create();
                }
                int unbiasedExponent = (exponent & Short.MAX_VALUE) - 16383;
                long fraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
                long ret = fraction >>> (shift = 64 - unbiasedExponent - 1);
                if (ret < 0L || fraction != ret << shift) {
                    throw UnsupportedMessageException.create();
                }
                if ((exponent & 0x8000) == 0) {
                    return ret;
                }
                return -ret;
            }
            catch (InvalidBufferOffsetException ex) {
                throw UnsupportedMessageException.create();
            }
        }

        @ExportMessage
        BigInteger asBigInteger(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long fractionLong;
            int unbiasedExponent;
            short exponent;
            try {
                exponent = interop.readBufferShort(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                if ((exponent & Short.MAX_VALUE) == Short.MAX_VALUE) {
                    throw UnsupportedMessageException.create();
                }
                unbiasedExponent = (exponent & Short.MAX_VALUE) - 16383;
                fractionLong = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
            }
            catch (InvalidBufferOffsetException ex) {
                throw UnsupportedMessageException.create();
            }
            return FP80Buffer.toBigInteger(fractionLong, exponent, unbiasedExponent);
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger toBigInteger(long fractionLong, short exponent, int unbiasedExponent) throws UnsupportedMessageException {
            BigInteger ret;
            BigInteger fraction = FP80Buffer.toUnsignedBigInteger(fractionLong);
            int shift = 64 - unbiasedExponent - 1;
            if (shift >= 0) {
                ret = fraction.shiftRight(shift);
                BigInteger fractionBack = ret.shiftLeft(shift);
                if (!fraction.equals(fractionBack)) {
                    throw UnsupportedMessageException.create();
                }
            } else {
                ret = fraction.shiftLeft(-shift);
            }
            if ((exponent & 0x8000) == 0) {
                return ret;
            }
            return ret.negate();
        }

        private static BigInteger toUnsignedBigInteger(long i) {
            if (i >= 0L) {
                return BigInteger.valueOf(i);
            }
            int upper = (int)(i >>> 32);
            int lower = (int)i;
            return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
        }

        @ExportMessage
        float asFloat(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            return (float)this.asDouble(interop);
        }

        @ExportMessage
        double asDouble(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            try {
                long fraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
                short exponent = interop.readBufferShort(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                if (fraction == 0L) {
                    if (exponent == 0) {
                        return 0.0;
                    }
                    if (exponent == Short.MIN_VALUE) {
                        return -0.0;
                    }
                }
                if ((exponent & Short.MAX_VALUE) == Short.MAX_VALUE) {
                    if (fraction == Long.MIN_VALUE) {
                        if ((exponent & 0x8000) == 0) {
                            return Double.POSITIVE_INFINITY;
                        }
                        return Double.NEGATIVE_INFINITY;
                    }
                    return Double.NaN;
                }
                int unbiasedExponent = (exponent & Short.MAX_VALUE) - 16383;
                int doubleExponent = unbiasedExponent + 1023;
                long doubleFraction = fraction << 1 >>> 12;
                long shiftedExponent = (long)doubleExponent << 52;
                long signBit = (long)(exponent & 0x8000) << 48;
                return Double.longBitsToDouble(signBit | shiftedExponent | doubleFraction);
            }
            catch (InvalidBufferOffsetException ex) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static String format(long fraction, short exponent) {
            return String.format("0xK%04x%016x", exponent, fraction);
        }

        @ExportMessage
        String toDisplayString(boolean allowSideEffects, @CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long fraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
                short exponent = interop.readBufferShort(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                return FP80Buffer.format(fraction, exponent);
            }
            catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                return "<invalid FP80>";
            }
        }
    }

    @ExportLibrary(value=SerializableLibrary.class, useForAOT=false)
    static final class FP128Number
    implements TruffleObject {
        static final long DOUBLE_FRACTION_BIT_WIDTH = 52L;
        private static final long SIGN_MASK = Long.MIN_VALUE;
        private static final int EXPONENT_BIAS = 16383;
        private static final int FRACTION_BIT_WIDTH = 112;
        public static final int EXPONENT_POSITION = 48;
        public static final long EXPONENT_MASK = 0x7FFF000000000000L;
        public static final long FRACTION_MASK = 0xFFFFFFFFFFFFL;
        public static final int DOUBLE_SIGN_POS = 63;
        final Object number;

        private FP128Number(Object number) {
            this.number = number;
        }

        @ExportMessage
        boolean isSerializable() {
            return true;
        }

        @ExportMessage
        static class Serialize {
            Serialize() {
            }

            @Specialization(limit="1", guards={"numberInterop.fitsInLong(self.number)"})
            static void doLong(FP128Number self, Object buffer, @CachedLibrary(value="self.number") InteropLibrary numberInterop, @CachedLibrary(value="buffer") InteropLibrary bufferInterop) {
                try {
                    long fraction;
                    long exponentFraction;
                    long number = numberInterop.asLong(self.number);
                    if (number == 0L) {
                        bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, 0L);
                        bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 8L, 0L);
                        return;
                    }
                    long sign = number < 0L ? Long.MIN_VALUE : 0L;
                    long val = Math.abs(number);
                    int leadingOnePosition = 64 - Long.numberOfLeadingZeros(val);
                    long exponent = 16383 + (leadingOnePosition - 1);
                    long shiftAmount = 112 - leadingOnePosition + 1;
                    if (shiftAmount >= 64L) {
                        exponentFraction = exponent << 48 | val << (int)(shiftAmount - 64L) & 0xFFFFFFFFFFFFL;
                        fraction = 0L;
                    } else {
                        exponentFraction = exponent << 48 | val >> (int)(64L - shiftAmount) & 0xFFFFFFFFFFFFL;
                        fraction = val << (int)shiftAmount;
                    }
                    bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, fraction);
                    bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 8L, sign | exponentFraction);
                }
                catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                }
            }

            @Specialization(limit="1", guards={"numberInterop.fitsInDouble(self.number)"})
            static void doDouble(FP128Number self, Object buffer, @CachedLibrary(value="self.number") InteropLibrary numberInterop, @CachedLibrary(value="buffer") InteropLibrary bufferInterop) {
                try {
                    double number = numberInterop.asDouble(self.number);
                    long rawValue = Double.doubleToRawLongBits(number);
                    long sign = rawValue < 0L ? Long.MIN_VALUE : 0L;
                    long absRaw = Math.abs(rawValue);
                    if (absRaw == 0L) {
                        bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, 0L);
                        bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 8L, sign);
                        return;
                    }
                    int doubleExponent = Math.getExponent(number);
                    int biasedExponent = doubleExponent + 16383;
                    long doubleFraction = rawValue & 0xFFFFFFFFFFFFFL;
                    long shiftAmount = 60L;
                    long fraction = doubleFraction << (int)shiftAmount;
                    long biasedExponentFraction = (long)biasedExponent << 48 | doubleFraction >> (int)(64L - shiftAmount);
                    bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 0L, fraction);
                    bufferInterop.writeBufferLong(buffer, ByteOrder.nativeOrder(), 8L, sign | biasedExponentFraction);
                }
                catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                }
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="buffer")
    static final class FP128Buffer
    implements TruffleObject {
        final Object buffer;

        FP128Buffer(Object buffer) {
            this.buffer = buffer;
        }

        @ExportMessage
        boolean isNumber(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            return interop.hasBufferElements(this.buffer);
        }

        @ExportMessage
        boolean fitsInByte(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long value = this.asLong(interop);
                return value == (long)((byte)value);
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInShort(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long value = this.asLong(interop);
                return value == (long)((short)value);
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInInt(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long value = this.asLong(interop);
                return value == (long)((int)value);
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInLong(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                this.asLong(interop);
                return true;
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInBigInteger(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                this.asBigInteger(interop);
                return true;
            }
            catch (UnsupportedMessageException ex) {
                return false;
            }
        }

        @ExportMessage
        boolean fitsInFloat(@CachedLibrary(value="this.buffer") InteropLibrary interop) {
            if (this.fitsInDouble()) {
                try {
                    double value = this.asDouble(interop);
                    return value == (double)((float)value);
                }
                catch (UnsupportedMessageException ex) {
                    return false;
                }
            }
            return false;
        }

        @ExportMessage
        boolean fitsInDouble() {
            return true;
        }

        @ExportMessage
        byte asByte(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long value = this.asLong(interop);
            if (value != (long)((byte)value)) {
                throw UnsupportedMessageException.create();
            }
            return (byte)value;
        }

        @ExportMessage
        short asShort(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long value = this.asLong(interop);
            if (value != (long)((short)value)) {
                throw UnsupportedMessageException.create();
            }
            return (short)value;
        }

        @ExportMessage
        int asInt(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long value = this.asLong(interop);
            if (value != (long)((int)value)) {
                throw UnsupportedMessageException.create();
            }
            return (int)value;
        }

        @ExportMessage
        long asLong(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            try {
                long fraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
                long expSignFraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                if ((expSignFraction & 0x7FFF000000000000L) == 0x7FFF000000000000L) {
                    throw UnsupportedMessageException.create();
                }
                long unbiasedExponent = FP128Buffer.getUnbiasedExponent(expSignFraction);
                long returnFraction = 1L << (int)unbiasedExponent;
                if (unbiasedExponent < 0L) {
                    return 0L;
                }
                if (unbiasedExponent <= 48L) {
                    returnFraction |= (expSignFraction & 0xFFFFFFFFFFFFL) >>> (int)(48L - unbiasedExponent);
                } else if (unbiasedExponent < 64L) {
                    returnFraction |= (expSignFraction & 0xFFFFFFFFFFFFL) << (int)(unbiasedExponent - 48L);
                    returnFraction |= fraction >>> (int)(64L - (unbiasedExponent - 48L));
                } else {
                    returnFraction = 0L;
                }
                if ((expSignFraction & Long.MIN_VALUE) == 0L) {
                    return returnFraction;
                }
                return -returnFraction;
            }
            catch (InvalidBufferOffsetException ex) {
                throw UnsupportedMessageException.create();
            }
        }

        @ExportMessage
        BigInteger asBigInteger(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            long fractionLong;
            long expSignFraction;
            try {
                expSignFraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                if ((expSignFraction & 0x7FFF000000000000L) == 0x7FFF000000000000L) {
                    throw UnsupportedMessageException.create();
                }
                fractionLong = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
            }
            catch (InvalidBufferOffsetException ex) {
                throw UnsupportedMessageException.create();
            }
            return FP128Buffer.toBigInteger(fractionLong, expSignFraction);
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger toBigInteger(long longFraction, long expSignFraction) throws UnsupportedMessageException {
            BigInteger ret;
            if (longFraction == 0L && (expSignFraction & Long.MAX_VALUE) == 0L) {
                return BigInteger.ZERO;
            }
            long unbiasedExponent = FP128Buffer.getUnbiasedExponent(expSignFraction);
            BigInteger bigIntegerFraction = FP128Buffer.fractionToUnsignedBigInteger(longFraction, expSignFraction);
            int shift = (int)(112L - unbiasedExponent);
            if (shift > 0) {
                ret = bigIntegerFraction.shiftRight(shift);
                BigInteger fractionBack = ret.shiftLeft(shift);
                if (!bigIntegerFraction.equals(fractionBack)) {
                    throw UnsupportedMessageException.create();
                }
            } else {
                ret = bigIntegerFraction.shiftLeft(-shift);
            }
            if ((expSignFraction & Long.MIN_VALUE) == 0L) {
                return ret;
            }
            return ret.negate();
        }

        private static BigInteger fractionToUnsignedBigInteger(long fraction, long expSignFraction) {
            long extractedFraction = (expSignFraction & 0xFFFFFFFFFFFFL) + 0x1000000000000L;
            long upperFraction = (extractedFraction << 1) + (fraction >>> 63);
            long lowerFraction = fraction & Long.MAX_VALUE;
            return BigInteger.valueOf(upperFraction).shiftLeft(63).add(BigInteger.valueOf(lowerFraction));
        }

        @ExportMessage
        float asFloat(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            return (float)this.asDouble(interop);
        }

        private static long getUnbiasedExponent(long expSignFraction) {
            return ((expSignFraction & 0x7FFF000000000000L) >>> 48) - 16383L;
        }

        @ExportMessage
        double asDouble(@CachedLibrary(value="this.buffer") InteropLibrary interop) throws UnsupportedMessageException {
            try {
                long fraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
                long expSignFraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                if (fraction == 0L) {
                    if (expSignFraction == 0L) {
                        return 0.0;
                    }
                    if (expSignFraction == Long.MIN_VALUE) {
                        return -0.0;
                    }
                }
                long doubleExponent = FP128Buffer.getUnbiasedExponent(expSignFraction) + 1023L;
                long doubleFraction = (expSignFraction & 0xFFFFFFFFFFFFL) << 4;
                long signBit = (FP128Buffer.getSign(expSignFraction) ? 1L : 0L) << 63;
                long shiftedExponent = doubleExponent << 52;
                long rawVal = (doubleFraction |= fraction >>> 60) | shiftedExponent | signBit;
                return Double.longBitsToDouble(rawVal);
            }
            catch (InvalidBufferOffsetException ex) {
                throw UnsupportedMessageException.create();
            }
        }

        private static boolean getSign(long expSignFraction) {
            return (expSignFraction & Long.MIN_VALUE) != 0L;
        }

        @CompilerDirectives.TruffleBoundary
        private static String format(long fraction, long exponent) {
            return String.format("0xK%04x%028x", exponent, fraction);
        }

        @ExportMessage
        String toDisplayString(boolean allowSideEffects, @CachedLibrary(value="this.buffer") InteropLibrary interop) {
            try {
                long fraction = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 0L);
                long exponent = interop.readBufferLong(this.buffer, ByteOrder.LITTLE_ENDIAN, 8L);
                return FP128Buffer.format(fraction, exponent);
            }
            catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
                return "<invalid FP128>";
            }
        }
    }

    private static final class DoubleHelper {
        private static final int FRACTION_BITS = 52;
        private static final int EXPONENT_BITS = 11;
        private static final long EXPONENT_MASK = 0x7FF0000000000000L;
        private static final long FRACTION_MASK = 0xFFFFFFFFFFFFFL;
        private static final int EXPONENT_BIAS = 1023;

        private DoubleHelper() {
        }
    }
}

