/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.common;

import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Incubating;

@Incubating
public abstract class Identifier<T> {
    public abstract Id<T>[] ids();

    public abstract Map<String, Object> namedValues();

    public static <T, I> Id<T> id(SingularAttribute<T, I> attribute, I id) {
        return new Id<T>(attribute, id);
    }

    public static <T> Id<T> id(String attributeName, Object id) {
        return new Id(attributeName, id);
    }

    public static <T> Id<T> id(Class<T> entityClass, String attributeName, Object id) {
        return new Id(attributeName, id);
    }

    @SafeVarargs
    public static <T> Identifier<T> composite(Id<T> ... ids) {
        return new Composite<T>(ids);
    }

    public static class Composite<T>
    extends Identifier<T> {
        Id<T>[] ids;

        public Composite(Id<T>[] ids) {
            this.ids = ids;
        }

        public Id<T>[] getValues() {
            return this.ids;
        }

        @Override
        public Id<T>[] ids() {
            return this.ids;
        }

        @Override
        public Map<String, Object> namedValues() {
            HashMap<String, Object> namedValues = new HashMap<String, Object>();
            for (Id<T> id : this.ids) {
                namedValues.put(id.getAttributeName(), id.getId());
            }
            return namedValues;
        }
    }

    public static class Id<T>
    extends Identifier<T> {
        private final String attributeName;
        private final Object id;

        private <I> Id(SingularAttribute<T, I> attribute, I id) {
            this.id = id;
            this.attributeName = attribute.getName();
        }

        private Id(String attributeName, Object id) {
            this.attributeName = attributeName;
            this.id = id;
        }

        public Object getId() {
            return this.id;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public Id<T>[] ids() {
            return new Id[]{this};
        }

        @Override
        public Map<String, Object> namedValues() {
            return Collections.singletonMap(this.attributeName, this.id);
        }
    }
}

