/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.common;

import io.vertx.core.Context;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;

public final class InternalStateAssertions {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private static final boolean ENFORCE = !"false".equalsIgnoreCase(System.getProperty("org.hibernate.reactive.common.InternalStateAssertions.ENFORCE", "true").toLowerCase(Locale.ROOT).trim());

    private InternalStateAssertions() {
    }

    public static void assertUseOnEventLoop() {
        if (ENFORCE && !Context.isOnEventLoopThread()) {
            throw LOG.shouldBeInvokedInVertxEventLoopThread(Thread.currentThread().getName());
        }
    }

    public static void assertCurrentThreadMatches(Thread expectedThread) {
        if (ENFORCE && Thread.currentThread() != expectedThread) {
            throw LOG.detectedUsedOfTheSessionOnTheWrongThread(expectedThread.getId(), expectedThread.getName(), Thread.currentThread().getId(), Thread.currentThread().getName());
        }
    }
}

