/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.impl.ReactiveQueryExecutorLookup;
import org.hibernate.reactive.session.impl.ReactiveSessionImpl;
import org.hibernate.reactive.session.impl.SessionUtil;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public class EntityTypes {
    public static CompletionStage<Object> resolve(EntityType entityType, Object idOrUniqueKey, Object owner, SharedSessionContractImplementor session) {
        if (idOrUniqueKey != null && !EntityTypes.isNull(entityType, owner, session)) {
            if (entityType.isReferenceToPrimaryKey()) {
                return ReactiveQueryExecutorLookup.extract(session).reactiveInternalLoad(entityType.getAssociatedEntityName(), idOrUniqueKey, true, entityType.isNullable());
            }
            return EntityTypes.loadByUniqueKey(entityType, idOrUniqueKey, session);
        }
        return null;
    }

    static boolean isNull(EntityType entityType, Object owner, SharedSessionContractImplementor session) {
        if (entityType instanceof OneToOneType) {
            OneToOneType type = (OneToOneType)entityType;
            String propertyName = type.getPropertyName();
            if (propertyName != null) {
                EntityPersister ownerPersister = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityType.getAssociatedEntityName());
                Object id = session.getContextEntityIdentifier(owner);
                EntityKey entityKey = session.generateEntityKey(id, ownerPersister);
                return session.getPersistenceContextInternal().isPropertyNull(entityKey, propertyName);
            }
            return false;
        }
        return false;
    }

    static CompletionStage<Object> loadByUniqueKey(EntityType entityType, Object key, SharedSessionContractImplementor session) throws HibernateException {
        SessionFactoryImplementor factory = session.getFactory();
        String entityName = entityType.getAssociatedEntityName();
        String uniqueKeyPropertyName = entityType.getRHSUniqueKeyPropertyName();
        ReactiveEntityPersister persister = (ReactiveEntityPersister)factory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, key, entityType.getIdentifierOrUniqueKeyType((Mapping)factory), factory);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object result = persistenceContext.getEntity(euk);
        if (result != null) {
            return CompletionStages.completedFuture(persistenceContext.proxyFor(result));
        }
        return persister.reactiveLoadByUniqueKey(uniqueKeyPropertyName, key, session).thenApply(ukResult -> EntityTypes.loadHibernateProxyEntity(ukResult, session).thenApply(targetUK -> {
            persistenceContext.addEntity(euk, targetUK);
            return targetUK;
        }));
    }

    public static CompletionStage<Object[]> replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map<Object, Object> copyCache) {
        Object[] copied = new Object[original.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (original[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i2] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[i2] = target[i2];
                continue;
            }
            if (types[i2] instanceof EntityType) continue;
            copied[i2] = types[i2].replace(original[i2], target[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i2], (SharedSessionContractImplementor)session, owner, copyCache);
        }
        return CompletionStages.loop(0, types.length, i -> original[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && original[i] != PropertyAccessStrategyBackRefImpl.UNKNOWN && types[i] instanceof EntityType, i -> EntityTypes.replace((EntityType)types[i], original[i], target[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i], session, owner, copyCache).thenCompose(copy -> {
            if (copy instanceof CompletionStage) {
                return ((CompletionStage)copy).thenAccept(nonStageCopy -> {
                    copied[i] = nonStageCopy;
                });
            }
            copied[i] = copy;
            return CompletionStages.voidFuture();
        })).thenApply(v -> copied);
    }

    public static CompletionStage<Object[]> replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (original[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i2] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[i2] = target[i2];
                continue;
            }
            if (types[i2] instanceof EntityType) continue;
            copied[i2] = types[i2].replace(original[i2], target[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i2], (SharedSessionContractImplementor)session, owner, copyCache, foreignKeyDirection);
        }
        return CompletionStages.loop(0, types.length, i -> original[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && original[i] != PropertyAccessStrategyBackRefImpl.UNKNOWN && types[i] instanceof EntityType, i -> EntityTypes.replace((EntityType)types[i], original[i], target[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i], session, owner, copyCache, foreignKeyDirection).thenCompose(copy -> {
            if (copy instanceof CompletionStage) {
                return ((CompletionStage)copy).thenAccept(nonStageCopy -> {
                    copied[i] = nonStageCopy;
                });
            }
            copied[i] = copy;
            return CompletionStages.voidFuture();
        })).thenApply(v -> copied);
    }

    private static CompletionStage<Object> replace(EntityType entityType, Object original, Object target, SessionImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) throws HibernateException {
        boolean include = entityType.isAssociationType() ? entityType.getForeignKeyDirection() == foreignKeyDirection : ForeignKeyDirection.FROM_PARENT == foreignKeyDirection;
        return include ? EntityTypes.replace(entityType, original, target, session, owner, copyCache) : CompletionStages.completedFuture(target);
    }

    private static CompletionStage<Object> replace(EntityType entityType, Object original, Object target, SessionImplementor session, Object owner, Map<Object, Object> copyCache) {
        if (original == null) {
            return CompletionStages.nullFuture();
        }
        Object cached = copyCache.get(original);
        if (cached != null) {
            return CompletionStages.completedFuture(cached);
        }
        if (original == target) {
            return CompletionStages.completedFuture(target);
        }
        if (session.getContextEntityIdentifier(original) == null) {
            return ForeignKeys.isTransient(entityType.getAssociatedEntityName(), original, false, session).thenCompose(isTransient -> {
                if (isTransient.booleanValue()) {
                    if (copyCache.containsValue(original)) {
                        return CompletionStages.completedFuture(original);
                    }
                    Object copy = session.getEntityPersister(entityType.getAssociatedEntityName(), original).instantiate(null, (SharedSessionContractImplementor)session);
                    copyCache.put(original, copy);
                    return CompletionStages.completedFuture(copy);
                }
                return EntityTypes.resolveIdOrUniqueKey(entityType, original, session, owner, copyCache);
            });
        }
        return EntityTypes.resolveIdOrUniqueKey(entityType, original, session, owner, copyCache);
    }

    private static CompletionStage<Object> resolveIdOrUniqueKey(EntityType entityType, Object original, SessionImplementor session, Object owner, Map<Object, Object> copyCache) {
        return EntityTypes.getIdentifier(entityType, original, session).thenCompose(id -> {
            if (id == null) {
                throw new AssertionFailure("non-transient entity has a null id: " + original.getClass().getName());
            }
            return ((ReactiveSessionImpl)session).reactiveFetch(id, true).thenCompose(fetched -> {
                Object idOrUniqueKey = entityType.getIdentifierOrUniqueKeyType((Mapping)session.getFactory()).replace(fetched, null, (SharedSessionContractImplementor)session, owner, copyCache);
                if (idOrUniqueKey instanceof CompletionStage) {
                    return ((CompletionStage)idOrUniqueKey).thenCompose(key -> EntityTypes.resolve(entityType, key, owner, (SharedSessionContractImplementor)session));
                }
                return EntityTypes.resolve(entityType, idOrUniqueKey, owner, (SharedSessionContractImplementor)session);
            });
        });
    }

    private static CompletionStage<Object> getIdentifier(EntityType entityType, Object value, SessionImplementor session) {
        PersistentAttributeInterceptor interceptor;
        if (entityType.isReferenceToIdentifierProperty()) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(entityType.getAssociatedEntityName(), value, session);
        }
        if (value == null) {
            return CompletionStages.nullFuture();
        }
        if (value instanceof HibernateProxy) {
            return EntityTypes.getIdentifierFromHibernateProxy(entityType, (HibernateProxy)value, (SharedSessionContractImplementor)session);
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)value);
        if (lazyInitializer != null) {
            value = lazyInitializer.getImplementation();
        } else if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)value) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)value).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            ((EnhancementAsProxyLazinessInterceptor)interceptor).forceInitialize(value, null);
        }
        EntityPersister entityPersister = entityType.getAssociatedEntityPersister(session.getFactory());
        String uniqueKeyPropertyName = entityType.getRHSUniqueKeyPropertyName();
        CompletionStage<Object> propertyValue = entityPersister.getPropertyValue(value, uniqueKeyPropertyName);
        Type type = entityPersister.getPropertyType(uniqueKeyPropertyName);
        if (type.isEntityType()) {
            propertyValue = EntityTypes.getIdentifier((EntityType)type, propertyValue, session);
        }
        return CompletionStages.completedFuture(propertyValue);
    }

    private static CompletionStage<Object> getIdentifierFromHibernateProxy(EntityType entityType, HibernateProxy proxy, SharedSessionContractImplementor session) {
        LazyInitializer initializer = proxy.getHibernateLazyInitializer();
        String entityName = initializer.getEntityName();
        Object identifier = initializer.getIdentifier();
        return ((ReactiveSessionImpl)session).reactiveImmediateLoad(entityName, identifier).thenApply(entity -> {
            SessionUtil.checkEntityFound(session, entityName, identifier, entity);
            initializer.setSession(session);
            initializer.setImplementation(entity);
            if (entity != null) {
                EntityPersister entityPersister = entityType.getAssociatedEntityPersister(session.getFactory());
                String uniqueKeyPropertyName = entityType.getRHSUniqueKeyPropertyName();
                CompletionStage<Object> propertyValue = entityPersister.getPropertyValue(entity, uniqueKeyPropertyName);
                Type type = entityPersister.getPropertyType(uniqueKeyPropertyName);
                if (type.isEntityType()) {
                    propertyValue = EntityTypes.getIdentifier((EntityType)type, propertyValue, (SessionImplementor)session);
                }
                return CompletionStages.completedFuture(propertyValue);
            }
            return CompletionStages.nullFuture();
        });
    }

    private static CompletionStage<Object> loadHibernateProxyEntity(Object entity, SharedSessionContractImplementor session) {
        if (entity instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)entity).getHibernateLazyInitializer();
            String entityName = initializer.getEntityName();
            Object identifier = initializer.getIdentifier();
            return ((ReactiveSessionImpl)session).reactiveImmediateLoad(entityName, identifier).thenApply(result -> {
                SessionUtil.checkEntityFound(session, entityName, identifier, result);
                return result;
            });
        }
        return CompletionStages.completedFuture(entity);
    }
}

