/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveCollectionRecreateAction
extends CollectionAction
implements ReactiveExecutable {
    public ReactiveCollectionRecreateAction(PersistentCollection collection, CollectionPersister persister, Object key, EventSource session) {
        super(persister, collection, key, session);
    }

    @Override
    public CompletionStage<Void> reactiveExecute() {
        PersistentCollection collection = this.getCollection();
        this.preRecreate();
        EventSource session = this.getSession();
        ReactiveCollectionPersister persister = (ReactiveCollectionPersister)this.getPersister();
        return persister.reactiveRecreate(collection, this.getKey(), (SharedSessionContractImplementor)session).thenAccept(arg_0 -> this.lambda$reactiveExecute$0((SharedSessionContractImplementor)session, collection, arg_0));
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("Use reactiveExecute() instead");
    }

    private void preRecreate() {
        this.getFastSessionServices().eventListenerGroup_PRE_COLLECTION_RECREATE.fireLazyEventOnEachListener(this::newPreCollectionRecreateEvent, PreCollectionRecreateEventListener::onPreRecreateCollection);
    }

    private PreCollectionRecreateEvent newPreCollectionRecreateEvent() {
        return new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }

    private void postRecreate() {
        this.getFastSessionServices().eventListenerGroup_POST_COLLECTION_RECREATE.fireLazyEventOnEachListener(this::newPostCollectionRecreateEvent, PostCollectionRecreateEventListener::onPostRecreateCollection);
    }

    private PostCollectionRecreateEvent newPostCollectionRecreateEvent() {
        return new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
    }

    private /* synthetic */ void lambda$reactiveExecute$0(SharedSessionContractImplementor session, PersistentCollection collection, Void v) {
        session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postRecreate();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.recreateCollection(this.getPersister().getRole());
        }
    }
}

