/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.impl.ReactiveEntityInsertAction;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveEntityIdentityInsertAction
extends EntityIdentityInsertAction
implements ReactiveEntityInsertAction {
    private final boolean isVersionIncrementDisabled;
    private boolean executed;
    private boolean transientReferencesNullified;

    public ReactiveEntityIdentityInsertAction(Object[] state, Object instance, EntityPersister persister, boolean isVersionIncrementDisabled, EventSource session, boolean isDelayed) {
        super(state, instance, persister, isVersionIncrementDisabled, session, isDelayed);
        this.isVersionIncrementDisabled = isVersionIncrementDisabled;
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        CompletionStage stage = this.reactiveNullifyTransientReferencesIfNotAlready();
        EntityPersister persister = this.getPersister();
        EventSource session = this.getSession();
        Object instance = this.getInstance();
        this.setVeto(this.preInsert());
        if (!this.isVeto()) {
            ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
            return stage.thenCompose(arg_0 -> this.lambda$reactiveExecute$0(reactivePersister, instance, (SharedSessionContractImplementor)session, arg_0)).thenCompose(arg_0 -> this.lambda$reactiveExecute$2(reactivePersister, instance, (SharedSessionContractImplementor)session, arg_0)).thenAccept(arg_0 -> this.lambda$reactiveExecute$3(persister, instance, (SharedSessionContractImplementor)session, arg_0));
        }
        this.postInsert();
        this.markExecuted();
        return stage;
    }

    private CompletionStage<Void> processInsertGeneratedProperties(ReactiveEntityPersister persister, Object generatedId, Object instance, SharedSessionContractImplementor session) {
        return persister.hasInsertGeneratedProperties() ? persister.reactiveProcessInsertGenerated(generatedId, instance, this.getState(), session) : CompletionStages.voidFuture();
    }

    @Override
    public EntityKey getEntityKey() {
        return super.getEntityKey();
    }

    @Override
    public AbstractEntityInsertAction asAbstractEntityInsertAction() {
        return this;
    }

    protected void markExecuted() {
        super.markExecuted();
        this.executed = true;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isVersionIncrementDisabled() {
        return this.isVersionIncrementDisabled;
    }

    @Override
    public boolean areTransientReferencesNullified() {
        return this.transientReferencesNullified;
    }

    @Override
    public void setTransientReferencesNullified() {
        this.transientReferencesNullified = true;
    }

    private /* synthetic */ void lambda$reactiveExecute$3(EntityPersister persister, Object instance, SharedSessionContractImplementor session, Object generatedId) {
        persister.setIdentifier(instance, generatedId, session);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        persistenceContext.registerInsertedKey(this.getPersister(), generatedId);
        EntityKey entityKey = session.generateEntityKey(generatedId, persister);
        this.setEntityKey(entityKey);
        persistenceContext.checkUniqueness(entityKey, this.getInstance());
        this.postInsert();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !this.isVeto()) {
            statistics.insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
    }

    private /* synthetic */ CompletionStage lambda$reactiveExecute$2(ReactiveEntityPersister reactivePersister, Object instance, SharedSessionContractImplementor session, Object generatedId) {
        this.setGeneratedId(generatedId);
        return this.processInsertGeneratedProperties(reactivePersister, generatedId, instance, session).thenApply(v -> generatedId);
    }

    private /* synthetic */ CompletionStage lambda$reactiveExecute$0(ReactiveEntityPersister reactivePersister, Object instance, SharedSessionContractImplementor session, Void v) {
        return reactivePersister.insertReactive(this.getState(), instance, session);
    }
}

