/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class ReactiveEntityUpdateAction
extends EntityUpdateAction
implements ReactiveExecutable {
    public ReactiveEntityUpdateAction(Object id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityPersister persister, EventSource session) {
        super(id, state, dirtyProperties, hasDirtyCollection, previousState, previousVersion, nextVersion, instance, rowId, persister, session);
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        if (this.preUpdate()) {
            return CompletionStages.voidFuture();
        }
        Object id = this.getId();
        EntityPersister persister = this.getPersister();
        EventSource session = this.getSession();
        Object instance = this.getInstance();
        Object previousVersion = this.getPreviousVersion();
        Object ck = this.lockCacheItem(previousVersion);
        ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
        return reactivePersister.updateReactive(id, this.getState(), this.getDirtyFields(), this.hasDirtyCollection(), this.getPreviousState(), previousVersion, instance, this.getRowId(), (SharedSessionContractImplementor)session).thenApply(arg_0 -> ReactiveEntityUpdateAction.lambda$reactiveExecute$0((SharedSessionContractImplementor)session, instance, arg_0)).thenCompose(this::handleGeneratedProperties).thenAccept(arg_0 -> this.lambda$reactiveExecute$1(persister, instance, ck, (SharedSessionContractImplementor)session, id, arg_0));
    }

    private CompletionStage<EntityEntry> handleGeneratedProperties(EntityEntry entry) {
        EntityPersister persister = this.getPersister();
        if (entry.getStatus() == Status.MANAGED || persister.isVersionPropertyGenerated()) {
            EventSource session = this.getSession();
            Object instance = this.getInstance();
            Object id = this.getId();
            TypeHelper.deepCopy((Object[])this.getState(), (Type[])persister.getPropertyTypes(), (boolean[])persister.getPropertyCheckability(), (Object[])this.getState(), (SharedSessionContractImplementor)session);
            ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
            return this.processGeneratedProperties(id, reactivePersister, (SharedSessionContractImplementor)session, instance).thenAccept(v -> entry.postUpdate(instance, this.getState(), this.getNextVersion())).thenApply(v -> entry);
        }
        return CompletionStages.completedFuture(entry);
    }

    private void handleDeleted(EntityEntry entry, EntityPersister persister, Object instance) {
        if (entry.getStatus() == Status.DELETED) {
            boolean isImpliedOptimisticLocking;
            EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
            boolean bl = isImpliedOptimisticLocking = !entityMetamodel.isVersioned() && entityMetamodel.getOptimisticLockStyle().isAllOrDirty();
            if (isImpliedOptimisticLocking && entry.getLoadedState() != null) {
                entry.postUpdate(instance, this.getState(), this.getNextVersion());
            }
        }
    }

    private CompletionStage<Void> processGeneratedProperties(Object id, ReactiveEntityPersister persister, SharedSessionContractImplementor session, Object instance) {
        if (persister.hasUpdateGeneratedProperties()) {
            if (persister.isVersionPropertyGenerated()) {
                throw new UnsupportedOperationException("generated version attribute not supported in Hibernate Reactive");
            }
            return persister.reactiveProcessUpdateGenerated(id, instance, this.getState(), session);
        }
        return CompletionStages.voidFuture();
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("This action only support reactive functions calls");
    }

    private /* synthetic */ void lambda$reactiveExecute$1(EntityPersister persister, Object instance, Object ck, SharedSessionContractImplementor session, Object id, EntityEntry entry) {
        this.handleDeleted(entry, persister, instance);
        this.updateCacheItem(persister, ck, entry);
        this.handleNaturalIdResolutions(persister, session, id);
        this.postUpdate();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.updateEntity(this.getPersister().getEntityName());
        }
    }

    private static /* synthetic */ EntityEntry lambda$reactiveExecute$0(SharedSessionContractImplementor session, Object instance, Void res) {
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(instance);
        if (entry == null) {
            throw new AssertionFailure("possible non-threadsafe access to session");
        }
        return entry;
    }
}

