/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.mutation.internal;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.EntityMutationOperationGroup;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorPostInsert;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.engine.jdbc.ResultsCheckerUtil;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.id.insert.ReactiveInsertGeneratedIdentifierDelegate;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;

public class ReactiveMutationExecutorPostInsert
extends MutationExecutorPostInsert
implements ReactiveMutationExecutor {
    public ReactiveMutationExecutorPostInsert(EntityMutationOperationGroup mutationOperationGroup, SharedSessionContractImplementor session) {
        super(mutationOperationGroup, session);
    }

    @Override
    public CompletionStage<Object> executeReactive(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return ((ReactiveInsertGeneratedIdentifierDelegate)this.mutationTarget.getIdentityInsertDelegate()).reactivePerformInsert(this.identityInsertStatementDetails, this.getJdbcValueBindings(), modelReference, session).thenApply(this::logId).thenCompose(id -> {
            if (this.secondaryTablesStatementGroup == null) {
                return CompletionStages.completedFuture(id);
            }
            AtomicReference<CompletionStage<Object>> res = new AtomicReference<CompletionStage<Object>>(CompletionStages.completedFuture(id));
            this.secondaryTablesStatementGroup.forEachStatement((tableName, statementDetails) -> res.set(((CompletionStage)res.get()).thenCompose(i -> this.reactiveExecuteWithId(i, (String)tableName, (PreparedStatementDetails)statementDetails, inclusionChecker, resultChecker, session))));
            return res.get();
        });
    }

    private Object logId(Object identifier) {
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Post-insert generated value : `%s` (%s)", identifier, (Object)this.mutationTarget.getNavigableRole().getFullPath());
        }
        return identifier;
    }

    private CompletionStage<Object> reactiveExecuteWithId(Object id, String tableName, PreparedStatementDetails statementDetails, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (statementDetails == null) {
            return CompletionStages.completedFuture(id);
        }
        EntityTableMapping tableDetails = (EntityTableMapping)statementDetails.getMutatingTableDetails();
        assert (!tableDetails.isIdentifierTable());
        if (inclusionChecker != null && !inclusionChecker.include((TableMapping)tableDetails)) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping execution of secondary insert : %s", (Object)tableDetails.getTableName());
            }
            return CompletionStages.completedFuture(id);
        }
        tableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> this.valueBindings.bindValue(jdbcValue, tableName, columnMapping.getColumnName(), ParameterUsage.SET), session);
        session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            details.resolveStatement();
            this.valueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        String sqlString = statementDetails.getSqlString();
        return reactiveConnection.update(sqlString, params).thenApply(affectedRowCount -> {
            if (affectedRowCount == 0 && tableDetails.isOptional()) {
                return CompletionStages.completedFuture(id);
            }
            ResultsCheckerUtil.checkResults(session, statementDetails, resultChecker, affectedRowCount, -1);
            return id;
        }).whenComplete((unused, throwable) -> {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            this.valueBindings.afterStatement((TableMapping)tableDetails);
        });
    }
}

