/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.mutation.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.EntityMutationOperationGroup;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorPostInsertSingleTable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.id.insert.ReactiveInsertGeneratedIdentifierDelegate;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.ValuesAnalysis;

public class ReactiveMutationExecutorPostInsertSingleTable
extends MutationExecutorPostInsertSingleTable
implements ReactiveMutationExecutor {
    private final EntityMutationTarget mutationTarget;
    private final PreparedStatementDetails identityInsertStatementDetails;

    public ReactiveMutationExecutorPostInsertSingleTable(EntityMutationOperationGroup mutationOperationGroup, SharedSessionContractImplementor session) {
        super(mutationOperationGroup, session);
        this.mutationTarget = mutationOperationGroup.getMutationTarget();
        PreparableMutationOperation operation = (PreparableMutationOperation)mutationOperationGroup.getOperation(this.mutationTarget.getIdentifierTableName());
        this.identityInsertStatementDetails = ModelMutationHelper.identityPreparation((PreparableMutationOperation)operation, (SharedSessionContractImplementor)session);
    }

    @Override
    public CompletionStage<Object> executeReactive(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return ((ReactiveInsertGeneratedIdentifierDelegate)this.mutationTarget.getIdentityInsertDelegate()).reactivePerformInsert(this.identityInsertStatementDetails, this.getJdbcValueBindings(), modelReference, session).thenApply(this::logId);
    }

    private Object logId(Object identifier) {
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Post-insert generated value : `%s` (%s)", identifier, (Object)this.mutationTarget.getNavigableRole().getFullPath());
        }
        return identifier;
    }
}

