/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.mutation.internal;

import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorStandard;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;

public class ReactiveMutationExecutorStandard
extends MutationExecutorStandard
implements ReactiveMutationExecutor {
    public ReactiveMutationExecutorStandard(MutationOperationGroup mutationOperationGroup, BatchKeyAccess batchKeySupplier, int batchSize, SharedSessionContractImplementor session) {
        super(mutationOperationGroup, batchKeySupplier, batchSize, session);
    }

    private ReactiveConnection connection(SharedSessionContractImplementor session) {
        return ((ReactiveConnectionSupplier)session).getReactiveConnection();
    }

    @Override
    public CompletionStage<Void> performReactiveBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return ReactiveMutationExecutor.super.performReactiveBatchedOperations(valuesAnalysis, inclusionChecker, resultChecker, session);
    }

    protected void performNonBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("performReactiveNonBatchedOperations");
    }

    protected void performSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("performReactiveSelfExecutingOperations");
    }

    protected void performBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker) {
        throw LOG.nonReactiveMethodCall("performReactiveBatchedOperations");
    }

    @Override
    public CompletionStage<Void> performReactiveNonBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (this.getNonBatchedStatementGroup() == null || this.getNonBatchedStatementGroup().getNumberOfStatements() <= 0) {
            return CompletionStages.voidFuture();
        }
        PreparedStatementGroup nonBatchedStatementGroup = this.getNonBatchedStatementGroup();
        OperationsForEach forEach = new OperationsForEach(inclusionChecker, resultChecker, session, this.getJdbcValueBindings());
        nonBatchedStatementGroup.forEachStatement(forEach::add);
        return forEach.buildLoop();
    }

    @Override
    public CompletionStage<Void> performReactiveNonBatchedMutation(PreparedStatementDetails statementDetails, JdbcValueBindings valueBindings, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        if (statementDetails == null) {
            return CompletionStages.voidFuture();
        }
        TableMapping tableDetails = statementDetails.getMutatingTableDetails();
        if (inclusionChecker != null && !inclusionChecker.include(tableDetails)) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping execution of secondary insert : %s", (Object)tableDetails.getTableName());
            }
            return CompletionStages.voidFuture();
        }
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            valueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        return this.connection(session).update(statementDetails.getSqlString(), params).thenCompose(affectedRowCount -> ReactiveMutationExecutorStandard.checkResult(session, statementDetails, resultChecker, tableDetails, affectedRowCount)).whenComplete((unused, throwable) -> {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(tableDetails);
        });
    }

    private static CompletionStage<Void> checkResult(SharedSessionContractImplementor session, PreparedStatementDetails statementDetails, OperationResultChecker resultChecker, TableMapping tableDetails, Integer affectedRowCount) {
        if (affectedRowCount == 0 && tableDetails.isOptional()) {
            return CompletionStages.voidFuture();
        }
        try {
            ModelMutationHelper.checkResults((OperationResultChecker)resultChecker, (PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)-1);
            return CompletionStages.voidFuture();
        }
        catch (SQLException e) {
            JDBCException exception = session.getJdbcServices().getSqlExceptionHelper().convert(e, String.format("Unable to execute mutation PreparedStatement against table `%s`", tableDetails.getTableName()), statementDetails.getSqlString());
            return CompletionStages.failedFuture((Throwable)exception);
        }
    }

    public void release() {
    }

    private class OperationsForEach {
        private final TableInclusionChecker inclusionChecker;
        private final OperationResultChecker resultChecker;
        private final SharedSessionContractImplementor session;
        private final JdbcValueBindings jdbcValueBindings;
        private CompletionStage<Void> loop = CompletionStages.voidFuture();

        public OperationsForEach(TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
            this.inclusionChecker = inclusionChecker;
            this.resultChecker = resultChecker;
            this.session = session;
            this.jdbcValueBindings = jdbcValueBindings;
        }

        public void add(String tableName, PreparedStatementDetails statementDetails) {
            this.loop = this.loop.thenCompose(v -> ReactiveMutationExecutorStandard.this.performReactiveNonBatchedMutation(statementDetails, ReactiveMutationExecutorStandard.this.getJdbcValueBindings(), this.inclusionChecker, this.resultChecker, this.session));
        }

        public CompletionStage<Void> buildLoop() {
            return this.loop;
        }
    }
}

