/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.OnUpdateVisitor;
import org.hibernate.event.internal.PostDeleteEventListenerStandardImpl;
import org.hibernate.event.service.spi.JpaBootstrapSensitive;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.EmptyInterceptor;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.engine.impl.ReactiveCollectionRemoveAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityDeleteAction;
import org.hibernate.reactive.engine.impl.ReactiveOrphanRemovalAction;
import org.hibernate.reactive.event.ReactiveDeleteEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class DefaultReactiveDeleteEventListener
implements DeleteEventListener,
ReactiveDeleteEventListener,
CallbackRegistryConsumer,
JpaBootstrapSensitive {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private CallbackRegistry callbackRegistry;
    private boolean jpaBootstrap;

    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void wasJpaBootstrap(boolean wasJpaBootstrap) {
        this.jpaBootstrap = wasJpaBootstrap;
    }

    @Deprecated
    public void onDelete(DeleteEvent event) {
        throw LOG.nonReactiveMethodCall("reactiveOnDelete");
    }

    @Deprecated
    public void onDelete(DeleteEvent event, DeleteContext transientEntities) throws HibernateException {
        throw LOG.nonReactiveMethodCall("reactiveOnDelete");
    }

    @Override
    public CompletionStage<Void> reactiveOnDelete(DeleteEvent event) throws HibernateException {
        return this.reactiveOnDelete(event, DeleteContext.create());
    }

    @Override
    public CompletionStage<Void> reactiveOnDelete(DeleteEvent event, DeleteContext transientEntities) throws HibernateException {
        if (this.optimizeUnloadedDelete(event)) {
            return CompletionStages.voidFuture();
        }
        EventSource source = event.getSession();
        Object object = event.getObject();
        if (object instanceof CompletionStage) {
            CompletionStage objectStage = (CompletionStage)object;
            return objectStage.thenCompose(objectEvent -> this.fetchAndDelete(event, transientEntities, source, objectEvent));
        }
        return this.fetchAndDelete(event, transientEntities, source, object);
    }

    private boolean optimizeUnloadedDelete(DeleteEvent event) {
        Object object = event.getObject();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)object);
        if (lazyInitializer != null && lazyInitializer.isUninitialized()) {
            EventSource source = event.getSession();
            EntityPersister persister = source.getFactory().getMappingMetamodel().findEntityDescriptor(lazyInitializer.getEntityName());
            Object id = lazyInitializer.getIdentifier();
            EntityKey key = source.generateEntityKey(id, persister);
            PersistenceContext persistenceContext = source.getPersistenceContextInternal();
            if (!persistenceContext.containsEntity(key) && this.canBeDeletedWithoutLoading(source, persister)) {
                persistenceContext.reassociateProxy(object, id);
                if (!persistenceContext.containsDeletedUnloadedEntityKey(key)) {
                    persistenceContext.registerDeletedUnloadedEntityKey(key);
                    if (persister.hasOwnedCollections()) {
                        for (Type type : persister.getPropertyTypes()) {
                            DefaultReactiveDeleteEventListener.deleteOwnedCollections(type, id, source);
                        }
                    }
                    ((ReactiveSession)source).getReactiveActionQueue().addAction(new ReactiveEntityDeleteAction(id, persister, source));
                }
                return true;
            }
        }
        return false;
    }

    private static void deleteOwnedCollections(Type type, Object key, EventSource session) {
        MappingMetamodelImplementor mappingMetamodel = session.getFactory().getMappingMetamodel();
        ReactiveActionQueue actionQueue = ((ReactiveSession)session).getReactiveActionQueue();
        if (type.isCollectionType()) {
            String role = ((CollectionType)type).getRole();
            CollectionPersister persister = mappingMetamodel.getCollectionDescriptor(role);
            if (!persister.isInverse()) {
                actionQueue.addAction(new ReactiveCollectionRemoveAction(persister, key, session));
            }
        } else if (type.isComponentType()) {
            Type[] subtypes;
            for (Type subtype : subtypes = ((CompositeType)type).getSubtypes()) {
                DefaultReactiveDeleteEventListener.deleteOwnedCollections(subtype, key, session);
            }
        }
    }

    private CompletionStage<Void> fetchAndDelete(DeleteEvent event, DeleteContext transientEntities, EventSource source, Object objectEvent) {
        boolean detached;
        boolean bl = event.getEntityName() != null ? !source.contains(event.getEntityName(), objectEvent) : (detached = !source.contains(objectEvent));
        if (detached) {
            throw new IllegalArgumentException("unmanaged instance passed to remove()");
        }
        return ((ReactiveSession)source).reactiveFetch(objectEvent, true).thenCompose(entity -> this.reactiveOnDelete(event, transientEntities, entity));
    }

    private CompletionStage<Void> reactiveOnDelete(DeleteEvent event, DeleteContext transientEntities, Object entity) {
        PersistenceContext persistenceContext = event.getSession().getPersistenceContextInternal();
        EntityEntry entityEntry = persistenceContext.getEntry(entity);
        if (entityEntry == null) {
            return this.deleteTransientInstance(event, transientEntities, entity);
        }
        return this.deletePersistentInstance(event, transientEntities, entity, entityEntry);
    }

    private CompletionStage<Void> deleteTransientInstance(DeleteEvent event, DeleteContext transientEntities, Object entity) {
        LOG.trace("Entity was not persistent in delete processing");
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        return ForeignKeys.isTransient(persister.getEntityName(), entity, null, source.getSession()).thenCompose(trans -> {
            if (trans.booleanValue()) {
                return this.deleteTransientEntity(source, entity, persister, transientEntities);
            }
            this.performDetachedEntityDeletionCheck(event);
            Object id = persister.getIdentifier(entity, (SharedSessionContractImplementor)source);
            if (id == null) {
                throw new TransientObjectException("the detached instance passed to delete() had a null identifier");
            }
            PersistenceContext persistenceContext = source.getPersistenceContextInternal();
            EntityKey key = source.generateEntityKey(id, persister);
            persistenceContext.checkUniqueness(key, entity);
            new OnUpdateVisitor(source, id, entity).process(entity, persister);
            Object version = persister.getVersion(entity);
            EntityEntry entry = persistenceContext.addEntity(entity, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, persister.getValues(entity), key, version, LockMode.NONE, true, persister, false);
            persister.afterReassociate(entity, (SharedSessionContractImplementor)source);
            return this.delete(event, transientEntities, source, entity, persister, id, version, entry);
        });
    }

    private CompletionStage<Void> deletePersistentInstance(DeleteEvent event, DeleteContext transientEntities, Object entity, EntityEntry entityEntry) {
        LOG.trace("Deleting a persistent instance");
        EventSource source = event.getSession();
        if (entityEntry.getStatus().isDeletedOrGone() || source.getPersistenceContextInternal().containsDeletedUnloadedEntityKey(entityEntry.getEntityKey())) {
            LOG.trace("Object was already deleted");
            return CompletionStages.voidFuture();
        }
        return this.delete(event, transientEntities, source, entity, entityEntry.getPersister(), entityEntry.getId(), entityEntry.getVersion(), entityEntry);
    }

    private CompletionStage<Void> delete(DeleteEvent event, DeleteContext transientEntities, EventSource source, Object entity, EntityPersister persister, Object id, Object version, EntityEntry entry) {
        this.callbackRegistry.preRemove(entity);
        return this.deleteEntity(source, entity, entry, event.isCascadeDeleteEnabled(), event.isOrphanRemovalBeforeUpdates(), persister, transientEntities).thenAccept(v -> {
            if (source.getFactory().getSessionFactoryOptions().isIdentifierRollbackEnabled()) {
                persister.resetIdentifier(entity, id, version, (SharedSessionContractImplementor)source);
            }
        });
    }

    private boolean canBeDeletedWithoutLoading(EventSource source, EntityPersister persister) {
        return source.getInterceptor() == EmptyInterceptor.INSTANCE && !persister.implementsLifecycle() && !persister.hasSubclasses() && !persister.hasCascadeDelete() && !persister.hasNaturalIdentifier() && !persister.hasCollectionNotReferencingPK() && !this.hasRegisteredRemoveCallbacks(persister) && !DefaultReactiveDeleteEventListener.hasCustomEventListeners(source);
    }

    private static boolean hasCustomEventListeners(EventSource source) {
        FastSessionServices fss = source.getFactory().getFastSessionServices();
        return fss.eventListenerGroup_PRE_DELETE.count() > 0 || fss.eventListenerGroup_POST_DELETE.count() > 1 || fss.eventListenerGroup_POST_DELETE.count() == 1 && !(fss.eventListenerGroup_POST_DELETE.listeners().iterator().next() instanceof PostDeleteEventListenerStandardImpl);
    }

    private boolean hasRegisteredRemoveCallbacks(EntityPersister persister) {
        Class mappedClass = persister.getMappedClass();
        return this.callbackRegistry.hasRegisteredCallbacks(mappedClass, CallbackType.PRE_REMOVE) || this.callbackRegistry.hasRegisteredCallbacks(mappedClass, CallbackType.POST_REMOVE);
    }

    protected void performDetachedEntityDeletionCheck(DeleteEvent event) {
        if (this.jpaBootstrap) {
            this.disallowDeletionOfDetached(event);
        }
    }

    private void disallowDeletionOfDetached(DeleteEvent event) {
        EventSource source = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = source.getEntityPersister(entityName, event.getObject());
        Object id = persister.getIdentifier(event.getObject(), (SharedSessionContractImplementor)source);
        entityName = entityName == null ? source.guessEntityName(event.getObject()) : entityName;
        throw new IllegalArgumentException("Removing a detached instance " + entityName + "#" + id);
    }

    protected CompletionStage<Void> deleteTransientEntity(EventSource session, Object entity, EntityPersister persister, DeleteContext transientEntities) {
        LOG.handlingTransientEntity();
        if (transientEntities.add(entity)) {
            return this.cascadeBeforeDelete(session, persister, entity, transientEntities).thenCompose(v -> this.cascadeAfterDelete(session, persister, entity, transientEntities));
        }
        LOG.trace("Already handled transient entity; skipping");
        return CompletionStages.voidFuture();
    }

    protected CompletionStage<Void> deleteEntity(EventSource session, Object entity, EntityEntry entityEntry, boolean isCascadeDeleteEnabled, boolean isOrphanRemovalBeforeUpdates, EntityPersister persister, DeleteContext transientEntities) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Deleting {0}", MessageHelper.infoString((EntityPersister)persister, (Object)entityEntry.getId(), (SessionFactoryImplementor)session.getFactory()));
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object version = entityEntry.getVersion();
        Object[] currentState = entityEntry.getLoadedState() == null ? persister.getValues(entity) : entityEntry.getLoadedState();
        Object[] deletedState = this.createDeletedState(persister, entity, currentState, session);
        entityEntry.setDeletedState(deletedState);
        session.getInterceptor().onDelete(entity, entityEntry.getId(), deletedState, persister.getPropertyNames(), persister.getPropertyTypes());
        persistenceContext.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey key = session.generateEntityKey(entityEntry.getId(), persister);
        return this.cascadeBeforeDelete(session, persister, entity, transientEntities).thenCompose(v -> new ForeignKeys.Nullifier(entity, true, false, (SessionImplementor)session, persister).nullifyTransientReferences(entityEntry.getDeletedState()).thenAccept(vv -> {
            new Nullability((SharedSessionContractImplementor)session).checkNullability(entityEntry.getDeletedState(), persister, Nullability.NullabilityCheckType.DELETE);
            persistenceContext.registerNullifiableEntityKey(key);
            ReactiveActionQueue actionQueue = this.actionQueue(session);
            if (isOrphanRemovalBeforeUpdates) {
                actionQueue.addAction(new ReactiveOrphanRemovalAction(entityEntry.getId(), deletedState, version, entity, persister, isCascadeDeleteEnabled, session));
            } else {
                actionQueue.addAction(new ReactiveEntityDeleteAction(entityEntry.getId(), deletedState, version, entity, persister, isCascadeDeleteEnabled, session));
            }
        })).thenCompose(v -> this.cascadeAfterDelete(session, persister, entity, transientEntities));
    }

    private ReactiveActionQueue actionQueue(EventSource session) {
        return ((ReactiveSession)session.unwrap(ReactiveSession.class)).getReactiveActionQueue();
    }

    private Object[] createDeletedState(EntityPersister persister, Object parent, Object[] currentState, EventSource eventSource) {
        Type[] types = persister.getPropertyTypes();
        Object[] deletedState = new Object[types.length];
        if (!persister.hasCollections() || !persister.hasUninitializedLazyProperties(parent)) {
            boolean[] copyability = new boolean[types.length];
            Arrays.fill(copyability, true);
            TypeHelper.deepCopy((Object[])currentState, (Type[])types, (boolean[])copyability, (Object[])deletedState, (SharedSessionContractImplementor)eventSource);
            return deletedState;
        }
        String[] propertyNames = persister.getPropertyNames();
        BytecodeEnhancementMetadata enhancementMetadata = persister.getBytecodeEnhancementMetadata();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isCollectionType() && !enhancementMetadata.isAttributeLoaded(parent, propertyNames[i])) {
                CollectionType collectionType = (CollectionType)types[i];
                CollectionPersister collectionDescriptor = persister.getFactory().getMappingMetamodel().getCollectionDescriptor(collectionType.getRole());
                if (collectionDescriptor.needsRemove() || collectionDescriptor.hasCache()) {
                    Object keyOfOwner = collectionType.getKeyOfOwner(parent, (SharedSessionContractImplementor)eventSource.getSession());
                    deletedState[i] = collectionType.getCollection(keyOfOwner, (SharedSessionContractImplementor)eventSource.getSession(), parent, Boolean.valueOf(false));
                    continue;
                }
                deletedState[i] = currentState[i];
                continue;
            }
            deletedState[i] = currentState[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || currentState[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? currentState[i] : types[i].deepCopy(currentState[i], eventSource.getFactory());
        }
        return deletedState;
    }

    protected CompletionStage<Void> cascadeBeforeDelete(EventSource session, EntityPersister persister, Object entity, DeleteContext transientEntities) throws HibernateException {
        return Cascade.fetchLazyAssociationsBeforeCascade(CascadingActions.DELETE, persister, entity, session).thenCompose(v -> new Cascade<DeleteContext>(CascadingActions.DELETE, CascadePoint.AFTER_INSERT_BEFORE_DELETE, persister, entity, transientEntities, session).cascade());
    }

    protected CompletionStage<Void> cascadeAfterDelete(EventSource session, EntityPersister persister, Object entity, DeleteContext transientEntities) throws HibernateException {
        return new Cascade<DeleteContext>(CascadingActions.DELETE, CascadePoint.BEFORE_INSERT_AFTER_DELETE, persister, entity, transientEntities, session).cascade();
    }
}

