/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.engine.impl.EntityTypes;
import org.hibernate.reactive.event.ReactiveMergeEventListener;
import org.hibernate.reactive.event.impl.AbstractReactiveSaveEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class DefaultReactiveMergeEventListener
extends AbstractReactiveSaveEventListener<MergeContext>
implements ReactiveMergeEventListener,
MergeEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public void onMerge(MergeEvent event) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public void onMerge(MergeEvent event, MergeContext copiedAlready) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Map<Object, Object> getMergeMap(MergeContext context) {
        return context.invertMap();
    }

    @Override
    public CompletionStage<Void> reactiveOnMerge(MergeEvent event) throws HibernateException {
        EventSource session = event.getSession();
        EntityCopyObserver entityCopyObserver = this.createEntityCopyObserver(session);
        MergeContext mergeContext = new MergeContext(session, entityCopyObserver);
        return this.reactiveOnMerge(event, mergeContext).thenAccept(v -> entityCopyObserver.topLevelMergeComplete(session)).whenComplete((v, e) -> {
            entityCopyObserver.clear();
            mergeContext.clear();
        });
    }

    private EntityCopyObserver createEntityCopyObserver(EventSource session) {
        return session.getFactory().getFastSessionServices().entityCopyObserverFactory.createEntityCopyObserver();
    }

    @Override
    public CompletionStage<Void> reactiveOnMerge(MergeEvent event, MergeContext copiedAlready) throws HibernateException {
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            EventSource source = event.getSession();
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)original);
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.load(lazyInitializer.getEntityName(), lazyInitializer.getInternalIdentifier()));
                    return CompletionStages.voidFuture();
                }
                entity = lazyInitializer.getImplementation();
            } else if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)original)) {
                PersistentAttributeInterceptable interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)original);
                PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
                if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                    EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                    LOG.trace("Ignoring uninitialized enhanced-proxy");
                    event.setResult(source.load(proxyInterceptor.getEntityName(), (Object)((Serializable)proxyInterceptor.getIdentifier())));
                    return CompletionStages.voidFuture();
                }
                entity = original;
            } else {
                entity = original;
            }
            return this.doMerge(event, copiedAlready, entity);
        }
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> doMerge(MergeEvent event, MergeContext copiedAlready, Object entity) {
        if (copiedAlready.containsKey(entity) && copiedAlready.isOperatedOn(entity)) {
            LOG.trace("Already in merge process");
            event.setResult(entity);
            return CompletionStages.voidFuture();
        }
        if (copiedAlready.containsKey(entity)) {
            LOG.trace("Already in copyCache; setting in merge process");
            copiedAlready.setOperatedOn(entity, true);
        }
        event.setEntity(entity);
        return this.merge(event, copiedAlready, entity);
    }

    private CompletionStage<Void> merge(MergeEvent event, MergeContext copiedAlready, Object entity) {
        switch (DefaultReactiveMergeEventListener.entityState(event, entity)) {
            case DETACHED: {
                return this.entityIsDetached(event, copiedAlready);
            }
            case TRANSIENT: {
                return this.entityIsTransient(event, copiedAlready);
            }
            case PERSISTENT: {
                return this.entityIsPersistent(event, copiedAlready);
            }
        }
        throw new ObjectDeletedException("deleted instance passed to merge", null, EventUtil.getLoggableName((String)event.getEntityName(), (Object)entity));
    }

    private static EntityState entityState(MergeEvent event, Object entity) {
        Object managedEntity;
        EntityPersister persister;
        Object id;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null && (id = (persister = source.getEntityPersister(event.getEntityName(), entity)).getIdentifier(entity, (SharedSessionContractImplementor)source)) != null && (entry = persistenceContext.getEntry(managedEntity = persistenceContext.getEntity(source.generateEntityKey(id, persister)))) != null) {
            return EntityState.DETACHED;
        }
        return EntityState.getEntityState((Object)entity, (String)event.getEntityName(), (EntityEntry)entry, (SessionImplementor)source, (Boolean)false);
    }

    protected CompletionStage<Void> entityIsPersistent(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        copyCache.put(entity, entity, true);
        return this.cascadeOnMerge(source, persister, entity, copyCache).thenCompose(v -> this.fetchAndCopyValues(persister, entity, entity, (SessionImplementor)source, copyCache)).thenAccept(v -> event.setResult(entity));
    }

    protected CompletionStage<Void> entityIsTransient(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource session = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        Object id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity, (SharedSessionContractImplementor)session) : null;
        Object copy = DefaultReactiveMergeEventListener.copyEntity(copyCache, entity, session, persister, id);
        return super.cascadeBeforeSave(session, persister, entity, copyCache).thenCompose(v -> this.copyValues(persister, entity, copy, (SessionImplementor)session, copyCache, ForeignKeyDirection.FROM_PARENT)).thenCompose(v -> this.saveTransientEntity(copy, entityName, event.getRequestedId(), session, copyCache)).thenCompose(v -> super.cascadeAfterSave(session, persister, entity, copyCache)).thenCompose(v -> this.copyValues(persister, entity, copy, (SessionImplementor)session, copyCache, ForeignKeyDirection.TO_PARENT)).thenAccept(v -> new CollectionVisitor(copy, id, session).processEntityPropertyValues(persister.getPropertyValuesToInsert(copy, this.getMergeMap(copyCache), (SharedSessionContractImplementor)session), persister.getPropertyTypes())).thenAccept(v -> {
            PersistentAttributeInterceptable interceptable;
            PersistentAttributeInterceptor interceptor;
            event.setResult(copy);
            if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)copy) && (interceptor = (interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)copy)).$$_hibernate_getInterceptor()) == null) {
                persister.getBytecodeEnhancementMetadata().injectInterceptor(copy, id, (SharedSessionContractImplementor)session);
            }
        });
    }

    private static Object copyEntity(MergeContext copyCache, Object entity, EventSource session, EntityPersister persister, Object id) {
        Object existingCopy = copyCache.get(entity);
        if (existingCopy != null) {
            persister.setIdentifier(copyCache.get(entity), id, (SharedSessionContractImplementor)session);
            return existingCopy;
        }
        Object copy = session.instantiate(persister, id);
        copyCache.put(entity, copy, true);
        return copy;
    }

    private CompletionStage<Void> saveTransientEntity(Object entity, String entityName, Object requestedId, EventSource source, MergeContext copyCache) {
        return requestedId == null ? this.reactiveSaveWithGeneratedId(entity, entityName, copyCache, source, false) : this.reactiveSaveWithRequestedId(entity, requestedId, entityName, copyCache, source);
    }

    protected CompletionStage<Void> entityIsDetached(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        Object id = DefaultReactiveMergeEventListener.getDetachedEntityId(event, entity, persister);
        Object clonedIdentifier = persister.getIdentifierType().deepCopy(id, source.getFactory());
        return ((CompletionStage)source.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.MERGE, () -> ((ReactiveSession)source.unwrap(ReactiveSession.class)).reactiveGet(persister.getMappedClass(), clonedIdentifier))).thenCompose(result -> {
            if (result == null) {
                return this.entityIsTransient(event, copyCache);
            }
            copyCache.put(entity, result, true);
            Object target = DefaultReactiveMergeEventListener.targetEntity(event, entity, persister, id, result);
            return this.cascadeOnMerge(source, persister, entity, copyCache).thenCompose(v -> this.fetchAndCopyValues(persister, entity, target, (SessionImplementor)source, copyCache)).thenAccept(v -> {
                DefaultReactiveMergeEventListener.markInterceptorDirty(entity, target);
                event.setResult(result);
            });
        });
    }

    private static Object targetEntity(MergeEvent event, Object entity, EntityPersister persister, Object id, Object result) {
        EventSource source = event.getSession();
        String entityName = persister.getEntityName();
        Object target = DefaultReactiveMergeEventListener.unproxyManagedForDetachedMerging(entity, result, persister, source);
        if (target == entity) {
            throw new AssertionFailure("entity was not detached");
        }
        if (!source.getEntityName(target).equals(entityName)) {
            throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
        }
        if (DefaultReactiveMergeEventListener.isVersionChanged(entity, source, persister, target)) {
            StatisticsImplementor statistics = source.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.optimisticFailure(entityName);
            }
            throw new StaleObjectStateException(entityName, id);
        }
        return target;
    }

    private static Object getDetachedEntityId(MergeEvent event, Object entity, EntityPersister persister) {
        EventSource source = event.getSession();
        Object id = event.getRequestedId();
        if (id == null) {
            return persister.getIdentifier(entity, (SharedSessionContractImplementor)source);
        }
        Object entityId = persister.getIdentifier(entity, (SharedSessionContractImplementor)source);
        if (!persister.getIdentifierType().isEqual(id, entityId, source.getFactory())) {
            throw LOG.mergeRequestedIdNotMatchingIdOfPassedEntity();
        }
        return id;
    }

    private static Object unproxyManagedForDetachedMerging(Object incoming, Object managed, EntityPersister persister, EventSource source) {
        if (ManagedTypeHelper.isHibernateProxy((Object)managed)) {
            return source.getPersistenceContextInternal().unproxy(managed);
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)incoming) && persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
            PersistentAttributeInterceptor incomingInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)incoming).$$_hibernate_getInterceptor();
            PersistentAttributeInterceptor managedInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)managed).$$_hibernate_getInterceptor();
            if (!(managedInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
                return managed;
            }
            if (incomingInterceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                return managed;
            }
            return persister.initializeEnhancedEntityUsedAsProxy(managed, null, (SharedSessionContractImplementor)source);
        }
        return managed;
    }

    private static void markInterceptorDirty(Object entity, Object target) {
        if (ManagedTypeHelper.isSelfDirtinessTracker((Object)entity) && ManagedTypeHelper.isSelfDirtinessTracker((Object)target)) {
            SelfDirtinessTracker selfDirtinessTrackerTarget = ManagedTypeHelper.asSelfDirtinessTracker((Object)target);
            selfDirtinessTrackerTarget.$$_hibernate_clearDirtyAttributes();
            for (String fieldName : ManagedTypeHelper.asSelfDirtinessTracker((Object)entity).$$_hibernate_getDirtyAttributes()) {
                selfDirtinessTrackerTarget.$$_hibernate_trackChange(fieldName);
            }
        }
    }

    private static boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (persister.isVersioned()) {
            boolean changed = !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity));
            return changed && DefaultReactiveMergeEventListener.existsInDatabase(target, source, persister);
        }
        return false;
    }

    private static boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Object id;
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, (SharedSessionContractImplementor)source)) != null) {
            EntityKey key = source.generateEntityKey(id, persister);
            Object managedEntity = persistenceContext.getEntity(key);
            entry = persistenceContext.getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    private CompletionStage<Void> fetchAndCopyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext mergeContext) {
        if (entity == target) {
            return this.copyValues(persister, entity, target, source, mergeContext);
        }
        ReactiveSession session = (ReactiveSession)source.unwrap(ReactiveSession.class);
        Object[] mergeState = persister.getValues(entity);
        Object[] managedState = persister.getValues(target);
        return CompletionStages.loop(0, mergeState.length, i -> Hibernate.isInitialized((Object)mergeState[i]) && !Hibernate.isInitialized((Object)managedState[i]), i -> session.reactiveFetch(managedState[i], true)).thenCompose(v -> this.copyValues(persister, entity, target, source, mergeContext));
    }

    protected CompletionStage<Void> copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache) {
        return EntityTypes.replace(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, (Map<Object, Object>)copyCache).thenAccept(copiedValues -> persister.setValues(target, copiedValues));
    }

    protected CompletionStage<Void> copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache, ForeignKeyDirection foreignKeyDirection) {
        if (foreignKeyDirection == ForeignKeyDirection.TO_PARENT) {
            Object[] copiedValues2 = TypeHelper.replaceAssociations((Object[])persister.getValues(entity), (Object[])persister.getValues(target), (Type[])persister.getPropertyTypes(), (SharedSessionContractImplementor)source, (Object)target, (Map)copyCache, (ForeignKeyDirection)foreignKeyDirection);
            persister.setValues(target, copiedValues2);
            return CompletionStages.voidFuture();
        }
        return EntityTypes.replace(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, (Map<Object, Object>)copyCache, foreignKeyDirection).thenAccept(copiedValues -> persister.setValues(target, copiedValues));
    }

    protected CompletionStage<Void> cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, MergeContext copyCache) {
        return new Cascade<MergeContext>(this.getCascadeReactiveAction(), CascadePoint.BEFORE_MERGE, persister, entity, copyCache, source).cascade();
    }

    @Override
    protected CascadingAction<MergeContext> getCascadeReactiveAction() {
        return CascadingActions.MERGE;
    }

    @Override
    protected CompletionStage<Void> cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) {
        return CompletionStages.voidFuture();
    }

    @Override
    protected CompletionStage<Void> cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) {
        return CompletionStages.voidFuture();
    }

    private static class CollectionVisitor
    extends WrapVisitor {
        CollectionVisitor(Object entity, Object id, EventSource session) {
            super(entity, id, session);
        }

        protected Object processCollection(Object collection, CollectionType collectionType) throws HibernateException {
            if (collection instanceof PersistentCollection) {
                PersistentCollection coll = (PersistentCollection)collection;
                CollectionPersister persister = this.getSession().getFactory().getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(collectionType.getRole());
                CollectionEntry collectionEntry = (CollectionEntry)this.getSession().getPersistenceContextInternal().getCollectionEntries().get(coll);
                if (!coll.equalsSnapshot(persister)) {
                    collectionEntry.resetStoredSnapshot(coll, coll.getSnapshot(persister));
                }
            }
            return null;
        }
    }
}

