/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.event.ReactivePersistEventListener;
import org.hibernate.reactive.event.impl.AbstractReactiveSaveEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.util.impl.CompletionStages;

public class DefaultReactivePersistEventListener
extends AbstractReactiveSaveEventListener<PersistContext>
implements PersistEventListener,
ReactivePersistEventListener,
CallbackRegistryConsumer {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    @Override
    protected CascadingAction<PersistContext> getCascadeReactiveAction() {
        return CascadingActions.PERSIST;
    }

    public void onPersist(PersistEvent event) throws HibernateException {
        throw new UnsupportedOperationException("Call #reactivePersist(PersistEvent) instead");
    }

    @Override
    public CompletionStage<Void> reactiveOnPersist(PersistEvent event) {
        return this.reactiveOnPersist(event, PersistContext.create());
    }

    public void onPersist(PersistEvent event, PersistContext createdAlready) throws HibernateException {
        throw new UnsupportedOperationException("Call #reactivePersist(PersistEvent, PersistContext) instead");
    }

    @Override
    public CompletionStage<Void> reactiveOnPersist(PersistEvent event, PersistContext createCache) {
        Object object = event.getObject();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)object);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return lazyInitializer.getSession() == event.getSession() ? CompletionStages.voidFuture() : CompletionStages.failedFuture((Throwable)new PersistentObjectException("uninitialized proxy passed to persist()"));
            }
            return this.persist(event, createCache, lazyInitializer.getImplementation());
        }
        return this.persist(event, createCache, object);
    }

    private CompletionStage<Void> persist(PersistEvent event, PersistContext createCache, Object entity) {
        EventSource source = event.getSession();
        EntityEntry entityEntry = source.getPersistenceContextInternal().getEntry(entity);
        String entityName = DefaultReactivePersistEventListener.entityName(event, entity, entityEntry);
        switch (DefaultReactivePersistEventListener.entityState(event, entity, entityName, entityEntry)) {
            case DETACHED: {
                return CompletionStages.failedFuture((Throwable)new PersistentObjectException("detached entity passed to persist: " + EventUtil.getLoggableName((String)event.getEntityName(), (Object)entity)));
            }
            case PERSISTENT: {
                return this.entityIsPersistent(event, createCache);
            }
            case TRANSIENT: {
                return this.entityIsTransient(event, createCache);
            }
            case DELETED: {
                entityEntry.setStatus(Status.MANAGED);
                entityEntry.setDeletedState(null);
                event.getSession().getActionQueue().unScheduleDeletion(entityEntry, event.getObject());
                return this.entityIsDeleted(event, createCache);
            }
        }
        return CompletionStages.failedFuture((Throwable)new ObjectDeletedException("deleted entity passed to persist", null, EventUtil.getLoggableName((String)event.getEntityName(), (Object)entity)));
    }

    private static EntityState entityState(PersistEvent event, Object entity, String entityName, EntityEntry entityEntry) {
        EntityPersister persister;
        EventSource source = event.getSession();
        EntityState entityState = EntityState.getEntityState((Object)entity, (String)entityName, (EntityEntry)entityEntry, (SessionImplementor)source, (Boolean)true);
        if (entityState == EntityState.DETACHED && (persister = source.getFactory().getMappingMetamodel().getEntityDescriptor(entityName)).getGenerator() instanceof ForeignGenerator) {
            if (LOG.isDebugEnabled() && persister.getIdentifier(entity, (SharedSessionContractImplementor)source) != null) {
                LOG.debug("Resetting entity id attribute to null for foreign generator");
            }
            persister.setIdentifier(entity, null, (SharedSessionContractImplementor)source);
            entityState = EntityState.getEntityState((Object)entity, (String)entityName, (EntityEntry)entityEntry, (SessionImplementor)source, (Boolean)true);
        }
        return entityState;
    }

    private static String entityName(PersistEvent event, Object entity, EntityEntry entityEntry) {
        if (event.getEntityName() != null) {
            return event.getEntityName();
        }
        String entityName = event.getSession().bestGuessEntityName(entity, entityEntry);
        event.setEntityName(entityName);
        return entityName;
    }

    protected CompletionStage<Void> entityIsPersistent(PersistEvent event, PersistContext createCache) {
        LOG.trace("Ignoring persistent instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        return createCache.add(entity) ? this.justCascade(createCache, source, entity, source.getEntityPersister(event.getEntityName(), entity)) : CompletionStages.voidFuture();
    }

    private CompletionStage<Void> justCascade(PersistContext createCache, EventSource source, Object entity, EntityPersister persister) {
        return this.cascadeBeforeSave(source, persister, entity, createCache).thenCompose(v -> this.cascadeAfterSave(source, persister, entity, createCache));
    }

    protected CompletionStage<Void> entityIsTransient(PersistEvent event, PersistContext createCache) {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        return createCache.add(entity) ? this.reactiveSaveWithGeneratedId(entity, event.getEntityName(), createCache, source, false) : CompletionStages.voidFuture();
    }

    private CompletionStage<Void> entityIsDeleted(PersistEvent event, PersistContext createCache) {
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("un-scheduling entity deletion [%s]", MessageHelper.infoString((EntityPersister)persister, (Object)persister.getIdentifier(entity, (SharedSessionContractImplementor)source), (SessionFactoryImplementor)source.getFactory()));
        }
        return createCache.add(entity) ? this.justCascade(createCache, source, entity, persister) : CompletionStages.voidFuture();
    }
}

