/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.CollectionLoaderSubSelectFetch;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoader;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;

public class ReactiveCollectionLoaderSubSelectFetch
extends CollectionLoaderSubSelectFetch
implements ReactiveCollectionLoader {
    private final PluralAttributeMapping attributeMapping;
    private final SubselectFetch subselect;

    public ReactiveCollectionLoaderSubSelectFetch(PluralAttributeMapping attributeMapping, DomainResult cachedDomainResult, SubselectFetch subselect, SharedSessionContractImplementor session) {
        super(attributeMapping, cachedDomainResult, subselect, session);
        this.attributeMapping = attributeMapping;
        this.subselect = subselect;
    }

    @Override
    public CompletionStage<PersistentCollection<?>> reactiveLoad(Object triggerKey, SharedSessionContractImplementor session) {
        EntityKey triggerKeyOwnerKey;
        SubselectFetch registeredFetch;
        CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), triggerKey);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        PersistentCollection collection = persistenceContext.getCollection(collectionKey);
        this.attributeMapping.getCollectionDescriptor().getCollectionType().getKeyOfOwner(collection.getOwner(), session);
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        EntityEntry ownerEntry = persistenceContext.getEntry(collection.getOwner());
        ArrayList subSelectFetchedCollections = null;
        if (ownerEntry != null && (registeredFetch = batchFetchQueue.getSubselect(triggerKeyOwnerKey = ownerEntry.getEntityKey())) != null) {
            subSelectFetchedCollections = CollectionHelper.arrayList((int)registeredFetch.getResultingEntityKeys().size());
            for (EntityKey key : registeredFetch.getResultingEntityKeys()) {
                PersistentCollection containedCollection = persistenceContext.getCollection(new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key.getIdentifier()));
                if (containedCollection == collection) continue;
                containedCollection.beginRead();
                containedCollection.beforeInitialize(this.getLoadable().getCollectionDescriptor(), -1);
                subSelectFetchedCollections.add(containedCollection);
            }
        }
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.getSqlAst()).translate(this.subselect.getLoadingJdbcParameterBindings(), QueryOptions.NONE);
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler((BatchFetchQueue)batchFetchQueue, (SelectStatement)this.getSqlAst(), (JdbcParametersList)this.subselect.getLoadingJdbcParameters(), (JdbcParameterBindings)this.subselect.getLoadingJdbcParameterBindings());
        ArrayList fetchedCollections = subSelectFetchedCollections;
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, this.subselect.getLoadingJdbcParameterBindings(), (ExecutionContext)new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenApply(rs -> {
            if (fetchedCollections != null && !fetchedCollections.isEmpty()) {
                fetchedCollections.forEach(c -> this.initializeSubCollection(persistenceContext, (PersistentCollection<?>)c));
                fetchedCollections.clear();
            }
            return collection;
        });
    }

    private void initializeSubCollection(PersistenceContext persistenceContext, PersistentCollection<?> c) {
        if (!c.wasInitialized()) {
            c.initializeEmptyCollection(this.getLoadable().getCollectionDescriptor());
            ResultsHelper.finalizeCollectionLoading((PersistenceContext)persistenceContext, (CollectionPersister)this.getLoadable().getCollectionDescriptor(), c, (Object)c.getKey(), (boolean)true);
        }
    }
}

