/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.spi.ReactiveSingleUniqueKeyEntityLoader;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class ReactiveSingleUniqueKeyEntityLoaderStandard<T>
implements ReactiveSingleUniqueKeyEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final ModelPart uniqueKeyAttribute;

    public ReactiveSingleUniqueKeyEntityLoaderStandard(EntityMappingType entityDescriptor, SingularAttributeMapping uniqueKeyAttribute) {
        this.entityDescriptor = entityDescriptor;
        this.uniqueKeyAttribute = uniqueKeyAttribute instanceof ToOneAttributeMapping ? ((ToOneAttributeMapping)uniqueKeyAttribute).getForeignKeyDescriptor() : uniqueKeyAttribute;
    }

    private static Object transformRow(Object[] row) {
        return row[0];
    }

    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    public CompletionStage<T> load(Object ukValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcParametersList.Builder jdbcParametersListBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey((Loadable)this.entityDescriptor, Collections.emptyList(), (ModelPart)this.uniqueKeyAttribute, null, (LoadQueryInfluencers)LoadQueryInfluencers.NONE, (LockOptions)LockOptions.NONE, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersListBuilder).add(arg_0), (SessionFactoryImplementor)sessionFactory);
        JdbcParametersList jdbcParameters = jdbcParametersListBuilder.build();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(ukValue, (Bindable)this.uniqueKeyAttribute, jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate((JdbcParameterBindings)jdbcParameterBindings, QueryOptions.NONE);
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new SingleUKEntityLoaderExecutionContext(session, readOnly), ReactiveSingleUniqueKeyEntityLoaderStandard::transformRow, ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenApply(list -> this.singleResult(ukValue, (List<Object>)list));
    }

    private T singleResult(Object ukValue, List<Object> list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)list.get(0);
            }
        }
        throw new HibernateException("More than one row with the given identifier was found: " + ukValue + ", for class: " + this.entityDescriptor.getEntityName());
    }

    @Override
    public Object resolveId(Object ukValue, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcParametersList.Builder jdbcParametersListBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey((Loadable)this.entityDescriptor, Collections.singletonList(this.entityDescriptor.getIdentifierMapping()), (ModelPart)this.uniqueKeyAttribute, null, (LoadQueryInfluencers)LoadQueryInfluencers.NONE, (LockOptions)LockOptions.NONE, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersListBuilder).add(arg_0), (SessionFactoryImplementor)sessionFactory);
        JdbcParametersList jdbcParameters = jdbcParametersListBuilder.build();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(ukValue, (Bindable)this.uniqueKeyAttribute, jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate((JdbcParameterBindings)jdbcParameterBindings, QueryOptions.NONE);
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new NoCallbackExecutionContext(session), row -> row[0], ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenApply(list -> {
            assert (list.size() == 1);
            return list.get(0);
        });
    }

    private static class SingleUKEntityLoaderExecutionContext
    extends BaseExecutionContext {
        private final Callback callback;
        private final QueryOptions queryOptions;

        public SingleUKEntityLoaderExecutionContext(SharedSessionContractImplementor session, Boolean readOnly) {
            super(session);
            this.queryOptions = readOnly == null ? QueryOptions.NONE : (readOnly != false ? QueryOptions.READ_ONLY : QueryOptions.READ_WRITE);
            this.callback = new CallbackImpl();
        }

        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        public Callback getCallback() {
            return this.callback;
        }
    }
}

