/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;

class SingleIdExecutionContext
extends BaseExecutionContext {
    private final Object entityInstance;
    private final Object entityId;
    private final Boolean readOnly;
    private final LockOptions lockOptions;
    private final SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler;

    public SingleIdExecutionContext(Object entityId, Object entityInstance, Boolean readOnly, LockOptions lockOptions, SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler, SharedSessionContractImplementor session) {
        super(session);
        this.entityInstance = entityInstance;
        this.entityId = entityId;
        this.readOnly = readOnly;
        this.lockOptions = lockOptions;
        this.subSelectFetchableKeysHandler = subSelectFetchableKeysHandler;
    }

    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getEntityId() {
        return this.entityId;
    }

    public QueryOptions getQueryOptions() {
        return new QueryOptionsAdapter(){

            public Boolean isReadOnly() {
                return SingleIdExecutionContext.this.readOnly;
            }

            public LockOptions getLockOptions() {
                return SingleIdExecutionContext.this.lockOptions;
            }
        };
    }

    public void registerLoadingEntityEntry(EntityKey entityKey, LoadingEntityEntry entry) {
        this.subSelectFetchableKeysHandler.addKey(entityKey, entry);
    }
}

