/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.mutiny.impl;

import io.smallrye.mutiny.Uni;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.reactive.mutiny.Mutiny;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;
import org.hibernate.reactive.query.ReactiveQuery;

public class MutinySelectionQueryImpl<R>
implements Mutiny.SelectionQuery<R> {
    private final MutinySessionFactoryImpl factory;
    private final ReactiveQuery<R> delegate;

    public MutinySelectionQueryImpl(ReactiveQuery<R> delegate, MutinySessionFactoryImpl factory) {
        this.delegate = delegate;
        this.factory = factory;
    }

    private <T> Uni<T> uni(Supplier<CompletionStage<T>> stageSupplier) {
        return this.factory.uni(stageSupplier);
    }

    @Override
    public int getMaxResults() {
        return this.delegate.getMaxResults();
    }

    @Override
    public Uni<List<R>> getResultList() {
        return this.uni(this.delegate::getReactiveResultList);
    }

    @Override
    public FlushMode getFlushMode() {
        return this.delegate.getHibernateFlushMode();
    }

    @Override
    public Mutiny.SelectionQuery<R> setFlushMode(FlushMode flushMode) {
        this.delegate.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setLockMode(LockMode lockMode) {
        this.delegate.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setPlan(EntityGraph<R> entityGraph) {
        this.delegate.applyGraph((RootGraphImplementor)entityGraph, GraphSemantic.FETCH);
        return this;
    }

    @Override
    public Uni<R> getSingleResult() {
        return this.uni(this.delegate::getReactiveSingleResult);
    }

    @Override
    public Uni<R> getSingleResultOrNull() {
        return this.uni(this.delegate::getReactiveSingleResultOrNull);
    }

    @Override
    public Mutiny.SelectionQuery<R> setFlushMode(FlushModeType flushMode) {
        this.delegate.setFlushMode(flushMode);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public Mutiny.SelectionQuery<R> setReadOnly(boolean readOnly) {
        this.delegate.setReadOnly(readOnly);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setMaxResults(int maxResult) {
        this.delegate.setMaxResults(maxResult);
        return this;
    }

    @Override
    public int getFirstResult() {
        return this.delegate.getFirstResult();
    }

    @Override
    public Mutiny.SelectionQuery<R> setFirstResult(int startPosition) {
        this.delegate.setFirstResult(startPosition);
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.delegate.getCacheStoreMode();
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.delegate.getCacheRetrieveMode();
    }

    @Override
    public Mutiny.SelectionQuery<R> setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this.delegate.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this.delegate.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.delegate.isCacheable();
    }

    @Override
    public Mutiny.SelectionQuery<R> setCacheable(boolean cacheable) {
        this.delegate.setCacheable(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.delegate.getCacheRegion();
    }

    @Override
    public Mutiny.SelectionQuery<R> setCacheRegion(String cacheRegion) {
        this.delegate.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setLockMode(LockModeType lockMode) {
        this.delegate.setLockMode(lockMode);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setLockMode(String alias, LockMode lockMode) {
        this.delegate.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setParameter(String name, Object value) {
        this.delegate.setParameter(name, value);
        return this;
    }

    @Override
    public Mutiny.SelectionQuery<R> setParameter(int position, Object value) {
        this.delegate.setParameter(position, value);
        return this;
    }

    @Override
    public <T1> Mutiny.SelectionQuery<R> setParameter(Parameter<T1> param, T1 value) {
        this.delegate.setParameter((Parameter)param, (Object)value);
        return this;
    }

    @Override
    public String getComment() {
        return this.delegate.getComment();
    }

    @Override
    public Mutiny.SelectionQuery<R> setComment(String comment) {
        this.delegate.setComment(comment);
        return this;
    }
}

