/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoader;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoaderSubSelectFetch;
import org.hibernate.reactive.persister.collection.impl.ReactiveAbstractCollectionPersister;
import org.hibernate.reactive.persister.collection.mutation.ReactiveDeleteRowsCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveDeleteRowsCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveDeleteRowsCoordinatorStandard;
import org.hibernate.reactive.persister.collection.mutation.ReactiveInsertRowsCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveInsertRowsCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveInsertRowsCoordinatorStandard;
import org.hibernate.reactive.persister.collection.mutation.ReactiveRemoveCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveRemoveCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveRemoveCoordinatorStandard;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinatorStandard;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;

public class ReactiveBasicCollectionPersister
extends BasicCollectionPersister
implements ReactiveAbstractCollectionPersister {
    private final ReactiveInsertRowsCoordinator insertRowsCoordinator = this.buildInsertRowCoordinator();
    private final ReactiveUpdateRowsCoordinator updateRowsCoordinator = this.buildUpdateRowCoordinator();
    private final ReactiveDeleteRowsCoordinator deleteRowsCoordinator = this.buildDeleteRowCoordinator();
    private final ReactiveRemoveCoordinator removeCoordinator = this.buildDeleteAllCoordinator();
    private CollectionLoader reusableCollectionLoader;

    public ReactiveBasicCollectionPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        super(collectionBinding, cacheAccessStrategy, creationContext);
    }

    protected CollectionLoader createCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        if (this.isCollectionLoaderReusable(loadQueryInfluencers)) {
            if (this.reusableCollectionLoader == null) {
                this.reusableCollectionLoader = ReactiveAbstractCollectionPersister.super.generateCollectionLoader(LoadQueryInfluencers.NONE);
            }
            return this.reusableCollectionLoader;
        }
        return ReactiveAbstractCollectionPersister.super.generateCollectionLoader(loadQueryInfluencers);
    }

    private ReactiveUpdateRowsCoordinator buildUpdateRowCoordinator() {
        boolean performUpdates;
        boolean bl = performUpdates = this.getCollectionSemantics().getCollectionClassification().isRowUpdatePossible() && ArrayHelper.isAnyTrue((boolean[])this.elementColumnIsSettable) && !this.isInverse();
        if (!performUpdates) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row updates - %s", (Object)this.getRolePath());
            }
            return new ReactiveUpdateRowsCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveUpdateRowsCoordinatorStandard((CollectionMutationTarget)this, this.getRowMutationOperations(), this.getFactory());
    }

    private ReactiveInsertRowsCoordinator buildInsertRowCoordinator() {
        if (this.isInverse() || !this.isRowInsertEnabled()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection inserts - %s", (Object)this.getRolePath());
            }
            return new ReactiveInsertRowsCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveInsertRowsCoordinatorStandard((CollectionMutationTarget)this, this.getRowMutationOperations());
    }

    private ReactiveDeleteRowsCoordinator buildDeleteRowCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row deletions - %s", (Object)this.getRolePath());
            }
            return new ReactiveDeleteRowsCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveDeleteRowsCoordinatorStandard((CollectionMutationTarget)this, this.getRowMutationOperations(), this.hasPhysicalIndexColumn(), (ServiceRegistry)this.getFactory().getServiceRegistry());
    }

    private ReactiveRemoveCoordinator buildDeleteAllCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection removals - %s", (Object)this.getRolePath());
            }
            return new ReactiveRemoveCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveRemoveCoordinatorStandard((CollectionMutationTarget)this, arg_0 -> ((ReactiveBasicCollectionPersister)this).buildDeleteAllOperation(arg_0), (ServiceRegistry)this.getFactory().getServiceRegistry());
    }

    protected CollectionLoader createSubSelectLoader(SubselectFetch subselect, SharedSessionContractImplementor session) {
        return new ReactiveCollectionLoaderSubSelectFetch(this.getAttributeMapping(), null, subselect, session);
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Object key, SharedSessionContractImplementor session) {
        return ((ReactiveCollectionLoader)this.determineLoaderToUse(key, session)).reactiveLoad(key, session).thenCompose(CompletionStages::voidFuture);
    }

    @Override
    public CompletionStage<Void> reactiveRemove(Object id, SharedSessionContractImplementor session) {
        return this.getRemoveCoordinator().reactiveDeleteAllRows(id, session);
    }

    @Override
    public CompletionStage<Void> reactiveRecreate(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        return this.getCreateEntryCoordinator().reactiveInsertRows(collection, id, (arg_0, arg_1, arg_2, arg_3) -> collection.includeInRecreate(arg_0, arg_1, arg_2, arg_3), session);
    }

    @Override
    public CompletionStage<Void> reactiveInsertRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        return this.getCreateEntryCoordinator().reactiveInsertRows(collection, id, (arg_0, arg_1, arg_2, arg_3) -> collection.includeInInsert(arg_0, arg_1, arg_2, arg_3), session);
    }

    @Override
    public CompletionStage<Void> reactiveUpdateRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        return this.getUpdateEntryCoordinator().reactiveUpdateRows(id, collection, session);
    }

    @Override
    public CompletionStage<Void> reactiveDeleteRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        return this.getRemoveEntryCoordinator().reactiveDeleteRows(collection, id, session);
    }

    @Override
    public boolean isRowDeleteEnabled() {
        return super.isRowDeleteEnabled();
    }

    @Override
    public boolean isRowInsertEnabled() {
        return super.isRowInsertEnabled();
    }

    protected ReactiveInsertRowsCoordinator getCreateEntryCoordinator() {
        return this.insertRowsCoordinator;
    }

    protected ReactiveUpdateRowsCoordinator getUpdateEntryCoordinator() {
        return this.updateRowsCoordinator;
    }

    public ReactiveRemoveCoordinator getRemoveCoordinator() {
        return this.removeCoordinator;
    }

    protected ReactiveDeleteRowsCoordinator getRemoveEntryCoordinator() {
        return this.deleteRowsCoordinator;
    }
}

