/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.mutation;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.persister.collection.mutation.RemoveCoordinatorStandard;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.persister.collection.mutation.ReactiveRemoveCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;

public class ReactiveRemoveCoordinatorStandard
extends RemoveCoordinatorStandard
implements ReactiveRemoveCoordinator {
    private final BasicBatchKey batchKey;
    private final OperationProducer operationProducer;
    private MutationOperationGroup operationGroup;

    public ReactiveRemoveCoordinatorStandard(CollectionMutationTarget mutationTarget, OperationProducer operationProducer, ServiceRegistry serviceRegistry) {
        super(mutationTarget, operationProducer, serviceRegistry);
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#REMOVE");
        this.operationProducer = operationProducer;
    }

    private BasicBatchKey getBatchKey() {
        return this.batchKey;
    }

    @Override
    public CompletionStage<Void> reactiveDeleteAllRows(Object key, SharedSessionContractImplementor session) {
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Deleting collection - %s : %s", (Object)this.getMutationTarget().getRolePath(), key);
        }
        if (this.operationGroup == null) {
            this.operationGroup = this.buildOperationGroup();
        }
        ReactiveMutationExecutor mutationExecutor = this.reactiveMutationExecutor(session, this.operationGroup);
        return CompletionStages.voidFuture().thenCompose(unused -> {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            ForeignKeyDescriptor fkDescriptor = this.getMutationTarget().getTargetPart().getKeyDescriptor();
            fkDescriptor.getKeyPart().decompose(key, 0, (Object)jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
            return mutationExecutor.executeReactive(key, null, null, null, session);
        }).whenComplete((o, throwable) -> mutationExecutor.release()).thenCompose(CompletionStages::voidFuture);
    }

    private ReactiveMutationExecutor reactiveMutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(this::getBatchKey, operationGroup, session);
    }

    private MutationOperationGroup buildOperationGroup() {
        assert (this.getMutationTarget().getTargetPart() != null);
        assert (this.getMutationTarget().getTargetPart().getKeyDescriptor() != null);
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Starting RemoveCoordinator#buildOperationGroup - %s", (Object)this.getMutationTarget().getRolePath());
        }
        CollectionTableMapping tableMapping = this.getMutationTarget().getCollectionTableMapping();
        MutatingTableReference tableReference = new MutatingTableReference((TableMapping)tableMapping);
        return MutationOperationGroupFactory.singleOperation((MutationType)MutationType.DELETE, (MutationTarget)this.getMutationTarget(), (MutationOperation)this.operationProducer.createOperation(tableReference));
    }
}

