/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import jakarta.persistence.metamodel.Attribute;
import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeDescriptor;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributesMetadata;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.loader.ast.internal.ReactiveSingleIdArrayLoadPlan;
import org.hibernate.reactive.loader.ast.spi.ReactiveSingleIdEntityLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.metamodel.mapping.internal.ReactiveCompoundNaturalIdMapping;
import org.hibernate.reactive.metamodel.mapping.internal.ReactiveSimpleNaturalIdMapping;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.session.impl.ReactiveQueryExecutorLookup;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Update;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;

public interface ReactiveAbstractEntityPersister
extends ReactiveEntityPersister,
OuterJoinLoadable,
Lockable {
    public static final Log LOG;

    default public Parameters parameters() {
        return Parameters.instance(this.getFactory().getJdbcServices().getDialect());
    }

    default public AbstractEntityPersister delegate() {
        return (AbstractEntityPersister)this;
    }

    default public ReactiveConnection getReactiveConnection(SharedSessionContractImplementor session) {
        return ReactiveQueryExecutorLookup.extract(session).getReactiveConnection();
    }

    public boolean check(int var1, Object var2, int var3, Expectation var4, PreparedStatement var5, String var6) throws HibernateException;

    default public String generateSelectLockString(LockOptions lockOptions) {
        SessionFactoryImplementor factory = this.getFactory();
        SimpleSelect select = new SimpleSelect(factory).setLockOptions(lockOptions).setTableName(this.getRootTableName()).addColumn(this.getRootTableIdentifierColumnNames()[0]).addRestriction(this.getRootTableIdentifierColumnNames());
        if (this.isVersioned()) {
            select.addRestriction(this.getVersionColumnName());
        }
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            select.setComment(lockOptions.getLockMode() + " lock " + this.getEntityName());
        }
        return this.parameters().process(select.toStatementString());
    }

    default public String generateUpdateLockString(LockOptions lockOptions) {
        SessionFactoryImplementor factory = this.getFactory();
        Update update = new Update(factory);
        update.setTableName(this.getRootTableName());
        update.addAssignment(this.getVersionColumnName());
        update.addRestriction(this.getRootTableIdentifierColumnNames());
        update.addRestriction(this.getVersionColumnName());
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            update.setComment(lockOptions.getLockMode() + " lock " + this.getEntityName());
        }
        return this.parameters().process(update.toStatementString());
    }

    @Override
    default public CompletionStage<Void> reactiveLock(Object id, Object version, Object object, LockOptions lockOptions, SharedSessionContractImplementor session) throws HibernateException {
        boolean writeLock;
        String sql;
        LockMode lockMode = lockOptions.getLockMode();
        Object nextVersion = this.nextVersionForLock(lockMode, id, version, object, session);
        switch (lockMode) {
            case NONE: {
                return CompletionStages.voidFuture();
            }
            case PESSIMISTIC_READ: 
            case PESSIMISTIC_WRITE: 
            case UPGRADE_NOWAIT: 
            case UPGRADE_SKIPLOCKED: {
                sql = this.generateSelectLockString(lockOptions);
                writeLock = false;
                break;
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                sql = this.generateUpdateLockString(lockOptions);
                writeLock = true;
                break;
            }
            case OPTIMISTIC: 
            case OPTIMISTIC_FORCE_INCREMENT: {
                throw new AssertionFailure("optimistic lock mode is not supported here");
            }
            case READ: 
            case WRITE: {
                throw new AssertionFailure("implicit lock mode is not supported here");
            }
            default: {
                throw new AssertionFailure("illegal lock mode");
            }
        }
        Object[] arguments = PreparedStatementAdaptor.bind(statement -> {
            int offset = 1;
            if (writeLock) {
                this.getVersionType().nullSafeSet(statement, nextVersion, offset, session);
                ++offset;
            }
            this.getIdentifierType().nullSafeSet(statement, id, offset, session);
            offset += this.getIdentifierType().getColumnSpan((Mapping)this.getFactory());
            if (this.isVersioned()) {
                this.getVersionType().nullSafeSet(statement, version, offset, session);
            }
        });
        return this.writeLock(session, sql, writeLock, arguments).thenAccept(rowExisted -> {
            if (!rowExisted.booleanValue()) {
                throw new StaleObjectStateException(this.getEntityName(), id);
            }
        }).whenComplete((r, e) -> CompletionStages.logSqlException(e, () -> "could not lock: " + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()), sql));
    }

    private CompletionStage<Boolean> writeLock(SharedSessionContractImplementor session, String sql, boolean writeLock, Object[] arguments) {
        return writeLock ? this.getReactiveConnection(session).update(sql, arguments).thenApply(affected -> affected > 0) : this.getReactiveConnection(session).select(sql, arguments).thenApply(Iterator::hasNext);
    }

    public BasicType<?> getVersionType();

    default public Object nextVersionForLock(LockMode lockMode, Object id, Object currentVersion, Object entity, SharedSessionContractImplementor session) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            if (!this.isVersioned()) {
                throw new AssertionFailure("cannot force version increment on non-versioned entity");
            }
            EntityVersionMapping versionMapping = this.getVersionMapping();
            BasicType<?> versionType = this.getVersionType();
            Object nextVersion = this.getVersionJavaType().next(currentVersion, versionMapping.getLength(), versionMapping.getPrecision(), versionMapping.getScale(), session);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Forcing version increment [" + MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()) + "; " + versionType.toLoggableString(currentVersion, this.getFactory()) + " -> " + versionType.toLoggableString(nextVersion, this.getFactory()) + "]");
            }
            session.getPersistenceContextInternal().getEntry(entity).forceLocked(entity, nextVersion);
            return nextVersion;
        }
        return currentVersion;
    }

    @Override
    default public CompletionStage<Object[]> reactiveGetDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        return this.getReactiveSingleIdEntityLoader().reactiveLoadDatabaseSnapshot(id, session);
    }

    public ReactiveSingleIdEntityLoader<?> getReactiveSingleIdEntityLoader();

    @Override
    default public CompletionStage<Object> reactiveGetCurrentVersion(Object id, SharedSessionContractImplementor session) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Getting version: {0}", MessageHelper.infoString((EntityPersister)this, (Object)id, (SessionFactoryImplementor)this.getFactory()));
        }
        Object[] params = PreparedStatementAdaptor.bind(statement -> this.getIdentifierType().nullSafeSet(statement, id, 1, session));
        return this.getReactiveConnection(session).selectJdbc(this.delegate().getVersionSelectString(), params).thenCompose(resultSet -> this.currentVersion(session, (ResultSet)resultSet));
    }

    private CompletionStage<Object> currentVersion(SharedSessionContractImplementor session, ResultSet resultSet) {
        try {
            if (!resultSet.next()) {
                return CompletionStages.nullFuture();
            }
            if (!this.isVersioned()) {
                return CompletionStages.completedFuture(this);
            }
            return CompletionStages.completedFuture(this.getVersionType().getJdbcMapping().getJdbcValueExtractor().extract(resultSet, 1, (WrapperOptions)session));
        }
        catch (SQLException sqle) {
            return CompletionStages.failedFuture((Throwable)new JDBCException("error reading version", sqle));
        }
    }

    @Override
    default public <E, T> CompletionStage<T> reactiveInitializeLazyProperty(Attribute<E, T> field, E entity, SharedSessionContractImplementor session) {
        return this.reactiveInitializeLazyProperty(field.getName(), entity, session);
    }

    @Override
    default public <E, T> CompletionStage<T> reactiveInitializeLazyProperty(String field, E entity, SharedSessionContractImplementor session) {
        Object result = this.initializeLazyProperty(field, entity, session);
        if (result instanceof CompletionStage) {
            return (CompletionStage)result;
        }
        if (result instanceof PersistentCollection) {
            PersistentCollection collection;
            String[] propertyNames = this.getPropertyNames();
            for (int index = 0; index < propertyNames.length; ++index) {
                if (!propertyNames[index].equals(field)) continue;
                this.setPropertyValue(entity, index, result);
                break;
            }
            return (collection = (PersistentCollection)result).wasInitialized() ? CompletionStages.completedFuture(collection) : ((ReactiveSession)session).reactiveInitializeCollection(collection, false).thenApply(v -> result);
        }
        return CompletionStages.completedFuture(result);
    }

    default public CompletionStage<Object> reactiveInitializeLazyPropertiesFromDatastore(Object entity, Object id, EntityEntry entry, String fieldName, SharedSessionContractImplementor session) {
        if (!this.hasLazyProperties()) {
            throw new AssertionFailure("no lazy properties");
        }
        PersistentAttributeInterceptor interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)entity).$$_hibernate_getInterceptor();
        if (interceptor == null) {
            throw new AssertionFailure("Expecting bytecode interceptor to be non-null");
        }
        LOG.tracef("Initializing lazy properties from datastore (triggered for `%s`)", fieldName);
        String fetchGroup = this.getEntityMetamodel().getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getFetchGroupName(fieldName);
        List fetchGroupAttributeDescriptors = this.getEntityMetamodel().getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getFetchGroupAttributeDescriptors(fetchGroup);
        Set initializedLazyAttributeNames = interceptor.getInitializedLazyAttributeNames();
        Object[] arguments = PreparedStatementAdaptor.bind(statement -> this.getIdentifierType().nullSafeSet(statement, id, 1, session));
        return ((CompletionStage)this.reactiveGetSQLLazySelectLoadPlan(fetchGroup).load(id, session)).thenCompose(values -> this.initLazyProperty(fieldName, entity, session, entry, interceptor, fetchGroupAttributeDescriptors, initializedLazyAttributeNames, (Object[])values));
    }

    default public CompletionStage<Object> initLazyProperty(String fieldName, Object entity, SharedSessionContractImplementor session, EntityEntry entry, PersistentAttributeInterceptor interceptor, List<LazyAttributeDescriptor> fetchGroupAttributeDescriptors, Set<String> initializedLazyAttributeNames, Object[] values) {
        CompletionStage<Object> resultStage = CompletionStages.nullFuture();
        int i = 0;
        for (LazyAttributeDescriptor fetchGroupAttributeDescriptor : fetchGroupAttributeDescriptors) {
            Object selectedValue;
            if (initializedLazyAttributeNames.contains(fetchGroupAttributeDescriptor.getName())) {
                if (!fetchGroupAttributeDescriptor.getName().equals(fieldName)) continue;
                resultStage = CompletionStages.completedFuture(entry.getLoadedValue(fetchGroupAttributeDescriptor.getName()));
                continue;
            }
            if ((selectedValue = values[i++]) instanceof CompletionStage) {
                CompletionStage selectedValueStage = (CompletionStage)selectedValue;
                resultStage = resultStage.thenCompose(result -> selectedValueStage.thenApply(selected -> {
                    boolean set = this.initializeLazyProperty(fieldName, entity, entry, fetchGroupAttributeDescriptor.getLazyIndex(), selected);
                    if (set) {
                        interceptor.attributeInitialized(fetchGroupAttributeDescriptor.getName());
                        return selected;
                    }
                    return result;
                }));
                continue;
            }
            boolean set = this.initializeLazyProperty(fieldName, entity, entry, fetchGroupAttributeDescriptor.getLazyIndex(), selectedValue);
            if (!set) continue;
            resultStage = CompletionStages.completedFuture(selectedValue);
            interceptor.attributeInitialized(fetchGroupAttributeDescriptor.getName());
        }
        return resultStage.thenApply(result -> {
            LOG.trace("Done initializing lazy properties");
            return result;
        });
    }

    @Override
    default public CompletionStage<Object> reactiveInitializeEnhancedEntityUsedAsProxy(Object entity, String nameOfAttributeBeingAccessed, SharedSessionContractImplementor session) {
        BytecodeEnhancementMetadata enhancementMetadata = this.getEntityMetamodel().getBytecodeEnhancementMetadata();
        BytecodeLazyAttributeInterceptor currentInterceptor = enhancementMetadata.extractLazyInterceptor(entity);
        if (currentInterceptor instanceof EnhancementAsProxyLazinessInterceptor) {
            EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)currentInterceptor;
            EntityKey entityKey = proxyInterceptor.getEntityKey();
            Object identifier = entityKey.getIdentifier();
            return this.loadFromDatabaseOrCache(entity, session, entityKey, identifier).thenApply(loaded -> {
                LazyAttributeLoadingInterceptor interceptor;
                if (loaded == null) {
                    PersistenceContext persistenceContext = session.getPersistenceContext();
                    persistenceContext.removeEntry(entity);
                    persistenceContext.removeEntity(entityKey);
                    session.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityKey.getEntityName(), identifier);
                }
                if (nameOfAttributeBeingAccessed == null) {
                    return null;
                }
                return interceptor.readObject(entity, nameOfAttributeBeingAccessed, (interceptor = enhancementMetadata.injectInterceptor(entity, identifier, session)).isAttributeLoaded(nameOfAttributeBeingAccessed) ? this.getPropertyValue(entity, nameOfAttributeBeingAccessed) : ((LazyPropertyInitializer)this).initializeLazyProperty(nameOfAttributeBeingAccessed, entity, session));
            });
        }
        throw new IllegalStateException();
    }

    private CompletionStage<?> loadFromDatabaseOrCache(Object entity, SharedSessionContractImplementor session, EntityKey entityKey, Object identifier) {
        Object cached;
        if (session instanceof EventSource && this.canReadFromCache() && (cached = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(new LoadEvent(identifier, entity, (EventSource)session, Boolean.valueOf(false)), (EntityPersister)this, entityKey)) != null) {
            return CompletionStages.completedFuture(cached);
        }
        return (CompletionStage)this.getReactiveSingleIdEntityLoader().load(identifier, entity, LockOptions.NONE, session);
    }

    public boolean initializeLazyProperty(String var1, Object var2, EntityEntry var3, int var4, Object var5);

    public Object initializeLazyProperty(String var1, Object var2, SharedSessionContractImplementor var3);

    public String[][] getLazyPropertyColumnAliases();

    public ReactiveSingleIdArrayLoadPlan reactiveGetSQLLazySelectLoadPlan(String var1);

    public boolean isBatchable();

    default public NaturalIdMapping generateNaturalIdMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        if (!2.$assertionsDisabled && !bootEntityDescriptor.hasNaturalId()) {
            throw new AssertionError();
        }
        int[] naturalIdAttributeIndexes = this.getEntityMetamodel().getNaturalIdentifierProperties();
        if (!2.$assertionsDisabled && naturalIdAttributeIndexes.length <= 0) {
            throw new AssertionError();
        }
        if (naturalIdAttributeIndexes.length == 1) {
            String propertyName = this.getEntityMetamodel().getPropertyNames()[naturalIdAttributeIndexes[0]];
            AttributeMapping attributeMapping = this.findAttributeMapping(propertyName);
            SingularAttributeMapping singularAttributeMapping = (SingularAttributeMapping)attributeMapping;
            return new ReactiveSimpleNaturalIdMapping(singularAttributeMapping, (EntityMappingType)this, creationProcess);
        }
        HashSet attributeNames = CollectionHelper.setOfSize((int)naturalIdAttributeIndexes.length);
        for (int naturalIdAttributeIndex : naturalIdAttributeIndexes) {
            attributeNames.add(this.getPropertyNames()[naturalIdAttributeIndex]);
        }
        ArrayList<SingularAttributeMapping> collectedAttrMappings = new ArrayList<SingularAttributeMapping>();
        AttributeMappingsList attributeMappings = this.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = attributeMappings.get(i);
            if (!attributeNames.contains(attributeMapping.getAttributeName())) continue;
            collectedAttrMappings.add((SingularAttributeMapping)attributeMapping);
        }
        if (collectedAttrMappings.size() <= 1) {
            throw new MappingException("Expected multiple natural-id attributes, but found only one: " + this.getEntityName());
        }
        return new ReactiveCompoundNaturalIdMapping((EntityMappingType)this, collectedAttrMappings, creationProcess);
    }

    default public NaturalIdLoader<?> getNaturalIdLoader() {
        return this.getNaturalIdMapping().makeLoader((EntityMappingType)this);
    }

    default public Map<String, ReactiveSingleIdArrayLoadPlan> getLazyLoadPlanByFetchGroup(String[] subclassPropertyNameClosure) {
        BytecodeEnhancementMetadata metadata = this.delegate().getEntityMetamodel().getBytecodeEnhancementMetadata();
        return metadata.isEnhancedForLazyLoading() && metadata.getLazyAttributesMetadata().hasLazyAttributes() ? this.createLazyLoadPlanByFetchGroup(metadata, subclassPropertyNameClosure) : Collections.emptyMap();
    }

    default public Map<String, ReactiveSingleIdArrayLoadPlan> createLazyLoadPlanByFetchGroup(BytecodeEnhancementMetadata metadata, String[] subclassPropertyNameClosure) {
        HashMap<String, ReactiveSingleIdArrayLoadPlan> result = new HashMap<String, ReactiveSingleIdArrayLoadPlan>();
        LazyAttributesMetadata attributesMetadata = metadata.getLazyAttributesMetadata();
        for (String groupName : attributesMetadata.getFetchGroupNames()) {
            ReactiveSingleIdArrayLoadPlan loadPlan = this.createLazyLoadPlan(attributesMetadata.getFetchGroupAttributeDescriptors(groupName), subclassPropertyNameClosure);
            if (loadPlan == null) continue;
            result.put(groupName, loadPlan);
        }
        return result;
    }

    default public ReactiveSingleIdArrayLoadPlan createLazyLoadPlan(List<LazyAttributeDescriptor> fetchGroupAttributeDescriptors, String[] subclassPropertyNameClosure) {
        ArrayList<AttributeMapping> partsToSelect = new ArrayList<AttributeMapping>(fetchGroupAttributeDescriptors.size());
        for (LazyAttributeDescriptor lazyAttributeDescriptor : fetchGroupAttributeDescriptors) {
            partsToSelect.add(this.getAttributeMapping(this.getSubclassPropertyIndex(lazyAttributeDescriptor.getName(), subclassPropertyNameClosure)));
        }
        if (partsToSelect.isEmpty()) {
            return null;
        }
        SessionFactoryImplementor factory = this.getFactory();
        JdbcParametersList.Builder jdbcParametersListBuilder = JdbcParametersList.newBuilder();
        SelectStatement select = LoaderSelectBuilder.createSelect((Loadable)this, partsToSelect, (ModelPart)this.getIdentifierMapping(), null, (int)1, (LoadQueryInfluencers)LoadQueryInfluencers.NONE, (LockOptions)LockOptions.NONE, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersListBuilder).add(arg_0), (SessionFactoryImplementor)factory);
        JdbcParametersList jdbcParameters = jdbcParametersListBuilder.build();
        return new ReactiveSingleIdArrayLoadPlan((ModelPart)this.getIdentifierMapping(), select, jdbcParameters, LockOptions.NONE, factory);
    }

    default public int getSubclassPropertyIndex(String propertyName, String[] subclassPropertyNameClosure) {
        return ArrayHelper.indexOf((Object[])subclassPropertyNameClosure, (Object)propertyName);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    }
}

