/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.reactive.persister.entity.impl.ReactiveUpdateCoordinatorStandardScopeFactory;
import org.hibernate.reactive.persister.entity.mutation.ReactiveDeleteCoordinator;
import org.hibernate.reactive.persister.entity.mutation.ReactiveInsertCoordinator;
import org.hibernate.reactive.persister.entity.mutation.ReactiveUpdateCoordinator;
import org.hibernate.reactive.persister.entity.mutation.ReactiveUpdateCoordinatorNoOp;

public final class ReactiveCoordinatorFactory {
    public static ReactiveInsertCoordinator buildInsertCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        return new ReactiveInsertCoordinator(entityPersister, factory);
    }

    public static ReactiveUpdateCoordinator buildUpdateCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        AttributeMappingsList attributeMappings = entityPersister.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = attributeMappings.get(i);
            if (!(attributeMapping instanceof SingularAttributeMapping)) continue;
            return new ReactiveUpdateCoordinatorStandardScopeFactory(entityPersister, factory);
        }
        return new ReactiveUpdateCoordinatorNoOp(entityPersister);
    }

    public static ReactiveDeleteCoordinator buildDeleteCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        return new ReactiveDeleteCoordinator(entityPersister, factory);
    }
}

