/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import jakarta.persistence.metamodel.Attribute;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.bytecode.BytecodeLogging;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.persister.entity.EntityPersister;

public interface ReactiveEntityPersister
extends EntityPersister {
    public CompletionStage<Void> insertReactive(Object var1, Object[] var2, Object var3, SharedSessionContractImplementor var4);

    public CompletionStage<Object> insertReactive(Object[] var1, Object var2, SharedSessionContractImplementor var3);

    public CompletionStage<Void> deleteReactive(Object var1, Object var2, Object var3, SharedSessionContractImplementor var4);

    public CompletionStage<Void> updateReactive(Object var1, Object[] var2, int[] var3, boolean var4, Object[] var5, Object var6, Object var7, Object var8, SharedSessionContractImplementor var9);

    public CompletionStage<Void> reactiveLock(Object var1, Object var2, Object var3, LockOptions var4, SharedSessionContractImplementor var5);

    public <K> CompletionStage<? extends List<?>> reactiveMultiLoad(K[] var1, EventSource var2, MultiIdLoadOptions var3);

    public CompletionStage<Object> reactiveLoad(Object var1, Object var2, LockMode var3, SharedSessionContractImplementor var4);

    public CompletionStage<Object> reactiveLoad(Object var1, Object var2, LockOptions var3, SharedSessionContractImplementor var4);

    public CompletionStage<Object> reactiveLoad(Object var1, Object var2, LockOptions var3, SharedSessionContractImplementor var4, Boolean var5);

    public CompletionStage<Object> reactiveLoadByUniqueKey(String var1, Object var2, SharedSessionContractImplementor var3);

    public CompletionStage<Object> reactiveLoadByUniqueKey(String var1, Object var2, Boolean var3, SharedSessionContractImplementor var4);

    public CompletionStage<Object> reactiveLoadEntityIdByNaturalId(Object[] var1, LockOptions var2, SharedSessionContractImplementor var3);

    public CompletionStage<Object> reactiveGetCurrentVersion(Object var1, SharedSessionContractImplementor var2);

    public CompletionStage<Void> reactiveProcessInsertGenerated(Object var1, Object var2, Object[] var3, SharedSessionContractImplementor var4);

    public CompletionStage<Void> reactiveProcessUpdateGenerated(Object var1, Object var2, Object[] var3, SharedSessionContractImplementor var4);

    public CompletionStage<Object[]> reactiveGetDatabaseSnapshot(Object var1, SharedSessionContractImplementor var2);

    public <E, T> CompletionStage<T> reactiveInitializeLazyProperty(Attribute<E, T> var1, E var2, SharedSessionContractImplementor var3);

    public <E, T> CompletionStage<T> reactiveInitializeLazyProperty(String var1, E var2, SharedSessionContractImplementor var3);

    public CompletionStage<Object> reactiveInitializeEnhancedEntityUsedAsProxy(Object var1, String var2, SharedSessionContractImplementor var3);

    public static CompletionStage<Object> forceInitialize(Object target, String attributeName, Object entityId, String entityName, SharedSessionContractImplementor session) {
        BytecodeLogging.LOGGER.tracef("EnhancementAsProxyLazinessInterceptor#forceInitialize : %s#%s -> %s )", (Object)entityName, entityId, (Object)attributeName);
        ReactiveEntityPersister persister = (ReactiveEntityPersister)session.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
        return persister.reactiveInitializeEnhancedEntityUsedAsProxy(target, attributeName, session);
    }
}

