/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

class ReactiveGeneratedValuesProcessor {
    private final SelectStatement selectStatement;
    private final List<AttributeMapping> generatedValuesToSelect;
    private final JdbcParametersList jdbcParameters;
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;

    ReactiveGeneratedValuesProcessor(SelectStatement selectStatement, List<AttributeMapping> generatedValuesToSelect, JdbcParametersList jdbcParameters, EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.selectStatement = selectStatement;
        this.generatedValuesToSelect = generatedValuesToSelect;
        this.jdbcParameters = jdbcParameters;
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
    }

    CompletionStage<Void> processGeneratedValues(Object id, Object entity, Object[] state, SharedSessionContractImplementor session) {
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindings jdbcParameterBindings = this.getJdbcParameterBindings(id, session);
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(this.sessionFactory, this.selectStatement).translate(jdbcParameterBindings, QueryOptions.NONE);
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, jdbcParameterBindings, (ExecutionContext)new NoCallbackExecutionContext(session), r -> r, ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenAccept(l -> {
            assert (l.size() == 1);
            this.setEntityAttributes(entity, state, (Object[])l.get(0));
        });
    }

    private JdbcParameterBindings getJdbcParameterBindings(Object id, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, (Bindable)this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        return jdbcParamBindings;
    }

    private void setEntityAttributes(Object entity, Object[] state, Object[] selectionResults) {
        for (int i = 0; i < this.generatedValuesToSelect.size(); ++i) {
            Object generatedValue;
            AttributeMapping attribute = this.generatedValuesToSelect.get(i);
            state[attribute.getStateArrayPosition()] = generatedValue = selectionResults[i];
            attribute.getAttributeMetadata().getPropertyAccess().getSetter().set(entity, generatedValue);
        }
    }
}

