/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.mutation;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.DeleteCoordinator;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;

public class ReactiveDeleteCoordinator
extends DeleteCoordinator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private CompletionStage<Void> stage;

    public ReactiveDeleteCoordinator(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
    }

    public void coordinateDelete(Object entity, Object id, Object version, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("coordinateReactiveDelete");
    }

    public CompletionStage<Void> coordinateReactiveDelete(Object entity, Object id, Object version, SharedSessionContractImplementor session) {
        try {
            super.coordinateDelete(entity, id, version, session);
            return this.stage != null ? this.stage : CompletionStages.voidFuture();
        }
        catch (Throwable t) {
            if (this.stage == null) {
                return CompletionStages.failedFuture(t);
            }
            this.stage.toCompletableFuture().completeExceptionally(t);
            return this.stage;
        }
    }

    protected void doDynamicDelete(Object entity, Object id, Object rowId, Object[] loadedState, SharedSessionContractImplementor session) {
        this.stage = new CompletableFuture<Void>();
        MutationOperationGroup operationGroup = this.generateOperationGroup(loadedState, true, session);
        ReactiveMutationExecutor mutationExecutor = this.mutationExecutor(session, operationGroup);
        operationGroup.forEachOperation((position, mutation) -> {
            if (mutation != null) {
                String tableName = mutation.getTableDetails().getTableName();
                mutationExecutor.getPreparedStatementDetails(tableName);
            }
        });
        this.applyLocking(null, loadedState, mutationExecutor, session);
        this.applyId(id, null, mutationExecutor, this.getStaticDeleteGroup(), session);
        mutationExecutor.executeReactive(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck((PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)batchPosition, (MutationTarget)this.entityPersister(), (Object)id, (SessionFactoryImplementor)this.factory()), session).whenComplete((o, t) -> mutationExecutor.release()).whenComplete(this::complete);
    }

    protected void applyId(Object id, Object rowId, MutationExecutor mutationExecutor, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        EntityRowIdMapping rowIdMapping = this.entityPersister().getRowIdMapping();
        operationGroup.forEachOperation((position, jdbcMutation) -> {
            EntityTableMapping tableDetails = (EntityTableMapping)jdbcMutation.getTableDetails();
            ReactiveDeleteCoordinator.breakDownIdJdbcValues(id, rowId, session, jdbcValueBindings, rowIdMapping, tableDetails);
            PreparedStatementDetails statementDetails = mutationExecutor.getPreparedStatementDetails(tableDetails.getTableName());
            if (statementDetails != null) {
                PreparedStatementAdaptor.bind(statement -> {
                    PrepareStatementDetailsAdaptor detailsAdaptor = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
                    detailsAdaptor.resolveStatement();
                });
            }
        });
    }

    protected void doStaticDelete(Object entity, Object id, Object[] loadedState, Object version, SharedSessionContractImplementor session) {
        this.stage = new CompletableFuture<Void>();
        boolean applyVersion = entity != null;
        MutationOperationGroup operationGroupToUse = entity == null ? this.resolveNoVersionDeleteGroup(session) : this.getStaticDeleteGroup();
        ReactiveMutationExecutor mutationExecutor = this.mutationExecutor(session, operationGroupToUse);
        this.getStaticDeleteGroup().forEachOperation((position, mutation) -> {
            if (mutation != null) {
                mutationExecutor.getPreparedStatementDetails(mutation.getTableDetails().getTableName());
            }
        });
        if (applyVersion) {
            this.applyLocking(version, null, mutationExecutor, session);
        }
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        this.bindPartitionColumnValueBindings(loadedState, session, jdbcValueBindings);
        this.applyId(id, null, mutationExecutor, this.getStaticDeleteGroup(), session);
        mutationExecutor.executeReactive(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck((PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)batchPosition, (MutationTarget)this.entityPersister(), (Object)id, (SessionFactoryImplementor)this.factory()), session).thenAccept(v -> mutationExecutor.release()).whenComplete(this::complete);
    }

    private static void breakDownIdJdbcValues(Object id, Object rowId, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityRowIdMapping rowIdMapping, EntityTableMapping tableDetails) {
        if (rowId != null && rowIdMapping != null && tableDetails.isIdentifierTable()) {
            jdbcValueBindings.bindValue(rowId, tableDetails.getTableName(), rowIdMapping.getRowIdName(), ParameterUsage.RESTRICT);
        } else {
            tableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> jdbcValueBindings.bindValue(jdbcValue, tableDetails.getTableName(), columnMapping.getColumnName(), ParameterUsage.RESTRICT), session);
        }
    }

    private void complete(Object o, Throwable throwable) {
        if (throwable != null) {
            this.stage.toCompletableFuture().completeExceptionally(throwable);
        } else {
            this.stage.toCompletableFuture().complete(null);
        }
    }

    private ReactiveMutationExecutor mutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(() -> ((ReactiveDeleteCoordinator)this).getBatchKey(), operationGroup, session);
    }
}

