/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.impl.DefaultSqlClientPoolConfiguration;
import org.hibernate.reactive.pool.impl.SqlClientPoolConfiguration;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class SqlClientPoolConfigurationInitiator
implements StandardServiceInitiator<SqlClientPoolConfiguration> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    public static final SqlClientPoolConfigurationInitiator INSTANCE = new SqlClientPoolConfigurationInitiator();

    public SqlClientPoolConfiguration initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        String configClassName = (String)configurationValues.get("hibernate.vertx.pool.configuration_class");
        if (configClassName == null) {
            return new DefaultSqlClientPoolConfiguration();
        }
        LOG.sqlClientConfiguration(configClassName);
        ClassLoaderService classLoaderService = (ClassLoaderService)registry.getService(ClassLoaderService.class);
        try {
            return (SqlClientPoolConfiguration)classLoaderService.classForName(configClassName).newInstance();
        }
        catch (Exception e) {
            throw LOG.couldNotInstantiatePoolConfiguration(configClassName, e);
        }
    }

    public Class<SqlClientPoolConfiguration> getServiceInitiated() {
        return SqlClientPoolConfiguration.class;
    }
}

