/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.impl;

import io.vertx.core.json.JsonObject;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.provider.impl.ReactiveModeCheck;
import org.hibernate.reactive.type.descriptor.jdbc.ReactiveArrayJdbcType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsJdbcTimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ReactiveTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        if (ReactiveModeCheck.isReactiveRegistry(serviceRegistry)) {
            this.registerReactiveChanges(typeContributions, serviceRegistry);
        }
    }

    private void registerReactiveChanges(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        Dialect dialect = this.dialect(serviceRegistry);
        TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(2000, (DdlType)new JavaObjectDdlType());
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        javaTypeRegistry.addDescriptor((JavaType)JsonObjectJavaType.INSTANCE);
        JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor((JdbcType)ReactiveArrayJdbcType.INSTANCE);
        if (dialect instanceof MySQLDialect || dialect instanceof DB2Dialect || dialect instanceof OracleDialect) {
            jdbcTypeRegistry.addDescriptor((JdbcType)TimestampAsLocalDateTimeJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor((JdbcType)TimestampUtcAsLocalDateTimeJdbcType.INSTANCE);
        }
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        basicTypeRegistry.register((BasicType)new JsonType(dialect));
        basicTypeRegistry.register((BasicType)new BlobType(dialect));
        basicTypeRegistry.register((BasicType)new ClobType(dialect));
    }

    private Dialect dialect(ServiceRegistry serviceRegistry) {
        return ((JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class)).getDialect();
    }

    private static class ReactiveBlobJdbcType
    implements JdbcType {
        private JdbcType delegate = BlobJdbcType.DEFAULT;
        private final int defaultSqlTypeCode;

        public ReactiveBlobJdbcType(Dialect dialect) {
            this.defaultSqlTypeCode = dialect instanceof PostgreSQLDialect ? -1 : 2004;
        }

        public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
            return this.delegate.getPreferredJavaTypeClass(options);
        }

        public int getJdbcTypeCode() {
            return this.delegate.getJdbcTypeCode();
        }

        public int getDefaultSqlTypeCode() {
            return this.defaultSqlTypeCode;
        }

        public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
            return this.delegate.getBinder(javaType);
        }

        public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
            return this.delegate.getExtractor(javaType);
        }
    }

    private static class BlobType
    extends AbstractSingleColumnStandardBasicType<byte[]> {
        public BlobType(Dialect dialect) {
            super((JdbcType)new ReactiveBlobJdbcType(dialect), (JavaType)PrimitiveByteArrayJavaType.INSTANCE);
        }

        public String getName() {
            return "materialized_blob";
        }
    }

    private static class ReactiveClobJdbcType
    implements JdbcType {
        private JdbcType delegate = ClobJdbcType.DEFAULT;
        private final int defaultSqlTypeCode;

        public ReactiveClobJdbcType(Dialect dialect) {
            this.defaultSqlTypeCode = dialect instanceof PostgreSQLDialect || dialect instanceof CockroachDialect ? -1 : 2005;
        }

        public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
            return this.delegate.getPreferredJavaTypeClass(options);
        }

        public int getJdbcTypeCode() {
            return this.delegate.getJdbcTypeCode();
        }

        public int getDefaultSqlTypeCode() {
            return this.defaultSqlTypeCode;
        }

        public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
            return this.delegate.getBinder(javaType);
        }

        public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
            return this.delegate.getExtractor(javaType);
        }
    }

    private static class ClobType
    extends AbstractSingleColumnStandardBasicType<String> {
        public ClobType(Dialect dialect) {
            super((JdbcType)new ReactiveClobJdbcType(dialect), (JavaType)StringJavaType.INSTANCE);
        }

        public String getName() {
            return "materialized_clob";
        }
    }

    private static class JsonType
    extends AbstractSingleColumnStandardBasicType<JsonObject> {
        public JsonType(Dialect dialect) {
            super((JdbcType)ObjectJdbcType.INSTANCE, (JavaType)JsonObjectJavaType.INSTANCE);
        }

        public String getName() {
            return "json";
        }

        public String[] getRegistrationKeys() {
            return new String[]{"json", JsonObject.class.getName()};
        }
    }

    private static class JsonObjectJavaType
    implements BasicJavaType<JsonObject> {
        public static final JsonObjectJavaType INSTANCE = new JsonObjectJavaType();

        private JsonObjectJavaType() {
        }

        public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
            return ObjectJdbcType.INSTANCE;
        }

        public Type getJavaType() {
            return JsonObject.class;
        }

        public JsonObject fromString(CharSequence string) {
            return string == null ? null : new JsonObject(String.valueOf(string));
        }

        public <X> X unwrap(JsonObject value, Class<X> type, WrapperOptions options) {
            return (X)value;
        }

        public <X> JsonObject wrap(X value, WrapperOptions options) {
            return (JsonObject)value;
        }
    }

    private static class JavaObjectDdlType
    implements DdlType {
        private JavaObjectDdlType() {
        }

        public int getSqlTypeCode() {
            return 2000;
        }

        public String getRawTypeName() {
            return "json";
        }

        public String getTypeNamePattern() {
            return "";
        }

        public String getTypeName(Long size, Integer precision, Integer scale) {
            return "json";
        }

        public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType) {
            return "json";
        }

        public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType, Long length, Integer precision, Integer scale) {
            return "json";
        }
    }

    private static class TimestampUtcAsLocalDateTimeJdbcType
    extends TimestampUtcAsJdbcTimestampJdbcType {
        private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        public static final TimestampUtcAsLocalDateTimeJdbcType INSTANCE = new TimestampUtcAsLocalDateTimeJdbcType();

        private TimestampUtcAsLocalDateTimeJdbcType() {
        }

        public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, (JdbcType)this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    Instant instant = (Instant)javaType.unwrap(value, Instant.class, options);
                    ((PreparedStatementAdaptor)st).setTimestamp(index, Timestamp.from(instant), UTC_CALENDAR, ZonedDateTime::toLocalDateTime);
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    Instant instant = (Instant)javaType.unwrap(value, Instant.class, options);
                    ((PreparedStatementAdaptor)((Object)st)).setTimestamp(name, Timestamp.from(instant), UTC_CALENDAR, ZonedDateTime::toLocalDateTime);
                }
            };
        }
    }

    private static class TimestampAsLocalDateTimeJdbcType
    extends TimestampJdbcType {
        public static final TimestampAsLocalDateTimeJdbcType INSTANCE = new TimestampAsLocalDateTimeJdbcType();

        private TimestampAsLocalDateTimeJdbcType() {
        }

        public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
            return new BasicBinder<X>(javaType, (JdbcType)this){

                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                    Timestamp timestamp = (Timestamp)javaType.unwrap(value, Timestamp.class, options);
                    if (value instanceof Calendar) {
                        ((PreparedStatementAdaptor)st).setTimestamp(index, timestamp, (Calendar)value, ZonedDateTime::toLocalDateTime);
                    } else if (options.getJdbcTimeZone() != null) {
                        ((PreparedStatementAdaptor)st).setTimestamp(index, timestamp, Calendar.getInstance(options.getJdbcTimeZone()), ZonedDateTime::toLocalDateTime);
                    } else {
                        st.setTimestamp(index, timestamp);
                    }
                }

                protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                    Timestamp timestamp = (Timestamp)javaType.unwrap(value, Timestamp.class, options);
                    if (value instanceof Calendar) {
                        ((PreparedStatementAdaptor)((Object)st)).setTimestamp(name, timestamp, (Calendar)value, ZonedDateTime::toLocalDateTime);
                    } else if (options.getJdbcTimeZone() != null) {
                        ((PreparedStatementAdaptor)((Object)st)).setTimestamp(name, timestamp, Calendar.getInstance(options.getJdbcTimeZone()), ZonedDateTime::toLocalDateTime);
                    } else {
                        st.setTimestamp(name, timestamp);
                    }
                }
            };
        }
    }
}

