/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.reactive.vertx.VertxInstance;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;

public class ReactiveGenerationTarget
implements GenerationTarget {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ServiceRegistry registry;
    private VertxInstance vertxSupplier;
    private ReactiveConnectionPool service;
    private Set<String> statements;
    private final List<String> commands = new ArrayList<String>();
    private volatile CountDownLatch done;

    public ReactiveGenerationTarget(ServiceRegistry registry) {
        this.registry = registry;
    }

    public void prepare() {
        this.service = (ReactiveConnectionPool)this.registry.getService(ReactiveConnectionPool.class);
        this.vertxSupplier = (VertxInstance)this.registry.getService(VertxInstance.class);
        this.statements = new HashSet<String>();
        this.done = new CountDownLatch(1);
    }

    public void accept(String command) {
        if (this.statements.add(command)) {
            this.commands.add(command);
        }
    }

    public void release() {
        this.statements = null;
        if (!this.commands.isEmpty()) {
            this.vertxSupplier.getVertx().getOrCreateContext().runOnContext(v1 -> this.service.getConnection().thenCompose(this::executeCommands).handle(ReactiveGenerationTarget::logCommandFailure).thenAccept(v -> this.done.countDown()));
            if (this.done != null) {
                try {
                    this.done.await();
                }
                catch (InterruptedException e) {
                    log.warnf("Interrupted while performing schema export operations", e.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private CompletionStage<Void> executeCommands(ReactiveConnection reactiveConnection) {
        CompletionStage<Void> result = CompletionStages.voidFuture();
        for (String command : this.commands) {
            result = result.thenApply(v -> command).thenCompose(reactiveConnection::execute).handle(ReactiveGenerationTarget::logCommandFailure);
        }
        return result.thenApply(v -> reactiveConnection).thenCompose(ReactiveConnection::close).handle(ReactiveGenerationTarget::logCommandFailure);
    }

    private static <U> U logCommandFailure(Void ignore, Throwable throwable) {
        if (throwable != null) {
            log.ddlCommandFailed(throwable.getMessage());
        }
        return null;
    }
}

