/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.spi;

import jakarta.persistence.NoResultException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.sqm.internal.AggregatedSelectReactiveQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ConcreteSqmSelectReactiveQueryPlan;
import org.hibernate.reactive.query.sqm.spi.ReactiveSelectQueryPlan;
import org.hibernate.sql.results.internal.TupleMetadata;

public class ReactiveAbstractSelectionQuery<R> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final Supplier<QueryOptions> queryOptionsSupplier;
    private final SharedSessionContractImplementor session;
    private final Supplier<CompletionStage<List<R>>> doList;
    private final Supplier<SqmStatement<?>> getStatement;
    private final Supplier<TupleMetadata> getTupleMetadata;
    private final Supplier<DomainParameterXref> getDomainParameterXref;
    private final Supplier<Class<R>> getResultType;
    private final Supplier<String> getQueryString;
    private final Runnable beforeQuery;
    private final Consumer<Boolean> afterQuery;
    private final Function<List<R>, R> uniqueElement;
    private final SqmInterpretationsKey.InterpretationsKeySource interpretationsKeySource;

    public ReactiveAbstractSelectionQuery(SqmInterpretationsKey.InterpretationsKeySource interpretationKeySource, SharedSessionContractImplementor session, Supplier<CompletionStage<List<R>>> doList, Supplier<SqmStatement<?>> getStatement, Supplier<TupleMetadata> getTupleMetadata, Supplier<DomainParameterXref> getDomainParameterXref, Supplier<Class<R>> getResultType, Supplier<String> getQueryString, Runnable beforeQuery, Consumer<Boolean> afterQuery, Function<List<R>, R> uniqueElement) {
        this(() -> ((SqmInterpretationsKey.InterpretationsKeySource)interpretationKeySource).getQueryOptions(), session, doList, getStatement, getTupleMetadata, getDomainParameterXref, getResultType, getQueryString, beforeQuery, afterQuery, uniqueElement, interpretationKeySource);
    }

    public ReactiveAbstractSelectionQuery(Supplier<QueryOptions> queryOptionsSupplier, SharedSessionContractImplementor session, Supplier<CompletionStage<List<R>>> doList, Supplier<SqmStatement<?>> getStatement, Supplier<TupleMetadata> getTupleMetadata, Supplier<DomainParameterXref> getDomainParameterXref, Supplier<Class<R>> getResultType, Supplier<String> getQueryString, Runnable beforeQuery, Consumer<Boolean> afterQuery, Function<List<R>, R> uniqueElement, SqmInterpretationsKey.InterpretationsKeySource interpretationsKeySource) {
        this.queryOptionsSupplier = queryOptionsSupplier;
        this.session = session;
        this.doList = doList;
        this.getStatement = getStatement;
        this.getTupleMetadata = getTupleMetadata;
        this.getDomainParameterXref = getDomainParameterXref;
        this.getResultType = getResultType;
        this.getQueryString = getQueryString;
        this.beforeQuery = beforeQuery;
        this.afterQuery = afterQuery;
        this.uniqueElement = uniqueElement;
        this.interpretationsKeySource = interpretationsKeySource;
    }

    public CompletionStage<R> reactiveUnique() {
        return this.reactiveList().thenApply(this.uniqueElement);
    }

    public CompletionStage<Optional<R>> reactiveUniqueResultOptional() {
        return this.reactiveUnique().thenApply(Optional::ofNullable);
    }

    public CompletionStage<R> getReactiveSingleResult() {
        return this.reactiveList().thenApply(this::reactiveSingleResult).exceptionally(this::convertException);
    }

    private R reactiveSingleResult(List<R> list) {
        if (list.isEmpty()) {
            throw new NoResultException(String.format("No result found for query [%s]", this.getQueryString()));
        }
        return this.uniqueElement.apply(list);
    }

    public CompletionStage<R> getReactiveSingleResultOrNull() {
        return this.reactiveList().thenApply(this.uniqueElement).exceptionally(this::convertException);
    }

    private R convertException(Throwable t) {
        if (t instanceof CompletionException && t.getCause() != null) {
            return this.convertException(t.getCause());
        }
        if (t instanceof HibernateException) {
            throw this.getSession().getExceptionConverter().convert((HibernateException)t, this.getLockOptions());
        }
        if (t instanceof RuntimeException) {
            throw this.getSession().getExceptionConverter().convert((RuntimeException)t, this.getLockOptions());
        }
        throw new CompletionException(t);
    }

    private LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    public CompletionStage<List<R>> reactiveList() {
        this.beforeQuery.run();
        return this.doReactiveList().handle((list, error) -> {
            this.handleException((Throwable)error);
            return list;
        }).whenComplete((rs, throwable) -> this.afterQuery.accept(throwable == null));
    }

    private void handleException(Throwable e) {
        if (e != null) {
            if (e instanceof IllegalQueryOperationException) {
                throw new IllegalStateException(e);
            }
            if (e instanceof TypeMismatchException) {
                throw new IllegalStateException(e);
            }
            if (e instanceof HibernateException) {
                throw this.getSession().getExceptionConverter().convert((HibernateException)e, this.getLockOptions());
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new HibernateException(e);
        }
    }

    public ReactiveSelectQueryPlan<R> resolveSelectReactiveQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey((SqmInterpretationsKey.InterpretationsKeySource)this.interpretationsKeySource);
        if (cacheKey != null) {
            return (ReactiveSelectQueryPlan)this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan((QueryInterpretationCache.Key)cacheKey, this::buildSelectQueryPlan);
        }
        return this.buildSelectQueryPlan();
    }

    private ReactiveSelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement[] concreteSqmStatements = QuerySplitter.split((SqmSelectStatement)((SqmSelectStatement)this.getSqmStatement()), (SessionFactoryImplementor)this.getSession().getFactory());
        return concreteSqmStatements.length > 1 ? this.buildAggregatedSelectQueryPlan(concreteSqmStatements) : this.buildConcreteSelectQueryPlan(concreteSqmStatements[0], this.getResultType(), this.getQueryOptions());
    }

    private ReactiveSelectQueryPlan<R> buildAggregatedSelectQueryPlan(SqmSelectStatement<?>[] concreteSqmStatements) {
        ReactiveSelectQueryPlan[] aggregatedQueryPlans = new ReactiveSelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteSelectQueryPlan(concreteSqmStatements[i], this.getResultType(), this.getQueryOptions());
        }
        return new AggregatedSelectReactiveQueryPlan(aggregatedQueryPlans);
    }

    private <T> ReactiveSelectQueryPlan<T> buildConcreteSelectQueryPlan(SqmSelectStatement<?> concreteSqmStatement, Class<T> resultType, QueryOptions queryOptions) {
        return new ConcreteSqmSelectReactiveQueryPlan<T>(concreteSqmStatement, this.getQueryString(), this.getDomainParameterXref(), resultType, this.getTupleMetadata(), queryOptions);
    }

    private QueryOptions getQueryOptions() {
        return this.queryOptionsSupplier.get();
    }

    private SharedSessionContractImplementor getSession() {
        return this.session;
    }

    private CompletionStage<List<R>> doReactiveList() {
        return this.doList.get();
    }

    public SqmStatement<?> getSqmStatement() {
        return this.getStatement.get();
    }

    public TupleMetadata getTupleMetadata() {
        return this.getTupleMetadata.get();
    }

    public Class<R> getResultType() {
        return this.getResultType.get();
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.getDomainParameterXref.get();
    }

    public String getQueryString() {
        return this.getQueryString.get();
    }

    public R getSingleResult() {
        throw LOG.nonReactiveMethodCall("getReactiveSingleResult");
    }

    public R getSingleResultOrNull() {
        throw LOG.nonReactiveMethodCall("getReactiveSingleResultOrNull");
    }

    public List<R> getResultList() {
        throw LOG.nonReactiveMethodCall("getReactiveResultList");
    }

    public List<R> list() {
        throw LOG.nonReactiveMethodCall("reactiveList");
    }

    public Stream<R> getResultStream() {
        throw LOG.nonReactiveMethodCall("<no alternative>");
    }

    public R uniqueResult() {
        throw LOG.nonReactiveMethodCall("reactiveUniqueResult");
    }

    public Optional<R> uniqueResultOptional() {
        throw LOG.nonReactiveMethodCall("reactiveUniqueResultOptional");
    }
}

