/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sql.internal.NativeSelectQueryPlanImpl;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.reactive.engine.spi.ReactiveSharedSessionContractImplementor;
import org.hibernate.reactive.query.internal.ReactiveResultSetMappingProcessor;
import org.hibernate.reactive.query.spi.ReactiveNativeSelectQueryPlan;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;

public class ReactiveNativeSelectQueryPlanImpl<R>
extends NativeSelectQueryPlanImpl<R>
implements ReactiveNativeSelectQueryPlan<R> {
    private final Set<String> affectedTableNames;
    private final String sql;
    private final List<ParameterOccurrence> parameterList;
    private final JdbcValuesMappingProducer resultSetMapping;

    public ReactiveNativeSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<ParameterOccurrence> parameterList, ResultSetMapping resultSetMapping, SessionFactoryImplementor sessionFactory) {
        super(sql, affectedTableNames, parameterList, resultSetMapping, sessionFactory);
        ReactiveResultSetMappingProcessor processor = new ReactiveResultSetMappingProcessor(resultSetMapping, sessionFactory);
        SQLQueryParser parser = new SQLQueryParser(sql, processor.process(), sessionFactory);
        this.resultSetMapping = processor.generateResultMapping(parser.queryHasAliases());
        if (affectedTableNames == null) {
            affectedTableNames = new HashSet<String>();
        }
        if (resultSetMapping != null) {
            resultSetMapping.addAffectedTableNames(affectedTableNames, sessionFactory);
        }
        this.affectedTableNames = affectedTableNames;
        this.sql = parser.process();
        this.parameterList = parameterList;
    }

    @Override
    public CompletionStage<List<R>> reactivePerformList(DomainQueryExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings;
        List jdbcParameterBinders;
        QueryOptions queryOptions = executionContext.getQueryOptions();
        if (queryOptions.getEffectiveLimit().getMaxRowsJpa() == 0) {
            return CompletionStages.completedFuture(Collections.emptyList());
        }
        QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            jdbcParameterBinders = Collections.emptyList();
            jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
        } else {
            jdbcParameterBinders = new ArrayList(this.parameterList.size());
            jdbcParameterBindings = new JdbcParameterBindingsImpl(queryParameterBindings, this.parameterList, jdbcParameterBinders, executionContext.getSession().getFactory());
        }
        ReactiveSharedSessionContractImplementor reactiveSession = (ReactiveSharedSessionContractImplementor)executionContext.getSession();
        return reactiveSession.reactiveAutoFlushIfRequired(this.affectedTableNames).thenCompose(aBoolean -> {
            JdbcOperationQuerySelect jdbcSelect = new JdbcOperationQuerySelect(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames, Collections.emptySet());
            return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, jdbcParameterBindings, (ExecutionContext)SqmJdbcExecutionContextAdapter.usingLockingAndPaging((DomainQueryExecutionContext)executionContext), null, queryOptions.getUniqueSemantic() == null ? ReactiveListResultsConsumer.UniqueSemantic.NEVER : ReactiveNativeSelectQueryPlanImpl.reactiveUniqueSemantic(queryOptions));
        });
    }

    private static ReactiveListResultsConsumer.UniqueSemantic reactiveUniqueSemantic(QueryOptions queryOptions) {
        switch (queryOptions.getUniqueSemantic()) {
            case NONE: {
                return ReactiveListResultsConsumer.UniqueSemantic.NONE;
            }
            case FILTER: {
                return ReactiveListResultsConsumer.UniqueSemantic.FILTER;
            }
            case ASSERT: {
                return ReactiveListResultsConsumer.UniqueSemantic.ASSERT;
            }
            case NEVER: {
                return ReactiveListResultsConsumer.UniqueSemantic.NEVER;
            }
            case ALLOW: {
                return ReactiveListResultsConsumer.UniqueSemantic.ALLOW;
            }
        }
        throw new IllegalArgumentException("Unique semantic option not recognized: " + queryOptions.getUniqueSemantic());
    }
}

