/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.cte;

import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmInsertStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertHandler;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.sqm.mutation.internal.ReactiveHandler;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableGroup;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class ReactiveCteInsertHandler
extends CteInsertHandler
implements ReactiveHandler {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public ReactiveCteInsertHandler(CteTable cteTable, SqmInsertStatement<?> sqmStatement, DomainParameterXref domainParameterXref, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmStatement, domainParameterXref, sessionFactory);
    }

    public int execute(DomainQueryExecutionContext executionContext) {
        throw LOG.nonReactiveMethodCall("reactiveExecute");
    }

    @Override
    public CompletionStage<Integer> reactiveExecute(DomainQueryExecutionContext executionContext) {
        CteStatement entityCte;
        SelectStatement queryStatement;
        SqmInsertStatement sqmInsertStatement = this.getSqmStatement();
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityPersister entityDescriptor = this.getEntityDescriptor().getEntityPersister();
        String explicitDmlTargetAlias = sqmInsertStatement.getTarget().getExplicitAlias() == null ? "dml_target" : sqmInsertStatement.getTarget().getExplicitAlias();
        MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter((EntityMappingType)entityDescriptor, (SqmStatement)sqmInsertStatement, sqmInsertStatement.getTarget(), explicitDmlTargetAlias, this.getDomainParameterXref(), executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), (SqlAstCreationContext)factory);
        TableGroup insertingTableGroup = sqmConverter.getMutatingTableGroup();
        Map parameterResolutions = this.getDomainParameterXref().getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        int size = this.getSqmStatement().getInsertionTargetPaths().size();
        ArrayList targetPathColumns = new ArrayList(size);
        ArrayList<CteColumn> targetPathCteColumns = new ArrayList<CteColumn>(size);
        final LinkedHashMap paramTypeResolutions = new LinkedHashMap();
        NamedTableReference entityTableReference = new NamedTableReference(this.getCteTable().getTableExpression(), "temptable_", true);
        InsertSelectStatement insertStatement = new InsertSelectStatement(entityTableReference);
        BaseSqmToSqlAstConverter.AdditionalInsertValues additionalInsertValues = sqmConverter.visitInsertionTargetPaths((assignable, columnReferences) -> {
            SqmPathInterpretation pathInterpretation = (SqmPathInterpretation)assignable;
            int offset = CteTable.determineModelPartStartIndex((EntityPersister)entityDescriptor, (ModelPart)pathInterpretation.getExpressionType());
            if (offset == -1) {
                throw new IllegalStateException("Couldn't find matching cte column for: " + ((Expression)assignable).getExpressionType());
            }
            int end = offset + pathInterpretation.getExpressionType().getJdbcTypeCount();
            List columns = this.getCteTable().getCteColumns().subList(offset, end);
            insertStatement.addTargetColumnReferences(columnReferences);
            targetPathCteColumns.addAll(columns);
            targetPathColumns.add(new AbstractMap.SimpleEntry(columns, new Assignment(assignable, (Expression)assignable)));
        }, sqmInsertStatement, entityDescriptor, insertingTableGroup, (sqmParameter, mappingType, jdbcParameters) -> {
            parameterResolutions.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParameters);
            paramTypeResolutions.put(sqmParameter, mappingType);
        });
        boolean assignsId = targetPathCteColumns.contains(this.getCteTable().getCteColumns().get(0));
        Stack processingStateStack = sqmConverter.getProcessingStateStack();
        SqlAstProcessingState oldState = (SqlAstProcessingState)processingStateStack.pop();
        if (sqmInsertStatement instanceof SqmInsertSelectStatement) {
            QueryPart queryPart = sqmConverter.visitQueryPart(((SqmInsertSelectStatement)sqmInsertStatement).getSelectQueryPart());
            queryPart.visitQuerySpecs(querySpec -> {
                if (additionalInsertValues.applySelections(querySpec, this.getSessionFactory())) {
                    CteColumn rowNumberColumn = (CteColumn)this.getCteTable().getCteColumns().get(this.getCteTable().getCteColumns().size() - 1);
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping());
                    insertStatement.getTargetColumns().set(insertStatement.getTargetColumns().size() - 1, columnReference);
                    targetPathCteColumns.set(targetPathCteColumns.size() - 1, rowNumberColumn);
                }
                if (!assignsId && entityDescriptor.getGenerator().generatedOnExecution()) {
                    querySpec.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(0, SqmInsertStrategyHelper.createRowNumberingExpression((QuerySpec)querySpec, (SessionFactoryImplementor)this.getSessionFactory())));
                }
            });
            queryStatement = new SelectStatement(queryPart);
        } else {
            List sqmValuesList = ((SqmInsertValuesStatement)sqmInsertStatement).getValuesList();
            ArrayList<Values> valuesList = new ArrayList<Values>(sqmValuesList.size());
            for (SqmValues sqmValues : sqmValuesList) {
                Values values = sqmConverter.visitValues(sqmValues);
                additionalInsertValues.applyValues(values);
                valuesList.add(values);
            }
            QuerySpec querySpec2 = new QuerySpec(true);
            NavigablePath navigablePath2 = new NavigablePath(entityDescriptor.getRootPathName());
            ArrayList<String> columnNames = new ArrayList<String>(targetPathColumns.size());
            String valuesAlias = insertingTableGroup.getPrimaryTableReference().getIdentificationVariable();
            for (Map.Entry entry : targetPathColumns) {
                for (ColumnReference columnReference : ((Assignment)entry.getValue()).getAssignable().getColumnReferences()) {
                    columnNames.add(columnReference.getColumnExpression());
                    querySpec2.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(0, (Expression)(columnReference.getQualifier().equals(valuesAlias) ? columnReference : new ColumnReference(valuesAlias, columnReference.getColumnExpression(), false, null, columnReference.getJdbcMapping()))));
                }
            }
            ValuesTableGroup valuesTableGroup = new ValuesTableGroup(navigablePath2, (TableGroupProducer)entityDescriptor.getEntityPersister(), valuesList, insertingTableGroup.getPrimaryTableReference().getIdentificationVariable(), columnNames, true, factory);
            querySpec2.getFromClause().addRoot((TableGroup)valuesTableGroup);
            queryStatement = new SelectStatement((QueryPart)querySpec2);
        }
        processingStateStack.push((Object)oldState);
        sqmConverter.pruneTableGroupJoins();
        if (!assignsId && entityDescriptor.getGenerator().generatedOnExecution()) {
            CteColumn rowNumberColumn = (CteColumn)this.getCteTable().getCteColumns().get(this.getCteTable().getCteColumns().size() - 1);
            ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping());
            insertStatement.getTargetColumns().add(columnReference);
            targetPathCteColumns.add(rowNumberColumn);
        }
        CteTable entityCteTable = ReactiveCteInsertHandler.createCteTable((CteTable)this.getCteTable(), targetPathCteColumns, (SessionFactoryImplementor)factory);
        QuerySpec querySpec3 = new QuerySpec(true, 1);
        ArrayList<BasicResult> domainResults = new ArrayList<BasicResult>(1);
        SelectStatement statement = new SelectStatement((QueryPart)querySpec3, domainResults);
        if (additionalInsertValues.requiresRowNumberIntermediate()) {
            CteTable finalEntityCteTable;
            CteTable fullEntityCteTable = this.getCteTable();
            String baseTableName = "base_" + entityCteTable.getTableExpression();
            CteStatement baseEntityCte = new CteStatement(entityCteTable.withName(baseTableName), (Statement)queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(baseEntityCte);
            CteColumn rowNumberColumn = (CteColumn)fullEntityCteTable.getCteColumns().get(fullEntityCteTable.getCteColumns().size() - 1);
            ColumnReference rowNumberColumnReference = new ColumnReference("e", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping());
            CteColumn idColumn = (CteColumn)fullEntityCteTable.getCteColumns().get(0);
            BasicValuedMapping idType = (BasicValuedMapping)idColumn.getJdbcMapping();
            Optimizer optimizer = ((OptimizableGenerator)entityDescriptor.getGenerator()).getOptimizer();
            BasicValuedMapping integerType = (BasicValuedMapping)rowNumberColumn.getJdbcMapping();
            BinaryArithmeticExpression rowNumberMinusOneModuloIncrement = new BinaryArithmeticExpression((Expression)new BinaryArithmeticExpression((Expression)rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, (Expression)new QueryLiteral((Object)1, (BasicValuedMapping)rowNumberColumn.getJdbcMapping()), integerType), BinaryArithmeticOperator.MODULO, (Expression)new QueryLiteral((Object)optimizer.getIncrementSize(), integerType), integerType);
            QuerySpec rowsWithSequenceQuery = new QuerySpec(true);
            rowsWithSequenceQuery.getFromClause().addRoot((TableGroup)new CteTableGroup(new NamedTableReference(baseTableName, "e")));
            rowsWithSequenceQuery.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(0, (Expression)rowNumberColumnReference));
            String fragment = ((BulkInsertionCapableIdentifierGenerator)entityDescriptor.getGenerator()).determineBulkInsertionIdentifierGenerationSelectFragment(this.getSessionFactory().getSqlStringGenerationContext());
            rowsWithSequenceQuery.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(1, (Expression)new SelfRenderingSqlFragmentExpression(fragment)));
            rowsWithSequenceQuery.applyPredicate((Predicate)new ComparisonPredicate((Expression)rowNumberMinusOneModuloIncrement, ComparisonOperator.EQUAL, (Expression)new QueryLiteral((Object)0, integerType)));
            CteTable rowsWithSequenceCteTable = new CteTable("rows_with_next_val", List.of(rowNumberColumn, idColumn));
            SelectStatement rowsWithSequenceStatement = new SelectStatement((QueryPart)rowsWithSequenceQuery);
            CteStatement rowsWithSequenceCte = new CteStatement(rowsWithSequenceCteTable, (Statement)rowsWithSequenceStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(rowsWithSequenceCte);
            QuerySpec entityQuery = new QuerySpec(true);
            NavigablePath navigablePath3 = new NavigablePath(baseTableName);
            TableGroupImpl baseTableGroup = new TableGroupImpl(navigablePath3, null, (TableReference)new NamedTableReference(baseTableName, "e"), null);
            CteTableGroup rowsWithSequenceTableGroup = new CteTableGroup(new NamedTableReference("rows_with_next_val", "t"));
            baseTableGroup.addTableGroupJoin(new TableGroupJoin(rowsWithSequenceTableGroup.getNavigablePath(), SqlAstJoinType.LEFT, (TableGroup)rowsWithSequenceTableGroup, (Predicate)new ComparisonPredicate((Expression)new BinaryArithmeticExpression((Expression)rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, (Expression)rowNumberMinusOneModuloIncrement, integerType), ComparisonOperator.EQUAL, (Expression)new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping()))));
            entityQuery.getFromClause().addRoot((TableGroup)baseTableGroup);
            entityQuery.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(0, (Expression)new BinaryArithmeticExpression((Expression)new ColumnReference("t", idColumn.getColumnExpression(), false, null, idColumn.getJdbcMapping()), BinaryArithmeticOperator.ADD, (Expression)new BinaryArithmeticExpression((Expression)rowNumberColumnReference, BinaryArithmeticOperator.SUBTRACT, (Expression)new ColumnReference("t", rowNumberColumn.getColumnExpression(), false, null, rowNumberColumn.getJdbcMapping()), integerType), idType)));
            if (targetPathCteColumns.contains(this.getCteTable().getCteColumns().get(0))) {
                finalEntityCteTable = entityCteTable;
            } else {
                targetPathCteColumns.add(0, (CteColumn)this.getCteTable().getCteColumns().get(0));
                finalEntityCteTable = ReactiveCteInsertHandler.createCteTable((CteTable)this.getCteTable(), targetPathCteColumns, (SessionFactoryImplementor)factory);
            }
            List cteColumns = finalEntityCteTable.getCteColumns();
            for (int i = 1; i < cteColumns.size(); ++i) {
                CteColumn cteColumn = (CteColumn)cteColumns.get(i);
                entityQuery.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(i, (Expression)new ColumnReference("e", cteColumn.getColumnExpression(), false, null, cteColumn.getJdbcMapping())));
            }
            SelectStatement entityStatement = new SelectStatement((QueryPart)entityQuery);
            entityCte = new CteStatement(finalEntityCteTable, (Statement)entityStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(entityCte);
        } else if (!assignsId && entityDescriptor.getGenerator().generatedOnExecution()) {
            String baseTableName = "base_" + entityCteTable.getTableExpression();
            CteStatement baseEntityCte = new CteStatement(entityCteTable.withName(baseTableName), (Statement)queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(baseEntityCte);
            targetPathCteColumns.add(0, (CteColumn)this.getCteTable().getCteColumns().get(0));
            CteTable finalEntityCteTable = ReactiveCteInsertHandler.createCteTable((CteTable)this.getCteTable(), targetPathCteColumns, (SessionFactoryImplementor)factory);
            QuerySpec finalQuerySpec = new QuerySpec(true);
            SelectStatement finalQueryStatement = new SelectStatement((QueryPart)finalQuerySpec);
            entityCte = new CteStatement(finalEntityCteTable, (Statement)finalQueryStatement, CteMaterialization.MATERIALIZED);
        } else {
            entityCte = new CteStatement(entityCteTable, (Statement)queryStatement, CteMaterialization.MATERIALIZED);
            statement.addCteStatement(entityCte);
        }
        String baseInsertCte = this.addDmlCtes((CteContainer)statement, entityCte, targetPathColumns, assignsId, sqmConverter, parameterResolutions, factory);
        Expression count = this.createCountStar(factory, sqmConverter);
        domainResults.add(new BasicResult(0, null, ((SqlExpressible)count).getJdbcMapping()));
        querySpec3.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(0, count));
        querySpec3.getFromClause().addRoot((TableGroup)new CteTableGroup(new NamedTableReference(baseInsertCte, "id")));
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator translator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, statement);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)this.getDomainParameterXref(), (Map)SqmUtil.generateJdbcParamsXref((DomainParameterXref)this.getDomainParameterXref(), (JdbcParameterBySqmParameterAccess)sqmConverter), (MappingMetamodel)factory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> sqmConverter.getMutatingTableGroup(), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, (SharedSessionContractImplementor)executionContext.getSession());
        JdbcOperationQuerySelect select = (JdbcOperationQuerySelect)translator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return ((ReactiveSession)executionContext.getSession()).reactiveAutoFlushIfRequired(select.getAffectedTableNames()).thenCompose(v -> StandardReactiveSelectExecutor.INSTANCE.list(select, jdbcParameterBindings, (ExecutionContext)SqmJdbcExecutionContextAdapter.omittingLockingAndPaging((DomainQueryExecutionContext)executionContext), row -> row[0], ReactiveListResultsConsumer.UniqueSemantic.NONE).thenApply(list -> ((Number)list.get(0)).intValue()));
    }
}

