/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.sql.results.internal.ReactiveResultSetAccess;
import org.hibernate.reactive.sql.results.spi.ReactiveValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ReactiveResultSetMapping
implements ResultSetMapping,
ReactiveValuesMappingProducer {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ResultSetMapping delegate;

    public ReactiveResultSetMapping(ResultSetMapping resultSetMapping) {
        this.delegate = Objects.requireNonNull(resultSetMapping);
        assert (!(resultSetMapping instanceof ReactiveResultSetMapping)) : "double wrapping detected!";
    }

    public JdbcValuesMapping resolve(JdbcValuesMetadata jdbcResultsMetadata, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        throw LOG.nonReactiveMethodCall("reactiveResolve");
    }

    public void addAffectedTableNames(Set<String> affectedTableNames, SessionFactoryImplementor sessionFactory) {
        this.delegate.addAffectedTableNames(affectedTableNames, sessionFactory);
    }

    @Override
    public CompletionStage<JdbcValuesMapping> reactiveResolve(JdbcValuesMetadata jdbcResultsMetadata, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        return ((ReactiveResultSetAccess)jdbcResultsMetadata).getReactiveResultSet().thenApply(columnCount -> this.delegate.resolve(jdbcResultsMetadata, loadQueryInfluencers, sessionFactory));
    }

    public String getMappingIdentifier() {
        return this.delegate.getMappingIdentifier();
    }

    public boolean isDynamic() {
        return this.delegate.isDynamic();
    }

    public int getNumberOfResultBuilders() {
        return this.delegate.getNumberOfResultBuilders();
    }

    public List<ResultBuilder> getResultBuilders() {
        return this.delegate.getResultBuilders();
    }

    public void visitResultBuilders(BiConsumer<Integer, ResultBuilder> resultBuilderConsumer) {
        this.delegate.visitResultBuilders(resultBuilderConsumer);
    }

    public void visitLegacyFetchBuilders(Consumer<DynamicFetchBuilderLegacy> resultBuilderConsumer) {
        this.delegate.visitLegacyFetchBuilders(resultBuilderConsumer);
    }

    public void addResultBuilder(ResultBuilder resultBuilder) {
        this.delegate.addResultBuilder(resultBuilder);
    }

    public void addLegacyFetchBuilder(DynamicFetchBuilderLegacy fetchBuilder) {
        this.delegate.addLegacyFetchBuilder(fetchBuilder);
    }

    public NamedResultSetMappingMemento toMemento(String name) {
        return this.delegate.toMemento(name);
    }
}

