/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveDomainResultsAssembler;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.entity.AbstractEntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;

public abstract class ReactiveAbstractEntityInitializer
extends AbstractEntityInitializer
implements ReactiveInitializer {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    protected ReactiveAbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, Fetch identifierFetch, Fetch discriminatorFetch, DomainResult<Object> rowIdResult, AssemblerCreationState creationState) {
        super(resultDescriptor, navigablePath, lockMode, identifierFetch, discriminatorFetch, rowIdResult, creationState);
    }

    public void resolveInstance(RowProcessingState rowProcessingState) {
        super.resolveInstance(rowProcessingState);
    }

    public void initializeInstance(RowProcessingState rowProcessingState) {
        throw LOG.nonReactiveMethodCall("reactiveInitializeInstance");
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(ReactiveRowProcessingState rowProcessingState) {
        super.resolveInstance((RowProcessingState)rowProcessingState);
        return CompletionStages.voidFuture();
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(ReactiveRowProcessingState rowProcessingState) {
        if (this.isMissing() || this.isEntityInitialized()) {
            return CompletionStages.voidFuture();
        }
        this.preLoad(rowProcessingState);
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)this.getEntityInstance());
        return CompletionStages.voidFuture().thenCompose(v -> {
            if (lazyInitializer != null) {
                return this.lazyInitialize(rowProcessingState, lazyInitializer);
            }
            return this.initializeEntity(this.getEntityInstance(), rowProcessingState).thenAccept(ignore -> this.setEntityInstanceForNotify(this.getEntityInstance()));
        }).thenAccept(o -> {
            this.notifyResolutionListeners(this.getEntityInstanceForNotify());
            this.setEntityInitialized(true);
        });
    }

    private CompletionStage<Void> lazyInitialize(ReactiveRowProcessingState rowProcessingState, LazyInitializer lazyInitializer) {
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object instance = persistenceContext.getEntity(this.getEntityKey());
        if (instance == null) {
            return this.resolveInstance(rowProcessingState, lazyInitializer, persistenceContext);
        }
        lazyInitializer.setImplementation(instance);
        this.setEntityInstanceForNotify(instance);
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> resolveInstance(ReactiveRowProcessingState rowProcessingState, LazyInitializer lazyInitializer, PersistenceContext persistenceContext) {
        Object instance = this.resolveInstance(this.getEntityKey().getIdentifier(), persistenceContext.getLoadContexts().findLoadingEntityEntry(this.getEntityKey()), rowProcessingState);
        return this.initializeEntity(instance, rowProcessingState).thenAccept(v -> {
            lazyInitializer.setImplementation(instance);
            this.setEntityInstanceForNotify(instance);
        });
    }

    private Object resolveInstance(Object entityIdentifier, LoadingEntityEntry existingLoadingEntry, RowProcessingState rowProcessingState) {
        if (this.isOwningInitializer()) {
            assert (existingLoadingEntry == null || existingLoadingEntry.getEntityInstance() == null);
            return this.resolveEntityInstance(entityIdentifier, rowProcessingState);
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath(), (Object)entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
        }
        return existingLoadingEntry.getEntityInstance();
    }

    private CompletionStage<Void> initializeEntity(Object toInitialize, RowProcessingState rowProcessingState) {
        if (!this.skipInitialization(toInitialize, rowProcessingState)) {
            assert (this.consistentInstance(toInitialize, rowProcessingState));
            return this.initializeEntityInstance(toInitialize, rowProcessingState);
        }
        return CompletionStages.voidFuture();
    }

    protected CompletionStage<Object[]> reactiveExtractConcreteTypeStateValues(RowProcessingState rowProcessingState) {
        Object[] values = new Object[this.getConcreteDescriptor().getNumberOfAttributeMappings()];
        DomainResultAssembler[] concreteAssemblers = this.getAssemblers()[this.getConcreteDescriptor().getSubclassId()];
        return CompletionStages.loop(0, values.length, i -> {
            DomainResultAssembler assembler = concreteAssemblers[i];
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble((ReactiveRowProcessingState)rowProcessingState).thenAccept(obj -> {
                    values[i] = obj;
                });
            }
            values[i] = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(unused -> values);
    }

    private CompletionStage<Void> initializeEntityInstance(Object toInitialize, RowProcessingState rowProcessingState) {
        Object entityIdentifier = this.getEntityKey().getIdentifier();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#initializeInstance process for entity %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath(), (Object)entityIdentifier));
        }
        this.getEntityDescriptor().setIdentifier(toInitialize, entityIdentifier, session);
        return this.reactiveExtractConcreteTypeStateValues(rowProcessingState).thenCompose(entityState -> CompletionStages.loop(0, ((Object[])entityState).length, i -> {
            if (entityState[i] instanceof CompletionStage) {
                return ((CompletionStage)entityState[i]).thenAccept(state -> {
                    entityState[i] = state;
                });
            }
            return CompletionStages.voidFuture();
        }).thenAccept(v -> this.setResolvedEntityState((Object[])entityState))).thenAccept(v -> {
            StatisticsImplementor statistics;
            PersistentAttributeInterceptor persistentAttributeInterceptor;
            if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)toInitialize) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)toInitialize).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
                this.getConcreteDescriptor().getBytecodeEnhancementMetadata().injectInterceptor(toInitialize, entityIdentifier, session);
            }
            this.getConcreteDescriptor().setPropertyValues(toInitialize, this.getResolvedEntityState());
            persistenceContext.addEntity(this.getEntityKey(), toInitialize);
            this.registerPossibleUniqueKeyEntries(toInitialize, session);
            Object version = this.getVersionAssembler() != null ? this.getVersionAssembler().assemble(rowProcessingState) : null;
            Object rowId = this.getRowIdAssembler() != null ? this.getRowIdAssembler().assemble(rowProcessingState) : null;
            LockMode lockModeToAcquire = this.getLockMode() == LockMode.NONE ? LockMode.READ : this.getLockMode();
            EntityEntry entityEntry = persistenceContext.addEntry(toInitialize, Status.LOADING, this.getResolvedEntityState(), rowId, this.getEntityKey().getIdentifier(), version, lockModeToAcquire, true, this.getConcreteDescriptor(), false);
            this.updateCaches(toInitialize, rowProcessingState, session, persistenceContext, entityIdentifier, version);
            this.registerNaturalIdResolution(persistenceContext, entityIdentifier);
            this.takeSnapshot(rowProcessingState, session, persistenceContext, entityEntry);
            this.getConcreteDescriptor().afterInitialize(toInitialize, session);
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Done materializing entityInstance : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath(), (Object)entityIdentifier));
            }
            if ((statistics = session.getFactory().getStatistics()).isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
                statistics.loadEntity(this.getConcreteDescriptor().getEntityName());
            }
        });
    }
}

