/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveDomainResultsAssembler;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.type.descriptor.java.JavaType;

public class ReactiveEntityAssembler<T>
implements ReactiveDomainResultsAssembler<T> {
    private final JavaType<T> javaType;
    private final EntityInitializer initializer;

    public ReactiveEntityAssembler(JavaType<T> javaType, EntityInitializer initializer) {
        this.javaType = javaType;
        this.initializer = initializer;
    }

    public JavaType<T> getAssembledJavaType() {
        return this.javaType;
    }

    @Override
    public CompletionStage<T> reactiveAssemble(ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        return ((ReactiveInitializer)this.initializer).reactiveResolveInstance(rowProcessingState).thenApply(v -> this.initializer.getEntityInstance());
    }
}

