/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.FetchNotFoundException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.impl.ReactiveQueryExecutorLookup;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveEntitySelectFetchInitializer
extends EntitySelectFetchInitializer
implements ReactiveInitializer {
    private static final String CONCRETE_NAME = ReactiveEntitySelectFetchInitializer.class.getSimpleName();
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final boolean isEnhancedForLazyLoading;

    public ReactiveEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping toOneMapping, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> keyAssembler) {
        super(parentAccess, toOneMapping, fetchedNavigable, concreteDescriptor, keyAssembler);
        this.isEnhancedForLazyLoading = concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    public void resolveInstance(RowProcessingState rowProcessingState) {
        super.resolveInstance(rowProcessingState);
    }

    public void initializeInstance(RowProcessingState rowProcessingState) {
        throw LOG.nonReactiveMethodCall("reactiveInitializeInstance");
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(ReactiveRowProcessingState rowProcessingState) {
        NavigablePath[] np = new NavigablePath[]{this.getNavigablePath().getParent()};
        if (np[0] == null) {
            return CompletionStages.voidFuture();
        }
        return CompletionStages.whileLoop(() -> {
            CompletionStage<Void> loop = CompletionStages.voidFuture();
            if (np[0] instanceof EntityIdentifierNavigablePath || "{fk}".equals(np[0].getLocalName()) || "{fk-target}".equals(np[0].getLocalName())) {
                loop = this.reactiveInitializeInstance(rowProcessingState);
            }
            return loop.thenApply(v -> {
                np[0] = np[0].getParent();
                return np[0] != null;
            });
        });
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(ReactiveRowProcessingState rowProcessingState) {
        if (this.getEntityInstance() != null || this.isEntityInitialized()) {
            return CompletionStages.voidFuture();
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return CompletionStages.voidFuture();
        }
        Object entityIdentifier = this.keyAssembler.assemble((RowProcessingState)rowProcessingState);
        if (entityIdentifier == null) {
            this.isInitialized = true;
            return CompletionStages.voidFuture();
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse((String)this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        String entityName = this.concreteDescriptor.getEntityName();
        EntityKey entityKey = new EntityKey(entityIdentifier, this.concreteDescriptor);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        this.entityInstance = persistenceContext.getEntity(entityKey);
        if (this.entityInstance != null) {
            PersistentAttributeInterceptor interceptor;
            if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)this.entityInstance) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)this.entityInstance).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
                ((EnhancementAsProxyLazinessInterceptor)interceptor).forceInitialize(this.entityInstance, null);
            }
            this.isInitialized = true;
            return CompletionStages.voidFuture();
        }
        LoadingEntityEntry existingLoadingEntry = session.getPersistenceContext().getLoadContexts().findLoadingEntityEntry(entityKey);
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath(), (Object)entityIdentifier));
            }
            this.entityInstance = existingLoadingEntry.getEntityInstance();
            if (existingLoadingEntry.getEntityInitializer() != this) {
                if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                    EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath(), (Object)entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
                }
                this.isInitialized = true;
                return CompletionStages.voidFuture();
            }
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Invoking session#internalLoad for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath(), (Object)entityIdentifier), entityIdentifier);
        }
        return ReactiveQueryExecutorLookup.extract(session).reactiveInternalLoad(entityName, entityIdentifier, true, this.toOneMapping().isInternalLoadNullable()).thenCompose(instance -> {
            this.entityInstance = instance;
            if (this.entityInstance == null && this.toOneMapping().getNotFoundAction() == NotFoundAction.EXCEPTION) {
                return CompletionStages.failedFuture((Throwable)new FetchNotFoundException(entityName, entityIdentifier));
            }
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] : %s has being loaded by session.internalLoad.", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString((NavigablePath)this.getNavigablePath(), (Object)entityIdentifier), entityIdentifier);
            }
            boolean unwrapProxy = this.toOneMapping().isUnwrapProxy() && this.isEnhancedForLazyLoading;
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)this.entityInstance);
            if (lazyInitializer != null) {
                lazyInitializer.setUnwrap(unwrapProxy);
            }
            this.isInitialized = true;
            return CompletionStages.voidFuture();
        });
    }

    protected ToOneAttributeMapping toOneMapping() {
        return (ToOneAttributeMapping)this.getInitializedPart();
    }
}

