/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage.impl;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.reactive.query.ReactiveSelectionQuery;
import org.hibernate.reactive.stage.Stage;

public class StageSelectionQueryImpl<T>
implements Stage.SelectionQuery<T> {
    private final ReactiveSelectionQuery<T> delegate;

    public StageSelectionQueryImpl(ReactiveSelectionQuery<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getMaxResults() {
        return this.delegate.getMaxResults();
    }

    @Override
    public CompletionStage<List<T>> getResultList() {
        return this.delegate.getReactiveResultList();
    }

    @Override
    public FlushMode getFlushMode() {
        return this.delegate.getHibernateFlushMode();
    }

    @Override
    public Stage.SelectionQuery<T> setFlushMode(FlushMode flushMode) {
        this.delegate.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setLockMode(LockMode lockMode) {
        this.delegate.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setPlan(EntityGraph<T> entityGraph) {
        this.delegate.applyGraph((RootGraphImplementor)entityGraph, GraphSemantic.FETCH);
        return this;
    }

    @Override
    public CompletionStage<T> getSingleResult() {
        return this.delegate.getReactiveSingleResult();
    }

    @Override
    public CompletionStage<T> getSingleResultOrNull() {
        return this.delegate.getReactiveSingleResultOrNull();
    }

    @Override
    public Stage.SelectionQuery<T> setFlushMode(FlushModeType flushMode) {
        this.delegate.setFlushMode(flushMode);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public Stage.SelectionQuery<T> setReadOnly(boolean readOnly) {
        this.delegate.setReadOnly(readOnly);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setMaxResults(int maxResult) {
        this.delegate.setMaxResults(maxResult);
        return this;
    }

    @Override
    public int getFirstResult() {
        return this.delegate.getFirstResult();
    }

    @Override
    public Stage.SelectionQuery<T> setFirstResult(int startPosition) {
        this.delegate.setFirstResult(startPosition);
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.delegate.getCacheStoreMode();
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.delegate.getCacheRetrieveMode();
    }

    @Override
    public Stage.SelectionQuery<T> setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this.delegate.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this.delegate.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.delegate.isCacheable();
    }

    @Override
    public Stage.SelectionQuery<T> setCacheable(boolean cacheable) {
        this.delegate.setCacheable(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.delegate.getCacheRegion();
    }

    @Override
    public Stage.SelectionQuery<T> setCacheRegion(String cacheRegion) {
        this.delegate.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setLockMode(LockModeType lockMode) {
        this.delegate.setLockMode(lockMode);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setLockMode(String alias, LockMode lockMode) {
        this.delegate.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setParameter(String name, Object value) {
        this.delegate.setParameter(name, value);
        return this;
    }

    @Override
    public Stage.SelectionQuery<T> setParameter(int position, Object value) {
        this.delegate.setParameter(position, value);
        return this;
    }

    @Override
    public <T1> Stage.SelectionQuery<T> setParameter(Parameter<T1> param, T1 value) {
        this.delegate.setParameter((Parameter)param, (Object)value);
        return this;
    }

    @Override
    public String getComment() {
        return this.delegate.getComment();
    }

    @Override
    public Stage.SelectionQuery<T> setComment(String comment) {
        this.delegate.setComment(comment);
        return this;
    }
}

