/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage.impl;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Attribute;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.CacheMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.RootGraph;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.reactive.common.AffectedEntities;
import org.hibernate.reactive.common.Identifier;
import org.hibernate.reactive.common.ResultSetMapping;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.spi.ReactiveSharedSessionContractImplementor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.session.ReactiveQueryProducer;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.stage.Stage;
import org.hibernate.reactive.stage.impl.StageMutationQueryImpl;
import org.hibernate.reactive.stage.impl.StageQueryImpl;
import org.hibernate.reactive.stage.impl.StageSelectionQueryImpl;
import org.hibernate.reactive.util.impl.CompletionStages;

public class StageSessionImpl
implements Stage.Session {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveSession delegate;
    private Transaction<?> currentTransaction;

    public StageSessionImpl(ReactiveSession session) {
        this.delegate = session;
    }

    @Override
    public CompletionStage<Void> flush() {
        return this.delegate.reactiveFlush();
    }

    @Override
    public <T> CompletionStage<T> fetch(T association) {
        return this.delegate.reactiveFetch(association, false);
    }

    @Override
    public <E, T> CompletionStage<T> fetch(E entity, Attribute<E, T> field) {
        return this.delegate.reactiveFetch(entity, field);
    }

    @Override
    public <T> CompletionStage<T> unproxy(T association) {
        return this.delegate.reactiveFetch(association, true);
    }

    public ReactiveConnection getReactiveConnection() {
        return this.delegate.getReactiveConnection();
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object id) {
        return this.delegate.getReference(entityClass, id);
    }

    @Override
    public <T> T getReference(T entity) {
        return this.delegate.getReference(this.delegate.getEntityClass(entity), this.delegate.getEntityId(entity));
    }

    @Override
    public LockMode getLockMode(Object entity) {
        return this.delegate.getCurrentLockMode(entity);
    }

    @Override
    public boolean contains(Object entity) {
        return this.delegate.contains(entity);
    }

    @Override
    public <R> Stage.SelectionQuery<R> createSelectionQuery(String queryString) {
        return new StageSelectionQueryImpl(this.delegate.createReactiveSelectionQuery(queryString));
    }

    @Override
    public Stage.MutationQuery createMutationQuery(String queryString) {
        return new StageMutationQueryImpl(this.delegate.createReactiveMutationQuery(queryString));
    }

    @Override
    public <T> CompletionStage<T> find(Class<T> entityClass, Object primaryKey) {
        return this.delegate.reactiveFind(entityClass, primaryKey, null, null);
    }

    @Override
    public <T> CompletionStage<List<T>> find(Class<T> entityClass, Object ... ids) {
        return this.delegate.reactiveFind(entityClass, ids);
    }

    @Override
    public <T> CompletionStage<T> find(Class<T> entityClass, Identifier<T> id) {
        return this.delegate.reactiveFind(entityClass, id.namedValues());
    }

    @Override
    public <T> CompletionStage<T> find(Class<T> entityClass, Object primaryKey, LockMode lockMode) {
        return this.delegate.reactiveFind(entityClass, primaryKey, new LockOptions(lockMode), null);
    }

    @Override
    public <T> CompletionStage<T> find(Class<T> entityClass, Object id, LockModeType lockModeType) {
        return this.find(entityClass, id, LockModeTypeHelper.getLockMode((LockModeType)lockModeType));
    }

    public <T> CompletionStage<T> find(Class<T> entityClass, Object primaryKey, LockOptions lockOptions) {
        return this.delegate.reactiveFind(entityClass, primaryKey, lockOptions, null);
    }

    @Override
    public <T> CompletionStage<T> find(EntityGraph<T> entityGraph, Object id) {
        Class entityClass = ((RootGraph)entityGraph).getGraphedType().getJavaType();
        return this.delegate.reactiveFind(entityClass, id, null, entityGraph);
    }

    @Override
    public CompletionStage<Void> persist(Object entity) {
        return this.delegate.reactivePersist(entity);
    }

    @Override
    public CompletionStage<Void> persist(Object ... entity) {
        return CompletionStages.applyToAll(this.delegate::reactivePersist, entity);
    }

    @Override
    public CompletionStage<Void> remove(Object entity) {
        return this.delegate.reactiveRemove(entity);
    }

    @Override
    public CompletionStage<Void> remove(Object ... entity) {
        return CompletionStages.applyToAll(this.delegate::reactiveRemove, entity);
    }

    @Override
    public <T> CompletionStage<T> merge(T entity) {
        return this.delegate.reactiveMerge(entity);
    }

    @Override
    public final CompletionStage<Void> merge(Object ... entity) {
        return CompletionStages.applyToAll(this.delegate::reactiveMerge, entity);
    }

    @Override
    public CompletionStage<Void> refresh(Object entity) {
        return this.delegate.reactiveRefresh(entity, LockOptions.NONE);
    }

    @Override
    public CompletionStage<Void> refresh(Object entity, LockMode lockMode) {
        return this.delegate.reactiveRefresh(entity, new LockOptions(lockMode));
    }

    @Override
    public CompletionStage<Void> refresh(Object entity, LockModeType lockModeType) {
        return Stage.Session.super.refresh(entity, lockModeType);
    }

    public CompletionStage<Void> refresh(Object entity, LockOptions lockOptions) {
        return this.delegate.reactiveRefresh(entity, lockOptions);
    }

    @Override
    public CompletionStage<Void> refresh(Object ... entity) {
        return CompletionStages.applyToAll(e -> this.delegate.reactiveRefresh(e, LockOptions.NONE), entity);
    }

    @Override
    public CompletionStage<Void> lock(Object entity, LockMode lockMode) {
        return this.delegate.reactiveLock(entity, new LockOptions(lockMode));
    }

    @Override
    public CompletionStage<Void> lock(Object entity, LockModeType lockModeType) {
        return Stage.Session.super.lock(entity, lockModeType);
    }

    public CompletionStage<Void> lock(Object entity, LockOptions lockOptions) {
        return this.delegate.reactiveLock(entity, lockOptions);
    }

    @Override
    public FlushMode getFlushMode() {
        switch (this.delegate.getHibernateFlushMode()) {
            case MANUAL: {
                return FlushMode.MANUAL;
            }
            case COMMIT: {
                return FlushMode.COMMIT;
            }
            case AUTO: {
                return FlushMode.AUTO;
            }
            case ALWAYS: {
                return FlushMode.ALWAYS;
            }
        }
        throw LOG.impossibleFlushModeIllegalState();
    }

    @Override
    public Stage.Session setFlushMode(FlushMode flushMode) {
        switch (flushMode) {
            case COMMIT: {
                this.delegate.setHibernateFlushMode(FlushMode.COMMIT);
                break;
            }
            case AUTO: {
                this.delegate.setHibernateFlushMode(FlushMode.AUTO);
                break;
            }
            case MANUAL: {
                this.delegate.setHibernateFlushMode(FlushMode.MANUAL);
                break;
            }
            case ALWAYS: {
                this.delegate.setHibernateFlushMode(FlushMode.ALWAYS);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported flushMode: " + flushMode);
            }
        }
        return this;
    }

    @Override
    public Stage.Session setFlushMode(FlushModeType flushModeType) {
        return Stage.Session.super.setFlushMode(flushModeType);
    }

    @Override
    public Stage.Session setDefaultReadOnly(boolean readOnly) {
        this.delegate.setDefaultReadOnly(readOnly);
        return this;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.delegate.isDefaultReadOnly();
    }

    @Override
    public Stage.Session setReadOnly(Object entityOrProxy, boolean readOnly) {
        this.delegate.setReadOnly(entityOrProxy, readOnly);
        return this;
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        return this.delegate.isReadOnly(entityOrProxy);
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public Stage.Session setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public Stage.Session setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        return Stage.Session.super.setCacheStoreMode(cacheStoreMode);
    }

    @Override
    public Stage.Session setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        return Stage.Session.super.setCacheRetrieveMode(cacheRetrieveMode);
    }

    @Override
    public Stage.Session setBatchSize(Integer batchSize) {
        this.delegate.setBatchSize(batchSize);
        return this;
    }

    @Override
    public Integer getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public Stage.Session detach(Object entity) {
        this.delegate.detach(entity);
        return this;
    }

    @Override
    public Stage.Session clear() {
        this.delegate.clear();
        return this;
    }

    @Override
    public Stage.Session enableFetchProfile(String name) {
        this.delegate.enableFetchProfile(name);
        return this;
    }

    @Override
    public Stage.Session disableFetchProfile(String name) {
        this.delegate.disableFetchProfile(name);
        return this;
    }

    @Override
    public boolean isFetchProfileEnabled(String name) {
        return this.delegate.isFetchProfileEnabled(name);
    }

    @Override
    public Filter enableFilter(String filterName) {
        return this.delegate.enableFilter(filterName);
    }

    @Override
    public void disableFilter(String filterName) {
        this.delegate.disableFilter(filterName);
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        return this.delegate.getEnabledFilter(filterName);
    }

    @Override
    public <T> CompletionStage<T> withTransaction(Function<Stage.Transaction, CompletionStage<T>> work) {
        return this.currentTransaction == null ? new Transaction().execute(work) : work.apply(this.currentTransaction);
    }

    @Override
    public Stage.Transaction currentTransaction() {
        return this.currentTransaction;
    }

    @Override
    public CompletionStage<Void> close() {
        return this.delegate.reactiveClose();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public Stage.SessionFactory getFactory() {
        return (Stage.SessionFactory)this.delegate.getFactory().unwrap(Stage.SessionFactory.class);
    }

    @Override
    public <T> ResultSetMapping<T> getResultSetMapping(Class<T> resultType, String mappingName) {
        return this.delegate.getResultSetMapping(resultType, mappingName);
    }

    @Override
    public <T> EntityGraph<T> getEntityGraph(Class<T> rootType, String graphName) {
        return this.delegate.getEntityGraph(rootType, graphName);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.delegate.createEntityGraph(rootType);
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType, String graphName) {
        return this.delegate.createEntityGraph(rootType, graphName);
    }

    @Override
    public <R> Stage.Query<R> createQuery(String queryString) {
        return new StageQueryImpl(this.delegate.createReactiveQuery(queryString));
    }

    @Override
    public <R> Stage.SelectionQuery<R> createQuery(String queryString, Class<R> resultType) {
        return new StageSelectionQueryImpl<R>(this.delegate.createReactiveQuery(queryString, resultType));
    }

    @Override
    public <R> Stage.MutationQuery createQuery(CriteriaUpdate<R> criteriaUpdate) {
        return new StageMutationQueryImpl<R>(this.delegate.createReactiveMutationQuery(criteriaUpdate));
    }

    @Override
    public <R> Stage.SelectionQuery<R> createQuery(CriteriaQuery<R> criteriaQuery) {
        return new StageSelectionQueryImpl<R>(this.delegate.createReactiveQuery(criteriaQuery));
    }

    @Override
    public <R> Stage.MutationQuery createQuery(CriteriaDelete<R> criteriaDelete) {
        return new StageMutationQueryImpl<R>(this.delegate.createReactiveMutationQuery(criteriaDelete));
    }

    @Override
    public <R> Stage.Query<R> createNamedQuery(String queryName) {
        return new StageQueryImpl(this.delegate.createReactiveNamedQuery(queryName, null));
    }

    @Override
    public <R> Stage.SelectionQuery<R> createNamedQuery(String queryName, Class<R> resultType) {
        return new StageSelectionQueryImpl<R>(this.delegate.createReactiveNamedQuery(queryName, resultType));
    }

    @Override
    public <R> Stage.SelectionQuery<R> createNativeQuery(String queryString, Class<R> resultType) {
        return new StageSelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultType));
    }

    @Override
    public <R> Stage.SelectionQuery<R> createNativeQuery(String queryString, Class<R> resultType, AffectedEntities affectedEntities) {
        return new StageSelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultType, affectedEntities));
    }

    @Override
    public <R> Stage.SelectionQuery<R> createNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping) {
        return new StageSelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultSetMapping));
    }

    @Override
    public <R> Stage.SelectionQuery<R> createNativeQuery(String queryString, ResultSetMapping<R> resultSetMapping, AffectedEntities affectedEntities) {
        return new StageSelectionQueryImpl<R>(this.delegate.createReactiveNativeQuery(queryString, resultSetMapping, affectedEntities));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String queryString) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(queryString));
    }

    @Override
    public <R> Stage.Query<R> createNativeQuery(String queryString, AffectedEntities affectedEntities) {
        return new StageQueryImpl(this.delegate.createReactiveNativeQuery(queryString, affectedEntities));
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ReactiveConnectionSupplier.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        if (ReactiveSession.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        if (ReactiveQueryProducer.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        if (ReactiveSharedSessionContractImplementor.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.delegate);
        }
        throw new PersistenceException("Cannot unwrap type " + clazz);
    }

    private class Transaction<T>
    implements Stage.Transaction {
        boolean rollback;
        Throwable error;

        private Transaction() {
        }

        CompletionStage<T> execute(Function<Stage.Transaction, CompletionStage<T>> work) {
            StageSessionImpl.this.currentTransaction = this;
            return this.begin().thenCompose(v -> this.executeInTransaction(work)).whenComplete((t, x) -> {
                StageSessionImpl.this.currentTransaction = null;
            });
        }

        CompletionStage<T> executeInTransaction(Function<Stage.Transaction, CompletionStage<T>> work) {
            return work.apply(this).thenCompose(result -> this.flush().thenApply(v -> result)).handle(this::processError).thenCompose(result -> this.end().handle(this::processError).thenApply(v -> CompletionStages.returnOrRethrow(this.error, result)));
        }

        CompletionStage<Void> flush() {
            return StageSessionImpl.this.delegate.reactiveAutoflush();
        }

        CompletionStage<Void> begin() {
            return StageSessionImpl.this.delegate.getReactiveConnection().beginTransaction();
        }

        CompletionStage<Void> end() {
            ReactiveActionQueue actionQueue = StageSessionImpl.this.delegate.getReactiveActionQueue();
            return actionQueue.beforeTransactionCompletion().thenApply(v -> StageSessionImpl.this.delegate.getReactiveConnection()).thenCompose(c -> this.rollback ? c.rollbackTransaction() : c.commitTransaction()).thenCompose(v -> actionQueue.afterTransactionCompletion(!this.rollback));
        }

        <R> R processError(R result, Throwable e) {
            if (e != null) {
                this.rollback = true;
                if (this.error == null) {
                    this.error = e;
                } else {
                    this.error.addSuppressed(e);
                }
            }
            return result;
        }

        @Override
        public void markForRollback() {
            this.rollback = true;
        }

        @Override
        public boolean isMarkedForRollback() {
            return this.rollback;
        }
    }
}

