/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.StringHelper;

abstract class CollectionAction
implements Executable,
Serializable,
Comparable {
    private transient CollectionPersister persister;
    private Serializable key;
    private SessionImplementor session;
    private CacheConcurrencyStrategy.SoftLock lock;
    private String collectionRole;

    public CollectionAction(CollectionPersister persister, Serializable key, SessionImplementor session) throws CacheException {
        this.persister = persister;
        this.session = session;
        this.key = key;
        this.collectionRole = persister.getRole();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.persister = this.session.getFactory().getCollectionPersister(this.collectionRole);
    }

    public void afterTransactionCompletion(boolean success) throws CacheException {
        CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode());
        if (this.persister.hasCache()) {
            this.persister.getCache().release(ck, this.lock);
        }
    }

    public boolean hasAfterTransactionCompletion() {
        return this.persister.hasCache();
    }

    public Serializable[] getPropertySpaces() {
        return this.persister.getCollectionSpaces();
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getKey() {
        return this.key;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    public final void beforeExecutions() throws CacheException {
        CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode());
        if (this.persister.hasCache()) {
            this.lock = this.persister.getCache().lock(ck, null);
        }
    }

    protected final void evict() throws CacheException {
        CacheKey ck = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode());
        if (this.persister.hasCache()) {
            this.persister.getCache().evict(ck);
        }
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.collectionRole, this.key);
    }

    public int compareTo(Object other) {
        CollectionAction action = (CollectionAction)other;
        int roleComparison = this.collectionRole.compareTo(action.collectionRole);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.persister.getKeyType().compare(this.key, action.key, this.session.getEntityMode());
    }
}

