/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class StandardQueryCache
implements QueryCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$cache$StandardQueryCache == null ? (class$org$hibernate$cache$StandardQueryCache = StandardQueryCache.class$("org.hibernate.cache.StandardQueryCache")) : class$org$hibernate$cache$StandardQueryCache));
    private Cache queryCache;
    private UpdateTimestampsCache updateTimestampsCache;
    private final String regionName;
    static /* synthetic */ Class class$org$hibernate$cache$StandardQueryCache;

    public void clear() throws CacheException {
        this.queryCache.clear();
    }

    public StandardQueryCache(Settings settings, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) throws HibernateException {
        String prefix;
        if (regionName == null) {
            regionName = (class$org$hibernate$cache$StandardQueryCache == null ? (class$org$hibernate$cache$StandardQueryCache = StandardQueryCache.class$("org.hibernate.cache.StandardQueryCache")) : class$org$hibernate$cache$StandardQueryCache).getName();
        }
        if ((prefix = settings.getCacheRegionPrefix()) != null) {
            regionName = prefix + '.' + regionName;
        }
        log.info((Object)("starting query cache at region: " + regionName));
        this.queryCache = settings.getCacheProvider().buildCache(regionName, props);
        this.updateTimestampsCache = updateTimestampsCache;
        this.regionName = regionName;
    }

    public void put(QueryKey key, Type[] returnTypes, List result, SessionImplementor session) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("caching query results in region: " + this.regionName));
        }
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        cacheable.add(new Long(session.getTimestamp()));
        for (int i = 0; i < result.size(); ++i) {
            if (returnTypes.length == 1) {
                cacheable.add(returnTypes[0].disassemble(result.get(i), session, null));
                continue;
            }
            cacheable.add(TypeFactory.disassemble((Object[])result.get(i), returnTypes, session, null));
        }
        this.queryCache.put(key, cacheable);
    }

    public List get(QueryKey key, Type[] returnTypes, Set spaces, SessionImplementor session) throws HibernateException {
        List cacheable;
        if (log.isDebugEnabled()) {
            log.debug((Object)("checking cached query results in region: " + this.regionName));
        }
        if ((cacheable = (List)this.queryCache.get(key)) == null) {
            log.debug((Object)"query results were not found in cache");
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
        Long timestamp = (Long)cacheable.get(0);
        log.debug((Object)("Checking query spaces for up-to-dateness: [" + spaces + "]"));
        if (!this.isUpToDate(spaces, timestamp)) {
            log.debug((Object)"cached query results were not up to date");
            return null;
        }
        log.debug((Object)"returning cached query results");
        for (int i = 1; i < cacheable.size(); ++i) {
            if (returnTypes.length == 1) {
                result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                continue;
            }
            result.add(TypeFactory.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
        }
        return result;
    }

    protected boolean isUpToDate(Set spaces, Long timestamp) {
        return this.updateTimestampsCache.isUpToDate(spaces, timestamp);
    }

    public void destroy() {
        try {
            this.queryCache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)("could not destroy query cache: " + this.regionName), (Throwable)e);
        }
    }

    public Cache getCache() {
        return this.queryCache;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String toString() {
        return "StandardQueryCache(" + this.regionName + ')';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

