/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentList
extends AbstractPersistentCollection
implements List {
    private List list;

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        ArrayList<Object> clonedList = new ArrayList<Object>(this.list.size());
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            clonedList.add(persister.getElementType().deepCopy(iter.next(), entityMode, persister.getFactory()));
        }
        return clonedList;
    }

    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return PersistentList.getOrphans(sn, this.list, entityName, this.getSession());
    }

    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.list.size()) {
            return false;
        }
        Iterator iter = this.list.iterator();
        Iterator sniter = sn.iterator();
        while (iter.hasNext()) {
            if (!elementType.isDirty(iter.next(), sniter.next(), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public PersistentList(SessionImplementor session) {
        super(session);
    }

    public PersistentList(SessionImplementor session, List list) {
        super(session);
        this.list = list;
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.list = new ArrayList();
    }

    public boolean isWrapper(Object collection) {
        return this.list == collection;
    }

    public PersistentList() {
    }

    public int size() {
        this.read();
        return this.list.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.list.isEmpty();
    }

    public boolean contains(Object object) {
        this.read();
        return this.list.contains(object);
    }

    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.list.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.list.toArray();
    }

    public Object[] toArray(Object[] array) {
        this.read();
        return this.list.toArray(array);
    }

    public boolean add(Object object) {
        if (!this.queueAdd(object)) {
            this.write();
            return this.list.add(object);
        }
        return true;
    }

    public boolean remove(Object value) {
        this.write();
        return this.list.remove(value);
    }

    public boolean containsAll(Collection coll) {
        this.read();
        return this.list.containsAll(coll);
    }

    public boolean addAll(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        if (!this.queueAddAll(c)) {
            this.write();
            return this.list.addAll(c);
        }
        return c.size() > 0;
    }

    public void delayedAddAll(Collection c) {
        this.list.addAll(c);
    }

    public boolean addAll(int index, Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.list.addAll(index, coll);
        }
        return false;
    }

    public boolean removeAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.list.removeAll(coll);
        }
        return false;
    }

    public boolean retainAll(Collection coll) {
        this.write();
        return this.list.retainAll(coll);
    }

    public void clear() {
        this.write();
        this.list.clear();
    }

    public Object get(int index) {
        this.read();
        return this.list.get(index);
    }

    public Object set(int index, Object value) {
        this.write();
        return this.list.set(index, value);
    }

    public void add(int index, Object value) {
        this.write();
        this.list.add(index, value);
    }

    public Object remove(int index) {
        this.write();
        return this.list.remove(index);
    }

    public int indexOf(Object value) {
        this.read();
        return this.list.indexOf(value);
    }

    public int lastIndexOf(Object value) {
        this.read();
        return this.list.lastIndexOf(value);
    }

    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.list.listIterator());
    }

    public ListIterator listIterator(int index) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.list.listIterator(index));
    }

    public List subList(int from, int to) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.list.subList(from, to));
    }

    public boolean empty() {
        return this.list.isEmpty();
    }

    public String toString() {
        this.read();
        return this.list.toString();
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        int index = (Integer)persister.readIndex(rs, this.getSession());
        for (int i = this.list.size(); i <= index; ++i) {
            this.list.add(i, null);
        }
        this.list.set(index, element);
        return element;
    }

    public Iterator entries(CollectionPersister persister) {
        return this.list.iterator();
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; ++i) {
            this.list.add(persister.getElementType().assemble(array[i], this.getSession(), owner));
        }
        this.setInitialized();
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.list.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = persister.getElementType().disassemble(this.list.get(i), this.getSession(), null);
        }
        return result;
    }

    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        int end;
        int i;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() > this.list.size()) {
            for (i = this.list.size(); i < sn.size(); ++i) {
                deletes.add((Integer)(indexIsFormula ? sn.get(i) : new Integer(i)));
            }
            end = this.list.size();
        } else {
            end = sn.size();
        }
        for (i = 0; i < end; ++i) {
            if (this.list.get(i) != null || sn.get(i) == null) continue;
            deletes.add((Integer)(indexIsFormula ? sn.get(i) : new Integer(i)));
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        return this.list.get(i) != null && (i >= sn.size() || sn.get(i) == null);
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        return i < sn.size() && sn.get(i) != null && this.list.get(i) != null && elemType.isDirty(this.list.get(i), sn.get(i), this.getSession());
    }

    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        return new Integer(i);
    }

    public Object getElement(Object entry) {
        return entry;
    }

    public Object getSnapshotElement(Object entry, int i) {
        List sn = (List)((Object)this.getSnapshot());
        return sn.get(i);
    }

    public boolean equals(Object other) {
        this.read();
        return ((Object)this.list).equals(other);
    }

    public int hashCode() {
        this.read();
        return ((Object)this.list).hashCode();
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null || i == this.list.size() - 1;
    }
}

